/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HttpUnitOptions;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class TestWatchers
extends JIRAWebTest {
    private static final Issue ISSUE = new Issue("HSP-1", 10000L);
    private static final String MANAGE_WATCHERS = "Watchers";
    private static final String ID_WATCH_LINK = "watching-toggle";
    private static final String ID_WATCH_SPAN = "watch-label";
    private static final String ID_VIEW_WATCHERS_LINK = "view-watcher-list";
    private static final String ID_WATCH_DATA = "watcher-data";
    private static final String ID_WATCH_ACTION = "toggle-watch-issue";
    private static final String ID_MANAGE_WATCHERS = "manage-watchers";
    private static final String XPATH_WATCHERS_SPAN_TITLE = String.format("//span[@id='%s']/@title", "watch-label");
    private static final String XPATH_WATCHERS_LINK_TITLE = String.format("//a[@id='%s']/@title", "watching-toggle");
    private static final String MSG_MUST_BE_LOGGED_IN = "You have to be logged in to watch an issue.";
    private static final String MSG_GUEST_PERM = "You must log in to access this page";
    private static final String MSG_START_WATCHING = "Start watching this issue";
    private static final String MSG_STOP_WATCHING = "Stop watching this issue";
    private static final String TITLE_WATCHING = "Watching";
    private static final String TITLE_WATCH = "Watch";

    public TestWatchers(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testManageWatchers() {
        this.restoreData("TestWatchers.xml");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        try {
            this.watcherOperationRemove();
            this.watcherOperationDeleteWatcher();
            this.addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
            this.addUserToGroup("bob", "jira-developers");
            this.watcherOperationViewWatchingWithWatchPermission();
            this.watcherOperationWithManageandViewWatchingPermission();
            this.watcherOperationManageWatchingWithWatchPermission();
            this.login("admin", "admin");
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
    }

    public void testAnonymUserCannotWatch() {
        this.restoreData("TestWatchers.xml");
        this.logout();
        this.gotoIssue(ISSUE);
        this.tester.assertLinkNotPresent(ID_WATCH_LINK);
        this.tester.assertLinkNotPresent(ID_WATCH_ACTION);
        this.assertTextPresentInElement(ID_WATCH_SPAN, TITLE_WATCH);
        TestWatchers.assertEquals((String)MSG_MUST_BE_LOGGED_IN, (String)this.getXpathText(XPATH_WATCHERS_SPAN_TITLE));
        TestWatchers.assertEquals((int)0, (int)this.getWatchCount());
        this.watchIssueDirectly(ISSUE);
        this.assertions.getTextAssertions().assertTextPresent(new WebPageLocator(this.tester), MSG_GUEST_PERM);
        this.gotoIssue(ISSUE);
        TestWatchers.assertEquals((int)0, (int)this.getWatchCount());
        this.login("admin", "admin");
    }

    public void testUserCanWatch() throws Exception {
        this.restoreData("TestWatchers.xml");
        this.gotoIssue(ISSUE);
        this.assertNotWatching(0);
        this.tester.clickLink(ID_WATCH_LINK);
        this.assertWatching(1);
        this.watchIssueDirectly(ISSUE);
        this.assertWatching(1);
        this.tester.clickLink(ID_WATCH_LINK);
        this.assertNotWatching(0);
        this.unwatchIssueDirectly(ISSUE);
        this.assertNotWatching(0);
    }

    public void testCannotAddWatchersWhoDontHavePermissionToViewIssue() throws Exception {
        this.administration.restoreData("TestWatchersCannotAddUserWithNoPerms.xml");
        this._testCannotAddWatchersWhoDontHavePermissionToViewIssue("HSP-1");
        this._testCannotAddWatchersWhoDontHavePermissionToViewIssue("MKY-1");
    }

    public void testAddBadNames() throws Exception {
        this.administration.restoreData("TestWatchersCannotAddUserWithNoPerms.xml");
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLink(ID_MANAGE_WATCHERS);
        this.tester.setWorkingForm("startform");
        this.tester.submit("add");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "You must select a user.");
        this.tester.setWorkingForm("startform");
        this.tester.setFormElement("userNames", "nonexistentuser");
        this.tester.submit("add");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "The user \"nonexistentuser\" could not be found. This user will not be added to the watch list.");
        this.tester.setWorkingForm("startform");
        this.tester.setFormElement("userNames", "a, b, admin, c");
        this.tester.submit("add");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "The user \"a\" could not be found. This user will not be added to the watch list.");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "The user \"b\" could not be found. This user will not be added to the watch list.");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "The user \"c\" could not be found. This user will not be added to the watch list.");
        this.tester.assertLinkNotPresentWithText("Watch Issue");
        this.tester.assertLinkPresentWithText("Stop Watching");
    }

    public void testBackToIssueLink() {
        this.restoreData("TestWatchers.xml");
        this.gotoIssue(ISSUE);
        this.clickLink(ID_VIEW_WATCHERS_LINK);
        this.assertions.assertNodeByIdExists("back-lnk");
        this.clickLink("back-lnk");
        this.assertions.assertNodeByIdExists(ID_VIEW_WATCHERS_LINK);
    }

    private void _testCannotAddWatchersWhoDontHavePermissionToViewIssue(String issueKey) {
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink(ID_MANAGE_WATCHERS);
        this.tester.assertLinkPresentWithText("Watch Issue");
        this.tester.assertLinkNotPresentWithText("Stop Watching");
        this.tester.setWorkingForm("startform");
        this.tester.setFormElement("userNames", "fred, admin");
        this.tester.submit("add");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "The user \"fred\" does not have permission to view this issue. This user will not be added to the watch list.");
        this.tester.assertLinkNotPresentWithText("Watch Issue");
        this.tester.assertLinkPresentWithText("Stop Watching");
    }

    private void watcherOperationRemove() {
        TestWatchers.log("Watcher Operation: Test the ability to manage watchers");
        this.startWatchingAnIssue(ISSUE.getKey());
        this.gotoIssue(ISSUE);
        this.clickLink(ID_MANAGE_WATCHERS);
        this.assertTextPresent(MANAGE_WATCHERS);
        this.assertLinkPresent("watcher_link_admin");
        this.checkCheckbox("all");
        this.assertCheckboxSelected("all");
        this.getDialog().setWorkingForm("stopform");
        this.submit();
        this.assertTextPresent("There are currently no watchers associated with this issue.");
    }

    private void watcherOperationDeleteWatcher() {
        TestWatchers.log("Watcher Operation: Test that a user's watcher association is removed when the user is deleted");
        this.startWatchingAnIssue(ISSUE.getKey(), new String[]{"bob", "admin"});
        this.deleteUser("bob");
        this.gotoIssue(ISSUE);
        this.clickLink(ID_VIEW_WATCHERS_LINK);
        this.assertLinkNotPresent("watcher_link_bob");
        this.assertLinkPresent("watcher_link_admin");
        this.removeAllWatchers(ISSUE.getKey());
    }

    private void watcherOperationViewWatchingWithWatchPermission() {
        TestWatchers.log("Watcher Operation: Test the availabilty of the 'View Watchers' Link with 'View Voters and Watchers' Permission");
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(ISSUE);
        this.assertManageLinksPresent();
        this.removeGroupPermission(31, "jira-developers");
        this.removeGroupPermission(32, "jira-administrators");
        this.gotoIssue(ISSUE);
        this.assertManageLinksNotPresent();
        this.grantGroupPermission(31, "jira-developers");
        this.grantGroupPermission(32, "jira-administrators");
    }

    private void assertManageLinksPresent() {
        this.assertLinkPresent(ID_VIEW_WATCHERS_LINK);
        this.assertLinkPresent(ID_MANAGE_WATCHERS);
    }

    private void assertManageLinksNotPresent() {
        this.assertLinkNotPresent(ID_MANAGE_WATCHERS);
        this.assertLinkNotPresent(ID_VIEW_WATCHERS_LINK);
    }

    private void watcherOperationManageWatchingWithWatchPermission() {
        TestWatchers.log("Watcher Operation: Test the availabilty of the 'Manage Watchers'link with the 'Manage Watchers' Permission");
        this.removeGroupPermission(31, "jira-developers");
        this.startWatchingAnIssue(ISSUE.getKey(), new String[]{"fred"});
        this.logout();
        this.login("bob", "bob");
        this.gotoIssue(ISSUE);
        this.assertManageLinksNotPresent();
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(ISSUE);
        this.clickLink(ID_MANAGE_WATCHERS);
        this.assertTextPresent(MANAGE_WATCHERS);
        this.grantGroupPermission(31, "jira-developers");
        this.logout();
        this.login("bob", "bob");
        this.gotoIssue(ISSUE);
        this.clickLink(ID_MANAGE_WATCHERS);
        this.assertTextNotPresent("Add Watchers");
        this.logout();
        this.login("admin", "admin");
        this.grantPermissionToReporter(32);
        this.logout();
        this.login("bob", "bob");
        this.gotoIssue(ISSUE);
        this.clickLink(ID_MANAGE_WATCHERS);
        this.assertTextNotPresent("Add Watchers");
        this.logout();
        this.login("admin", "admin");
    }

    private void watcherOperationWithManageandViewWatchingPermission() {
        TestWatchers.log("Watcher Operation: Test the difference between viewing and managing watcher lists");
        this.startWatchingAnIssue(ISSUE.getKey());
        this.gotoIssue(ISSUE);
        this.clickLink(ID_MANAGE_WATCHERS);
        this.assertFormElementPresent("stopwatch_admin");
        this.grantGroupPermission(31, "jira-users");
        this.logout();
        this.login("bob", "bob");
        this.gotoIssue(ISSUE);
        this.clickLink(ID_MANAGE_WATCHERS);
        this.assertFormElementNotPresent("stopwatch_admin");
        this.logout();
        this.login("admin", "admin");
        this.stopWatchingAnIssue(ISSUE.getKey());
        this.removeGroupPermission(31, "jira-users");
    }

    private void assertTextPresentInElement(String elementId, String expectedText) {
        this.assertions.getTextAssertions().assertTextPresent(new IdLocator(this.tester, elementId), expectedText);
    }

    private void assertWatching(int watcherCount) {
        this.tester.assertLinkPresent(ID_WATCH_LINK);
        this.tester.assertLinkPresent(ID_WATCH_ACTION);
        this.tester.assertTextInElement(ID_WATCH_ACTION, "Stop Watching");
        this.assertTextPresentInElement(ID_WATCH_LINK, TITLE_WATCHING);
        TestWatchers.assertEquals((String)MSG_STOP_WATCHING, (String)this.getXpathText(XPATH_WATCHERS_LINK_TITLE));
        TestWatchers.assertEquals((int)watcherCount, (int)this.getWatchCount());
        this.assertTextInElement(ID_WATCH_ACTION, "Stop Watching");
    }

    private void assertNotWatching(int watcherCount) {
        this.tester.assertTextPresent(ID_WATCH_LINK);
        this.tester.assertLinkPresent(ID_WATCH_ACTION);
        this.tester.assertTextInElement(ID_WATCH_ACTION, TITLE_WATCH);
        this.assertTextPresentInElement(ID_WATCH_LINK, TITLE_WATCH);
        TestWatchers.assertEquals((String)MSG_START_WATCHING, (String)this.getXpathText(XPATH_WATCHERS_LINK_TITLE));
        TestWatchers.assertEquals((int)watcherCount, (int)this.getWatchCount());
        this.assertTextInElement(ID_WATCH_ACTION, TITLE_WATCH);
    }

    private void gotoIssue(Issue issue) {
        this.navigation.issue().gotoIssue(issue.getKey());
    }

    private String getXpathText(String xpath) {
        return StringUtils.trimToNull((String)new XPathLocator(this.tester, xpath).getText());
    }

    private int getWatchCount() {
        String s = StringUtils.trimToNull((String)new IdLocator(this.tester, ID_WATCH_DATA).getText());
        if (s != null) {
            return Integer.parseInt(s);
        }
        TestWatchers.fail((String)"Unable to find watch count.");
        return Integer.MIN_VALUE;
    }

    private void watchIssueDirectly(Issue issue) {
        this.navigation.gotoPage(this.page.addXsrfToken(String.format("/secure/VoteOrWatchIssue.jspa?id=%d&watch=watch", issue.getId())));
    }

    private void unwatchIssueDirectly(Issue issue) {
        this.navigation.gotoPage(this.page.addXsrfToken(String.format("/secure/VoteOrWatchIssue.jspa?id=%d&watch=unwatch", issue.getId())));
    }

    private static class Issue {
        private final String key;
        private final long id;

        private Issue(String key, long id) {
            this.key = key;
            this.id = id;
        }

        public String getKey() {
            return this.key;
        }

        public long getId() {
            return this.id;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

