/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestOpsBarStructure
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestOpsBar.xml");
    }

    public void testWorkflows() {
        this.navigation.issue().viewIssue("HSP-1");
        this.assertExtraTransitionsExist();
        this.navigation.issue().viewIssue("HSP-2");
        if (this.referencePluginEnabled()) {
            this.assertOnlyReferenceTransitionExists();
        } else {
            this.assertOnlyStandardTransitions();
        }
        this.navigation.issue().viewIssue("HSP-3");
        if (this.referencePluginEnabled()) {
            this.assertOnlyReferenceTransitionExists();
        } else {
            this.assertOnlyStandardTransitions();
        }
        this.navigation.issue().viewIssue("HSP-4");
        if (this.referencePluginEnabled()) {
            this.assertOnlyReferenceTransitionExists();
        } else {
            this.assertNoTransitions();
        }
    }

    private boolean referencePluginEnabled() {
        return new XPathLocator(this.tester, "//a[@id='reference-operation']").exists();
    }

    private void assertNoTransitions() {
        this.assertions.assertNodeDoesNotExist("//span[@id='opsbar-transitions_more']");
        this.assertions.assertNodeDoesNotExist("//a[@id='opsbar-transitions_more']");
    }

    private void assertOnlyStandardTransitions() {
        this.assertions.assertNodeExists("//span[@id='opsbar-transitions_more']");
        this.assertions.assertNodeDoesNotExist("//a[@id='opsbar-transitions_more']");
    }

    private void assertExtraTransitionsExist() {
        this.assertions.assertNodeDoesNotExist("//span[@id='opsbar-transitions_more']");
        this.assertions.assertNodeExists("//a[@id='opsbar-transitions_more']");
    }

    private void assertOnlyReferenceTransitionExists() {
        this.assertions.assertNodeExists(new CssLocator(this.tester, "ul.aui-last > li > #reference-operation"));
    }

    public void testConjoined() {
        this.navigation.issue().viewIssue("HSP-5");
        String operationsGroup = "//div[@class='ops-menus']/ul[2]";
        this.assertions.assertNodeHasText(operationsGroup + "/li[1]", "Assign");
        this.assertions.assertNodeHasText(operationsGroup + "/li[2]", "Assign To Me");
        this.assertions.assertNodeHasText(operationsGroup + "/li[3]", "Comment");
        this.assertions.assertNodeDoesNotHaveText(operationsGroup + "/li[3]", "More Actions");
        this.assertions.assertNodeByIdExists("opsbar-operations_more");
        this.navigation.issue().viewIssue("HSP-2");
        this.assertions.assertNodeHasText(operationsGroup + "/li[1]", "Assign");
        this.assertions.assertNodeHasText(operationsGroup + "/li[2]", "Comment");
        this.assertions.assertNodeByIdExists("opsbar-operations_more");
    }

    public void testLoginButton() {
        this.navigation.logout();
        this.navigation.issue().viewIssue("ANONED-1");
        IdLocator locator = new IdLocator(this.tester, "ops-login");
        TestOpsBarStructure.assertEquals((int)0, (int)locator.getNodes().length);
        this.navigation.issue().viewIssue("ANON-1");
        locator = new IdLocator(this.tester, "ops-login");
        TestOpsBarStructure.assertEquals((int)1, (int)locator.getNodes().length);
        this.tester.clickLink("ops-login-lnk");
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        this.text.assertTextPresent(new IdLocator(this.tester, "issue_header_summary"), "Anon viewable issue");
        locator = new IdLocator(this.tester, "ops-login");
        TestOpsBarStructure.assertEquals((int)0, (int)locator.getNodes().length);
    }

    public void testOpsbarTransitionOrder() {
        this.administration.restoreData("TestOpsbarTransitionOrder.xml");
        this.navigation.issue().viewIssue("HSP-1");
        String operationsGroup = "//div[@class='ops-menus']/ul[3]";
        String[] originalOrder = new String[]{"Start Progress", "Resolve Issue", "Close Issue"};
        String[] newOrder = new String[]{"Close Issue", "Resolve Issue", "Start Progress"};
        this.assertTransitionOrder("//div[@class='ops-menus']/ul[3]", originalOrder);
        this.navigation.gotoAdminSection("workflows");
        this.tester.clickLink("createDraft_Copy of jira");
        this.tester.clickLinkWithText("Start Progress");
        this.tester.clickLinkWithText("properties of this transition");
        this.tester.clickLink("del_meta_opsbar-sequence");
        this.tester.setFormElement("attributeKey", "opsbar-sequence");
        this.tester.setFormElement("attributeValue", "100");
        this.tester.submit("Add");
        this.text.assertTextSequence(new TableLocator(this.tester, "metas_table"), "opsbar-sequence", "100");
        this.navigation.gotoAdminSection("workflows");
        this.tester.clickLink("steps_draft_Copy of jira");
        this.tester.clickLinkWithText("Close Issue");
        this.tester.clickLinkWithText("properties of this transition");
        this.tester.clickLink("del_meta_opsbar-sequence");
        this.tester.setFormElement("attributeKey", "opsbar-sequence");
        this.tester.setFormElement("attributeValue", "20");
        this.tester.submit("Add");
        this.text.assertTextSequence(new TableLocator(this.tester, "metas_table"), "opsbar-sequence", "20");
        this.navigation.gotoAdminSection("workflows");
        this.tester.clickLink("publishDraft_Copy of jira");
        this.tester.checkCheckbox("enableBackup", "false");
        this.tester.submit("Publish");
        this.navigation.issue().viewIssue("HSP-1");
        this.assertTransitionOrder("//div[@class='ops-menus']/ul[3]", newOrder);
    }

    private void assertTransitionOrder(String operationsGroup, String[] expectedText) {
        this.assertions.getTextAssertions().assertTextSequence(new XPathLocator(this.tester, operationsGroup), expectedText);
    }
}

