/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.PERMISSIONS})
public class TestIssueOperationsWithLimitedPermissions
extends JIRAWebTest {
    public static final String RESTRICTED_ISSUE_ID = "10000";
    public static final String CLOSED_ISSUE_ID = "10020";
    public static final String PERMISSION_ERROR_DESC_ANONYMOUS = "You are not logged in, and do not have the permissions required to act on the selected issue as a guest.";
    public static final String PERMISSION_ERROR_DESC_ANONYMOUS_DIALOG = "You do not have the permission to see the specified issue";
    public static final String PERMISSION_ERROR_DESC_USER = "You do not have permission to act on this issue.";
    private static final String LOGIN = "log in";
    private static final String SIGNUP = "sign up";
    private static final String YOU_CANNOT_VIEW_THIS_AS_A_GUEST = "You must log in to access this page.";

    public TestIssueOperationsWithLimitedPermissions(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.login("admin", "admin");
        this.restoreData("TestIssueOperationsWithLimitedPermissionsProEnt.xml");
    }

    public void testIssueOperationsWithLimitedPermissions() {
        this.assertActionIsInaccessibleToAnonymousUser("ViewIssue.jspa?", "new test issue", YOU_CANNOT_VIEW_THIS_AS_A_GUEST, true);
        this.assertActionIsInaccessibleToUser("ViewIssue.jspa?", "new test issue", "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsAccessibleToAdmin("ViewIssue.jspa?", "new test issue", YOU_CANNOT_VIEW_THIS_AS_A_GUEST);
        this.assertActionIsInaccessibleToAnonymousUser("VoteOrWatchIssue.jspa?vote=vote&", "new test issue", YOU_CANNOT_VIEW_THIS_AS_A_GUEST, true);
        this.assertActionIsInaccessibleToUser("VoteOrWatchIssue.jspa?vote=vote&", "new test issue", "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsAccessibleToAdmin("VoteOrWatchIssue.jspa?vote=vote&", "new test issue", YOU_CANNOT_VIEW_THIS_AS_A_GUEST);
        this.assertLinkPresent("toggle-vote-issue");
        this.text.assertTextPresent(new IdLocator(this.tester, "toggle-vote-issue"), "Remove Vote");
        this.text.assertTextNotPresent(new IdLocator(this.tester, "toggle-vote-issue"), "Add Vote");
        this.assertActionIsInaccessibleToAdminForClosedIssue("VoteOrWatchIssue.jspa?vote=vote&", "An issue that will be closed!", "You cannot vote or change your vote on resolved issues.");
        this.assertActionIsInaccessibleToAnonymousUser("VoteOrWatchIssue.jspa?vote=unvote&", "new test issue", YOU_CANNOT_VIEW_THIS_AS_A_GUEST, true);
        this.assertActionIsInaccessibleToUser("VoteOrWatchIssue.jspa?vote=unvote&", "new test issue", "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsAccessibleToAdmin("VoteOrWatchIssue.jspa?vote=unvote&", "new test issue", YOU_CANNOT_VIEW_THIS_AS_A_GUEST);
        this.assertLinkPresent("toggle-vote-issue");
        this.text.assertTextPresent(new IdLocator(this.tester, "toggle-vote-issue"), "Add Vote");
        this.text.assertTextNotPresent(new IdLocator(this.tester, "toggle-vote-issue"), "Remove Vote");
        this.assertActionIsInaccessibleToAdminForClosedIssue("VoteOrWatchIssue.jspa?vote=unvote&", "An issue that will be closed!", "You cannot vote or change your vote on resolved issues.");
        this.assertActionIsInaccessibleToAnonymousUser("VoteOrWatchIssue.jspa?watch=watch&", "new test issue", YOU_CANNOT_VIEW_THIS_AS_A_GUEST, true);
        this.assertActionIsInaccessibleToUser("VoteOrWatchIssue.jspa?watch=watch&", "new test issue", "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsAccessibleToAdmin("VoteOrWatchIssue.jspa?watch=watch&", "new test issue", YOU_CANNOT_VIEW_THIS_AS_A_GUEST);
        this.assertLinkPresent("toggle-watch-issue");
        this.text.assertTextPresent(new IdLocator(this.tester, "toggle-watch-issue"), "Stop Watching");
        this.text.assertTextNotPresent(new IdLocator(this.tester, "toggle-watch-issue"), "Watch Issue");
        this.assertActionIsInaccessibleToAnonymousUser("VoteOrWatchIssue.jspa?watch=unwatch&", "new test issue", YOU_CANNOT_VIEW_THIS_AS_A_GUEST, true);
        this.assertActionIsInaccessibleToUser("VoteOrWatchIssue.jspa?watch=unwatch&", "new test issue", "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsAccessibleToAdmin("VoteOrWatchIssue.jspa?watch=unwatch&", "new test issue", YOU_CANNOT_VIEW_THIS_AS_A_GUEST);
        this.assertLinkPresent("toggle-watch-issue");
        this.text.assertTextNotPresent(new IdLocator(this.tester, "toggle-watch-issue"), "Stop Watching");
        this.text.assertTextPresent(new IdLocator(this.tester, "toggle-watch-issue"), "Watch Issue");
        this.assertActionIsInaccessibleToAnonymousUser("WorkflowUIDispatcher.jspa?action=5&", "Resolve Issue", YOU_CANNOT_VIEW_THIS_AS_A_GUEST, true);
        this.assertActionIsInaccessibleToUser("WorkflowUIDispatcher.jspa?action=5&", "Resolve Issue", "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsAccessibleToAdmin("WorkflowUIDispatcher.jspa?action=5&", "Resolve Issue", YOU_CANNOT_VIEW_THIS_AS_A_GUEST);
        this.assertActionIsInaccessibleToAnonymousUser("AssignIssue!default.jspa?", "assign-issue-submit", PERMISSION_ERROR_DESC_ANONYMOUS_DIALOG, true);
        this.assertActionIsInaccessibleToUser("AssignIssue!default.jspa?", "assign-issue-submit", PERMISSION_ERROR_DESC_ANONYMOUS_DIALOG);
        this.assertActionIsAccessibleToAdmin("AssignIssue!default.jspa?", "assign-issue-submit", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAdminForClosedIssue("AssignIssue!default.jspa?", "assign-issue-submit", "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsInaccessibleToAnonymousUser("CommentAssignIssue!default.jspa?action=5&", "Resolve Issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("CommentAssignIssue!default.jspa?action=5&", "Resolve Issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("CommentAssignIssue!default.jspa?action=5&", "Resolve Issue", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("EditIssue!default.jspa?", "Edit Issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("EditIssue!default.jspa?", "Edit Issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("EditIssue!default.jspa?", "Edit Issue", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAdminForClosedIssue("EditIssue!default.jspa?", null, "You are not allowed to edit this issue due to its current status in the workflow.");
        this.assertActionIsInaccessibleToAnonymousUser("EditLabels!default.jspa?", null, PERMISSION_ERROR_DESC_ANONYMOUS_DIALOG, true);
        this.assertActionIsInaccessibleToUser("EditLabels!default.jspa?", null, PERMISSION_ERROR_DESC_ANONYMOUS_DIALOG);
        this.assertActionIsAccessibleToAdmin("EditLabels!default.jspa?", "Labels", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAdminForClosedIssue("EditLabels!default.jspa?", null, "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsInaccessibleToAnonymousUser("CloneIssueDetails!default.jspa?", "Summary", PERMISSION_ERROR_DESC_ANONYMOUS_DIALOG, false);
        this.assertActionIsInaccessibleToUser("CloneIssueDetails!default.jspa?", "Summary", PERMISSION_ERROR_DESC_ANONYMOUS_DIALOG);
        this.assertActionIsAccessibleToAdmin("CloneIssueDetails!default.jspa?", "Summary", PERMISSION_ERROR_DESC_ANONYMOUS_DIALOG);
        this.assertActionIsInaccessibleToAnonymousUser("MoveIssue!default.jspa?", "Current Project", "You are not logged in and do not have the permissions required to browse projects as a guest.", true);
        this.assertActionIsInaccessibleToUser("MoveIssue!default.jspa?", "Current Project", "You do not have the permissions required to browse any projects.");
        this.assertActionIsAccessibleToAdmin("MoveIssue!default.jspa?", "Current Project", "You are not logged in and do not have the permissions required to browse projects as a guest.");
        this.assertActionIsInaccessibleToAnonymousUser("ViewVoters!default.jspa?", "There are no voters for this issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ViewVoters!default.jspa?", "There are no voters for this issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ViewVoters!default.jspa?", "There are no voters for this issue", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("ViewVoters!addVote.jspa?", "There are no voters for this issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ViewVoters!addVote.jspa?", "There are no voters for this issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ViewVoters!addVote.jspa?", "Remove your vote", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("ViewVoters!removeVote.jspa?", "There are no voters for this issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ViewVoters!removeVote.jspa?", "There are no voters for this issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ViewVoters!removeVote.jspa?", "There are no voters for this issue", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("ManageWatchers!default.jspa?", "Watch Issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ManageWatchers!default.jspa?", "Watch Issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ManageWatchers!default.jspa?", "Watch Issue", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("ManageWatchers!startWatching.jspa?", "Watch Issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ManageWatchers!startWatching.jspa?", "Watch Issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ManageWatchers!startWatching.jspa?", "Stop Watching", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("ManageWatchers!stopWatching.jspa?", "Watch Issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ManageWatchers!stopWatching.jspa?", "Watch Issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ManageWatchers!stopWatching.jspa?", "Watch Issue", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("ManageWatchers!startWatchers.jspa?userNames=admin&", "Watch Issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ManageWatchers!startWatchers.jspa?userNames=admin&", "Watch Issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ManageWatchers!startWatchers.jspa?userNames=admin&", "Stop Watching", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("ManageWatchers!stopWatchers.jspa?userNames=admin&", "Watch Issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ManageWatchers!stopWatchers.jspa?userNames=admin&", "Watch Issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ManageWatchers!stopWatchers.jspa?userNames=admin&", "Stop Watching", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("CreateWorklog!default.jspa?", null, PERMISSION_ERROR_DESC_ANONYMOUS_DIALOG, true);
        this.assertActionIsInaccessibleToUser("CreateWorklog!default.jspa?", null, "It seems that you have tried to perform an operation which you are not permitted to perform");
        this.assertActionIsAccessibleToAdmin("CreateWorklog!default.jspa?", "Log Work", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAdminForClosedIssue("CreateWorklog!default.jspa?", null, "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsInaccessibleToAnonymousUser("UpdateWorklog!default.jspa?worklogId=10000&", "Edit Work Log", YOU_CANNOT_VIEW_THIS_AS_A_GUEST, false);
        this.assertActionIsInaccessibleToUser("UpdateWorklog!default.jspa?worklogId=10000&", "Edit Work Log", "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsAccessibleToAdmin("UpdateWorklog!default.jspa?worklogId=10000&", "Edit Work Log", "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsInaccessibleToAnonymousUser("DeleteWorklog!default.jspa?worklogId=10000&", "Delete Worklog", YOU_CANNOT_VIEW_THIS_AS_A_GUEST, false);
        this.assertActionIsInaccessibleToUser("DeleteWorklog!default.jspa?worklogId=10000&", "Delete Worklog", "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsAccessibleToAdmin("DeleteWorklog!default.jspa?worklogId=10000&", "Delete Worklog", "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertActionIsInaccessibleToAnonymousUser("EditComment!default.jspa?commentId=10000&", "ignoreMeAndSeeAssertBelow", "You do not have the permission to edit this comment.", false);
        this.assertActionIsInaccessibleToUser("EditComment!default.jspa?commentId=10000&", "ignoreMeAndSeeAssertBelow", "you do not have the permission to edit this comment.");
        this.assertActionIsAccessibleToAdmin("EditComment!default.jspa?commentId=10000&", "Edit Comment", "you do not have the permission to edit this comment.");
        this.assertActionIsInaccessibleToAnonymousUser("DeleteComment!default.jspa?commentId=10000&", "ignoreMeAndSeeAssertBelow", "You do not have permission to delete comment with id: 10000", false);
        this.assertActionIsInaccessibleToUser("DeleteComment!default.jspa?commentId=10000&", "ignoreMeAndSeeAssertBelow", "You do not have permission to delete comment with id: 10000");
        this.assertActionIsAccessibleToAdmin("DeleteComment!default.jspa?commentId=10000&", "Delete Comment", "You do not have permission to delete comment with id: 10000");
        this.assertActionIsInaccessibleToAnonymousUser("CreateSubTaskIssue!default.jspa?parentIssueId=10000&", "Component/s", "You are not logged in and do not have the permissions required to browse projects as a guest.", true);
        this.assertActionIsInaccessibleToUser("CreateSubTaskIssue!default.jspa?parentIssueId=10000&", "Component/s", "You do not have the permissions required to browse any projects");
        this.assertActionIsAccessibleToAdmin("CreateSubTaskIssue!default.jspa?parentIssueId=10000&", "Component/s", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("CreateSubTaskIssue.jspa?parentIssueId=10000&", "Choose the issue type", "You are not logged in and do not have the permissions required to browse projects as a guest.", true);
        this.assertActionIsInaccessibleToUser("CreateSubTaskIssue.jspa?parentIssueId=10000&", "Choose the issue type", "You do not have the permissions required to browse any projects");
        this.assertActionIsAccessibleToAdmin("CreateSubTaskIssue.jspa?parentIssueId=10000&", "Choose the issue type", PERMISSION_ERROR_DESC_ANONYMOUS);
        this.assertActionIsInaccessibleToAnonymousUser("CreateSubTaskIssueDetails.jspa?parentIssueId=10000&issuetype=5&pid=10000&", "ignoreMeAndSeeAssertBelow", "You are not logged in, and do not have the permissions required to create an issue in this project as a guest.", false);
        this.assertTextPresent("Create Sub-Task");
        this.assertActionIsInaccessibleToUser("CreateSubTaskIssueDetails.jspa?parentIssueId=10000&issuetype=5&pid=10000&", "ignoreMeAndSeeAssertBelow", "pid: You do not have permission to create issues in this project.");
        this.assertTextPresent("Create Sub-Task");
        this.assertActionIsAccessibleToAdmin("CreateSubTaskIssueDetails.jspa?parentIssueId=10000&issuetype=5&pid=10000&", "Create Sub-Task", PERMISSION_ERROR_DESC_ANONYMOUS);
    }

    private void assertActionIsInaccessibleToAnonymousUser(String actionUrl, String textNotPresent, String error_desc, boolean hasLoginLink) {
        this.logout();
        this.page.getFreshXsrfToken();
        this.gotoPage("/secure/" + actionUrl + "id=" + RESTRICTED_ISSUE_ID + "&atl_token=" + this.page.getXsrfToken());
        if (hasLoginLink) {
            this.assertTextPresent(error_desc);
            this.assertLinkPresentWithText(SIGNUP);
        } else {
            this.assertTextPresent(error_desc);
        }
        if (textNotPresent != null) {
            this.assertTextNotPresent(textNotPresent);
        }
    }

    private void assertActionIsInaccessibleToUser(String actionUrl, String textNotPresent, String error_desc) {
        this.login("fred", "fred");
        this.gotoPage("/secure/" + actionUrl + "id=" + RESTRICTED_ISSUE_ID + "&atl_token=" + this.page.getXsrfToken());
        this.assertTextPresent(error_desc);
        this.assertLinkNotPresentWithText(LOGIN);
        this.assertLinkNotPresentWithText(SIGNUP);
        if (textNotPresent != null) {
            this.assertTextNotPresent(textNotPresent);
        }
    }

    private void assertActionIsAccessibleToAdmin(String actionUrl, String textPresent, String textNotPresent) {
        this.login("admin", "admin");
        this.gotoPage("/secure/" + actionUrl + "id=" + RESTRICTED_ISSUE_ID + "&atl_token=" + this.page.getXsrfToken());
        this.assertTextNotPresent(textNotPresent);
        this.assertLinkNotPresentWithText(LOGIN);
        this.assertLinkNotPresentWithText(SIGNUP);
        this.assertTextPresent(textPresent);
    }

    private void assertActionIsInaccessibleToAdminForClosedIssue(String actionUrl, String textNotPresent, String error_desc) {
        this.login("admin", "admin");
        this.gotoPage("/secure/" + actionUrl + "id=" + CLOSED_ISSUE_ID + "&atl_token=" + this.page.getXsrfToken());
        this.assertTextPresent(error_desc);
        this.assertLinkNotPresentWithText(LOGIN);
        this.assertLinkNotPresentWithText(SIGNUP);
        if (textNotPresent != null) {
            this.assertTextNotPresent(textNotPresent);
        }
    }
}

