/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestIssueOperationsOnDeletedIssue
extends JIRAWebTest {
    public static final String DELETED_ISSUE_ID = "10000";
    public static final String EXISTING_ISSUE_ID = "10001";
    public static final String DELETED_ISSUE_ERROR = "The issue no longer exists.";
    public static final String DELETED_VIEW_ISSUE_ERROR = "The issue you are trying to view does not exist.";
    private static final String MANAGE_WATCHERS = "Watchers";

    public TestIssueOperationsOnDeletedIssue(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestIssueOperationsOnDeletedIssueProEnt.xml");
    }

    @Override
    public void tearDown() {
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testIssueOperationsOnDeletedIssue() {
        this._testIssueOperationsOnDeletedIssueStandard();
        this._testIssueOperationsOnDeletedIssueProfessionalAndEnterprise();
    }

    public void _testIssueOperationsOnDeletedIssueStandard() {
        this.assertDeletedIssueError("ViewIssue.jspa?", "Details", true);
        this.assertDeletedIssueError("VoteOrWatchIssue.jspa?vote=vote&", "Details", true);
        this.assertDeletedIssueError("VoteOrWatchIssue.jspa?vote=unvote&", "Details", true);
        this.assertDeletedIssueError("VoteOrWatchIssue.jspa?watch=watch&", "Details", true);
        this.assertDeletedIssueError("VoteOrWatchIssue.jspa?watch=unwatch&", "Details", true);
        this.assertDeletedIssueError("WorkflowUIDispatcher.jspa?action=5&", "Resolve Issue");
        this.gotoPage("/secure/WorkflowUIDispatcher.jspa?id=10001&action=5&atl_token=" + this.page.getXsrfToken());
        this.assertTextPresent("Resolve Issue");
        this.gotoPage("/secure/WorkflowUIDispatcher.jspa?id=10000&action=5&atl_token=" + this.page.getXsrfToken());
        this.assertTextPresent(DELETED_ISSUE_ERROR);
        this.assertTextNotPresent("Resolve Issue");
        this.assertDeletedIssueError("CommentAssignIssue!default.jspa?action=5&", "Resolve Issue");
        this.assertDeletedIssueError("AssignIssue!default.jspa?", "Assign");
        this.assertDeletedIssueError("EditIssue!default.jspa?", "Edit Issue");
        this.assertDeletedIssueError("CloneIssueDetails!default.jspa?", "Summary");
        this.assertDeletedIssueError("MoveIssue!default.jspa?", "Current Project");
        this.assertDeletedIssueError("ViewVoters!default.jspa?", "Voters");
        this.assertDeletedIssueError("ViewVoters!addVote.jspa?", "Voters");
        this.assertDeletedIssueError("ViewVoters!removeVote.jspa?", "Voters");
        this.assertDeletedIssueError("ManageWatchers!default.jspa?", MANAGE_WATCHERS);
        this.assertDeletedIssueError("ManageWatchers!startWatching.jspa?", MANAGE_WATCHERS);
        this.assertDeletedIssueError("ManageWatchers!stopWatching.jspa?", MANAGE_WATCHERS);
        this.assertDeletedIssueError("ManageWatchers!startWatchers.jspa?userNames=admin&", MANAGE_WATCHERS);
        this.assertDeletedIssueError("ManageWatchers!stopWatchers.jspa?userNames=admin&", MANAGE_WATCHERS);
        this.assertDeletedIssueError("CreateWorklog!default.jspa?", "Log Work");
        this.assertDeletedIssueError("UpdateWorklog!default.jspa?worklogId=10000&", "Edit Work Log");
        this.assertDeletedIssueError("DeleteWorklog!default.jspa?worklogId=10000&", "Delete Worklog");
        this.assertDeletedIssueError("EditComment!default.jspa?commentId=10000&", "Edit Comment", "first comment", false);
    }

    private void _testIssueOperationsOnDeletedIssueProfessionalAndEnterprise() {
        this.gotoPage("/secure/CreateSubTaskIssue!default.jspa?parentIssueId=10001");
        this.assertTextPresent("Create Sub-Task");
        this.gotoPage("/secure/CreateSubTaskIssue!default.jspa?parentIssueId=10000");
        this.assertTextPresent(DELETED_ISSUE_ERROR);
        this.gotoPage("/secure/CreateSubTaskIssue.jspa?parentIssueId=10001");
        this.assertTextPresent("Create Sub-Task");
        this.gotoPage("/secure/CreateSubTaskIssue.jspa?parentIssueId=10000");
        this.assertTextPresent(DELETED_ISSUE_ERROR);
        this.gotoFieldConfigurationDefault();
        this.clickLink("hide_15");
        this.gotoPage(this.page.addXsrfToken("/secure/CreateSubTaskIssueDetails.jspa?issuetype=5&pid=10000&summary=createdSubtask&assignee=admin&reporter=admin&parentIssueId=10001"));
        this.assertTextPresent("createdSubtask");
        this.assertTextNotPresent("Create Sub-Task");
        this.assertTextNotPresent("Enter the details of the issue");
        this.assertTextPresent("Sub-task");
        this.gotoPage(this.page.addXsrfToken("/secure/CreateSubTaskIssueDetails.jspa?issuetype=5&pid=10000&summary=createdSubtask&assignee=admin&reporter=admin&parentIssueId=10000"));
        this.assertTextPresent("Parent Issue cannot be null");
    }

    private void assertDeletedIssueError(String actionUrl, String textNotPresent, boolean isViewIssue) {
        this.assertDeletedIssueError(actionUrl, textNotPresent, textNotPresent, isViewIssue);
    }

    private void assertDeletedIssueError(String actionUrl, String textNotPresent) {
        this.assertDeletedIssueError(actionUrl, textNotPresent, textNotPresent, false);
    }

    private void assertDeletedIssueError(String actionUrl, String textPresent, String textNotPresent, boolean isViewIssue) {
        this.gotoPage("/secure/" + actionUrl + "id=" + EXISTING_ISSUE_ID + "&atl_token=" + this.page.getXsrfToken());
        this.assertTextPresent(textPresent);
        this.gotoPage("/secure/" + actionUrl + "id=" + DELETED_ISSUE_ID + "&atl_token=" + this.page.getXsrfToken());
        if (isViewIssue) {
            this.assertTextPresent(DELETED_VIEW_ISSUE_ERROR);
        } else {
            this.assertTextPresent(DELETED_ISSUE_ERROR);
        }
    }
}

