/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestCreateIssueForEnterprise
extends JIRAWebTest {
    public TestCreateIssueForEnterprise(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
        this.addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
    }

    private void ensureProjectsExist() {
        if (this.projectExists("homosapien")) {
            TestCreateIssueForEnterprise.log("Project 'homosapien' exists");
            if (!this.componentExists("New Component 3", "homosapien")) {
                this.addComponent("homosapien", "New Component 1");
            }
        } else {
            this.addProject("homosapien", "HSP", "admin");
            this.addComponent("homosapien", "New Component 1");
        }
    }

    public void testCreateIssueForEnterprise() {
        this.ensureProjectsExist();
        this.createIssueWithComponentLeadAssignee();
        this.createIssueWithProjectLeadAssignee();
        this.createIssueWithUnassignedComponentLeadAssignee();
        this.deleteAllIssuesInAllPages();
    }

    public String createIssueWithComponentLeadAssignee() {
        this.addUserToGroup("bob", "jira-developers");
        this.setComponentLead("homosapien", "bob", "Bob The Builder", "New Component 1");
        this.setComponentAssigneeOptions("homosapien", "New Component 1", "1");
        String issueKey = this.addIssue("homosapien", "HSP", "Bug", "test 6", "Minor", new String[]{"New Component 1"}, null, null, null, "test environment 6", "test description 6 for test create issue (enterprise)", null, null, null);
        this.assertTextPresent("test 6");
        this.assertTextPresent("Minor");
        this.assertTextPresent("Bug");
        this.assertLinkPresentWithText("Bob The Builder");
        this.clearComponentLead("homosapien", "New Component 1");
        this.removeUserFromGroup("bob", "jira-developers");
        return issueKey;
    }

    public String createIssueWithProjectLeadAssignee() {
        this.addUserToGroup("bob", "jira-developers");
        this.setProjectLead("homosapien", "bob");
        this.setComponentAssigneeOptions("homosapien", "New Component 1", "2");
        String issueKey = this.addIssue("homosapien", "HSP", "Bug", "test 7", "Minor", new String[]{"New Component 1"}, null, null, "- Automatic -", "test environment 7", "test description 7 for test create issue (enterprise)", null, null, null);
        this.assertTextPresent("test 7");
        this.assertTextPresent("Bug");
        this.assertTextPresent("Minor");
        this.assertLinkPresentWithText("Bob The Builder");
        this.setProjectLead("homosapien", "admin");
        this.removeUserFromGroup("bob", "jira-developers");
        return issueKey;
    }

    public String createIssueWithUnassignedComponentLeadAssignee() {
        this.setUnassignedIssuesOption(true);
        this.setComponentAssigneeOptions("homosapien", "New Component 1", "3");
        String issueKey = this.addIssue("homosapien", "HSP", "Bug", "test 8", "Minor", new String[]{"New Component 1"}, null, null, "- Automatic -", "test environment 8", "test description 8 for test create issue (enterprise)", null, null, null);
        this.assertTextPresent("test 8");
        this.assertTextPresent("Bug");
        this.assertTextPresent("Minor");
        this.assertTextPresentBeforeText("Assignee:", "Unassigned");
        this.assignIssue(issueKey, "Assigning issue to ADMIN", "Administrator");
        this.setUnassignedIssuesOption(false);
        return issueKey;
    }
}

