/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.imports.project;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.imports.project.AbstractProjectImportTestCase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

@WebTest(value={Category.FUNC_TEST, Category.PROJECT_IMPORT})
public class TestProjectImportSelectProject
extends AbstractProjectImportTestCase {
    private File tempFile;

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestProjectImportSelectProject.xml");
        String fileName = "TestProjectImportSelectProject_out.xml";
        this.log(String.format("Using temporary file '%s'.", "TestProjectImportSelectProject_out.xml"));
        File zipFile = this.administration.exportDataToFile("TestProjectImportSelectProject_out.xml");
        try {
            InputStream inputStream = new ZipFile(zipFile).getInputStream(new ZipEntry("entities.xml"));
            File extractedXml = new File(zipFile.getParentFile(), "TestProjectImportSelectProject_out.xml");
            extractedXml.delete();
            FileWriter fileWriter = new FileWriter(extractedXml);
            IOUtils.copy((InputStream)inputStream, (Writer)fileWriter);
            fileWriter.close();
            this.tempFile = this.copyFileToJiraImportDirectory(extractedXml);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void tearDownTest() {
        if (!this.tempFile.delete()) {
            this.log(String.format("Unable to delete file '%s'.", this.tempFile.getAbsoluteFile().getPath()));
        }
    }

    public void testJumpToSelectProjectScreen() {
        this.tester.gotoPage("/secure/admin/ProjectImportSelectProject!default.jspa");
        this.tester.assertTextPresent("There are no projects to display. Perhaps your session has timed out, please restart the project import wizard.");
    }

    public void testValidationErrors() {
        this.tester.gotoPage("/plugins/servlet/project-config/MKY/people");
        this.tester.clickLink("edit_project_lead");
        this.tester.selectOption("assigneeType", "Project Lead");
        this.tester.submit("Update");
        this.administration.generalConfiguration().setAllowUnassignedIssues(false);
        this.navigation.gotoAdminSection("project_import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", this.tempFile.getName());
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "homosapien");
        this.tester.submit("Next");
        this.text.assertTextPresentHtmlEncoded("The existing project with key 'HSP' contains '26' issues. You can not import a backup project into a project that contains existing issues.");
        this.text.assertTextPresentHtmlEncoded("The existing project with key 'HSP' contains '3' versions. You can not import a backup project into a project that contains existing versions.");
        this.text.assertTextPresentHtmlEncoded("The existing project with key 'HSP' contains '3' components. You can not import a backup project into a project that contains existing components.");
        this.tester.selectOption("projectKey", "monkey");
        this.tester.submit("Next");
        this.text.assertTextPresentHtmlEncoded("The backup project 'monkey' has 'unassigned' default assignee, but this JIRA instance does not allow unassigned issues.");
    }

    public void testCustomFieldsWrongVersion() throws IOException {
        this.modifyCustomFieldPluginVersion();
        this.navigation.gotoAdminSection("project_import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", this.tempFile.getName());
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "monkey");
        this.tester.submit("Next");
        this.text.assertTextPresentHtmlEncoded("The backup project 'monkey' requires custom field named 'text cf' with full key 'com.atlassian.jira.plugin.system.customfieldtypes:textarea'. In the current instance of JIRA the plugin is at version '1.0', but in the backup it is at version '10.0'.");
        this.text.assertTextPresentHtmlEncoded("The backup project 'monkey' requires custom field named 'target_milestone' with full key 'com.atlassian.jira.plugin.system.customfieldtypes:select'. In the current instance of JIRA the plugin is at version '1.0', but in the backup it is at version '10.0'.");
        this.text.assertTextPresentHtmlEncoded("The backup project 'monkey' requires custom field named 'fgsdfgsd' with full key 'com.atlassian.jira.plugin.system.customfieldtypes:textfield'. In the current instance of JIRA the plugin is at version '1.0', but in the backup it is at version '10.0'.");
        this.text.assertTextPresentHtmlEncoded("The backup project 'monkey' requires custom field named 'number cf' with full key 'com.atlassian.jira.plugin.system.customfieldtypes:float'. In the current instance of JIRA the plugin is at version '1.0', but in the backup it is at version '10.0'.");
    }

    public void testCustomFieldsPluginDoesNotExist() throws IOException {
        this.deleteCustomFieldPluginVersion();
        this.navigation.gotoAdminSection("project_import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", this.tempFile.getName());
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "monkey");
        this.tester.submit("Next");
        this.text.assertTextPresentHtmlEncoded("The backup project 'monkey' requires custom field named 'fgsdfgsd' with full key 'com.atlassian.jira.plugin.system.customfieldtypes:textfield'. In the current instance of JIRA the plugin is at version '1.0', but this custom field was not installed in the backup data. You may want to create an XML backup with this version of the plugin installed.");
        this.text.assertTextPresentHtmlEncoded("The backup project 'monkey' requires custom field named 'number cf' with full key 'com.atlassian.jira.plugin.system.customfieldtypes:float'. In the current instance of JIRA the plugin is at version '1.0', but this custom field was not installed in the backup data. You may want to create an XML backup with this version of the plugin installed.");
        this.text.assertTextPresentHtmlEncoded("The backup project 'monkey' requires custom field named 'target_milestone' with full key 'com.atlassian.jira.plugin.system.customfieldtypes:select'. In the current instance of JIRA the plugin is at version '1.0', but this custom field was not installed in the backup data. You may want to create an XML backup with this version of the plugin installed.");
        this.text.assertTextPresentHtmlEncoded("The backup project 'monkey' requires custom field named 'text cf' with full key 'com.atlassian.jira.plugin.system.customfieldtypes:textarea'. In the current instance of JIRA the plugin is at version '1.0', but this custom field was not installed in the backup data. You may want to create an XML backup with this version of the plugin installed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParseExceptionInJIRAData() throws Exception {
        File file = this.importAndExportBackupAndSetupCurrentInstance("TestProjectImportParseExceptionScreen2.xml", "TestProjectImportSummaryNoCustomFields2.xml");
        try {
            this.navigation.gotoAdminSection("project_import");
            this.tester.assertTextPresent("Project Import: Select Backup File");
            this.tester.setFormElement("backupXmlPath", file.getAbsolutePath());
            this.tester.submit("Next");
            this.advanceThroughWaitingPage();
            this.tester.assertTextPresent("Project Import: Select Project to Import");
            this.tester.selectOption("projectKey", "monkey");
            this.tester.submit("Next");
            this.advanceThroughWaitingPage();
            this.tester.assertTextPresent("Project Import: Select Project to Import");
            this.tester.assertTextPresent("There was a problem parsing the backup XML file at");
            this.tester.assertTextPresent("A comment must have an issue id specified.");
        }
        finally {
            file.delete();
        }
    }

    private void modifyCustomFieldPluginVersion() throws IOException {
        StringWriter stringWriter = new StringWriter();
        InputStreamReader in = new InputStreamReader(new FileInputStream(this.tempFile));
        this.copy(in, stringWriter, 4096);
        ((Reader)in).close();
        String s = stringWriter.toString();
        stringWriter.close();
        s = StringUtils.replace((String)s, (String)"<PluginVersion id=\"10002\" name=\"Custom Field Types &amp; Searchers\" key=\"com.atlassian.jira.plugin.system.customfieldtypes\" version=\"1.0\"/>", (String)"<PluginVersion id=\"10002\" name=\"Custom Field Types &amp; Searchers\" key=\"com.atlassian.jira.plugin.system.customfieldtypes\" version=\"10.0\"/>");
        FileWriter fw = new FileWriter(this.tempFile);
        fw.write(s);
        fw.close();
    }

    private void deleteCustomFieldPluginVersion() throws IOException {
        StringWriter stringWriter = new StringWriter();
        InputStreamReader in = new InputStreamReader(new FileInputStream(this.tempFile));
        this.copy(in, stringWriter, 4096);
        ((Reader)in).close();
        String s = stringWriter.toString();
        stringWriter.close();
        s = StringUtils.replace((String)s, (String)"<PluginVersion id=\"10002\" name=\"Custom Field Types &amp; Searchers\" key=\"com.atlassian.jira.plugin.system.customfieldtypes\" version=\"1.0\"/>", (String)"");
        FileWriter fw = new FileWriter(this.tempFile);
        fw.write(s);
        fw.close();
    }

    private void copy(Reader input, Writer output, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }
}

