/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.imports.project;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.imports.project.AbstractProjectImportTestCase;
import java.io.File;

@WebTest(value={Category.FUNC_TEST, Category.PROJECT_IMPORT})
public class TestProjectImportSelectBackup
extends AbstractProjectImportTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testValidationInvalidPaths() {
        this.administration.attachments().enable();
        this.navigation.gotoAdmin();
        this.tester.clickLink("attachments");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.checkCheckbox("attachmentPathOption", "DEFAULT");
        this.tester.submit("Update");
        String attachmentsPath = this.administration.getJiraHomeDirectory() + "/data/attachments/";
        this.navigation.gotoAdminSection("project_import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", "");
        this.tester.submit("Next");
        this.tester.assertTextPresent("You must provide a path to the JIRA backup XML file.");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", "/iamafilethatwillneverexisthahahahaha/bak.xml");
        this.tester.submit("Next");
        this.tester.assertTextPresent("The path to the JIRA backup XML file is not valid.");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", System.getProperty("java.io.tmpdir"));
        this.tester.submit("Next");
        this.tester.assertTextPresent("The path to the JIRA backup XML file is not valid.");
    }

    public void testValidationInvalidbackupAttachmentsNotEnabled() {
        this.administration.attachments().disable();
        this.navigation.gotoAdminSection("project_import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", "");
        this.tester.submit("Next");
        this.tester.assertTextPresent("You must provide a path to the JIRA backup XML file.");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", "/iamafilethatwillneverexisthahahahaha/bak.xml");
        this.tester.submit("Next");
        this.tester.assertTextPresent("The path to the JIRA backup XML file is not valid.");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", System.getProperty("java.io.tmpdir"));
        this.tester.submit("Next");
        this.tester.assertTextPresent("The path to the JIRA backup XML file is not valid.");
    }

    public void testJumpToProgressScreen() {
        this.navigation.gotoAdminSection("project_import");
        this.tester.gotoPage("/secure/admin/ProjectImportBackupOverviewProgress.jspa");
        this.tester.assertTextPresent("Can not find any running task information. Perhaps your session has timed out, please restart the project import wizard.");
        this.tester.assertTextNotPresent("Refresh");
        this.tester.assertTextPresent("Cancel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParseExceptionInJIRAData() throws Exception {
        File file = this.importAndExportBackupAndSetupCurrentInstance("TestProjectImportParseExceptionScreen1.xml", "blankprojects.xml");
        try {
            this.navigation.gotoAdminSection("project_import");
            this.tester.assertTextPresent("Project Import: Select Backup File");
            this.tester.setFormElement("backupXmlPath", file.getAbsolutePath());
            this.tester.submit("Next");
            this.advanceThroughWaitingPage();
            this.tester.assertTextPresent("Project Import: Select Backup File");
            this.text.assertTextPresentHtmlEncoded("There was a problem parsing the backup XML file at " + file.getAbsolutePath() + ": No 'key' field for Issue 10022.");
        }
        finally {
            file.delete();
        }
    }
}

