/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.imports.project;

import com.atlassian.jira.functest.framework.changehistory.ChangeHistoryField;
import com.atlassian.jira.functest.framework.changehistory.ChangeHistoryList;
import com.atlassian.jira.functest.framework.changehistory.ChangeHistorySet;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.parser.comment.Comment;
import com.atlassian.jira.functest.framework.parser.issue.ViewIssueDetails;
import com.atlassian.jira.functest.framework.parser.worklog.Worklog;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Component;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Project;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.ProjectClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.ProjectRole;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.ProjectRoleClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Version;
import com.atlassian.jira.webtests.ztests.imports.project.AbstractProjectImportTestCase;
import java.io.File;
import java.util.List;
import java.util.Map;

@WebTest(value={Category.FUNC_TEST, Category.PROJECT_IMPORT})
public class TestProjectImportResults
extends AbstractProjectImportTestCase {
    private static final String CHANGE_HISTORY = "History";
    private static final String PAGE_USER_BROWSER = "/secure/admin/user/UserBrowser.jspa";

    public void testProjectNullAssigneeTypeUnassignedOn() throws Exception {
        this._testProjectNullAssigneeType("TestProjectImportNoProjectWithUnassignedOn.xml", "Unassigned");
    }

    public void testProjectNullAssigneeTypeUnassignedOff() throws Exception {
        this._testProjectNullAssigneeType("TestProjectImportNoProjectWithUnassignedOff.xml", "Project Lead");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _testProjectNullAssigneeType(String currentSystemXML, String defaultAssignee) throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportNoAssigneeType.xml", currentSystemXML);
            this.doImportAndAssertDefaultAssignee(defaultAssignee);
            this.importToPreImportSummaryPage(tempFile);
            this.doImportAndAssertDefaultAssignee(defaultAssignee);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    private void doImportAndAssertDefaultAssignee(String defaultAssignee) {
        this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
        this.tester.assertSubmitButtonPresent("Import");
        this.tester.submit("Import");
        this.advanceThroughWaitingPage();
        this.text.assertTextSequence(new IdLocator(this.tester, "systemfields"), "Default Assignee", defaultAssignee);
        this.tester.gotoPage("/plugins/servlet/project-config/MKY/people");
        this.assertions.assertNodeByIdHasText("project-config-header-name", "monkey");
        this.assertions.assertNodeByIdHasText("project-config-panel-people-default-assignee", defaultAssignee);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProjectNotEmptyWhenTryingToImport() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportResults.xml", "TestProjectImportResults2.xml");
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.navigation.issue().createIssue("monkey", "Bug", "I am breaking the project import");
            this.tester.gotoPage("/secure/admin/ProjectImportSummary!default.jspa");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            this.tester.assertTextPresent("Select Project to Import");
            this.text.assertTextPresentHtmlEncoded("The existing project with key 'MKY' contains '1' issues.");
            this.tester.assertTextPresent("The project import was aborted before it began because the project is no longer importable.");
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCustomFieldNoLongerExistsTryingToImport() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportResults.xml", "TestProjectImportResults2.xml");
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.gotoPage("/secure/admin/DeleteCustomField!default.jspa?id=10030");
            this.tester.submit("Delete");
            this.tester.gotoPage("/secure/admin/ProjectImportSummary!default.jspa");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            this.tester.assertTextPresent("Project Import: Pre-Import Summary");
            this.tester.assertTextPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertTextPresent("The project import was aborted before it began because the project import mappings are no longer valid.");
            this.text.assertTextPresentHtmlEncoded("The custom field 'Cascading Select CF' of type 'Cascading Select' is required for the import but does not exist in the current JIRA instance.");
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateUsers() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportStandardSimpleData.xml", "TestProjectImportStandardSimpleDataNoProject.xml");
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/ul");
            String projectDetailsResults = xPathLocator.getText();
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Key: MKY"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Description: This is a description for a monkey project."));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Lead: Fred Normal"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "URL: http://monkeyproject.example.com"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Default Assignee: Project Lead"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Components: 3"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Versions: 3"));
            xPathLocator = new XPathLocator(this.tester, "//div[@id='customfields']/ul");
            String userRoleIssueResults = xPathLocator.getText();
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Users: 2 out of 2"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Administrators: 1 users, 1 groups"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Developers: 1 users, 2 groups"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Users: 1 users, 2 groups"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Issues created: 2 out of 2"));
            this.administration.usersAndGroups().gotoViewUser("wilma");
            this.tester.assertTextPresent("Wilma Flinstone");
            this.tester.assertTextPresent("wilma@example.com");
            this.tester.assertTextPresent("jira-users");
            this.tester.assertTextPresent("ice cream:");
            this.tester.assertTextPresent("strawberry");
            this.tester.assertTextPresent("24:");
            this.tester.assertTextPresent("4 x 6");
            this.administration.usersAndGroups().gotoViewUser("fred");
            this.tester.assertTextPresent("Fred Normal");
            this.tester.assertTextPresent("fred@example.com");
            this.tester.assertTextPresent("jira-users");
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
            this.navigation.logout();
            this.navigation.login("admin", "admin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIssueDataCommentAndWorklogVisiblity() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportStandardSimpleData.xml", "TestProjectImportStandardSimpleDataNoProject.xml");
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/ul");
            String projectDetailsResults = xPathLocator.getText();
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Key: MKY"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Description: This is a description for a monkey project."));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Lead: Fred Normal"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "URL: http://monkeyproject.example.com"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Default Assignee: Project Lead"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Components: 3"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Versions: 3"));
            xPathLocator = new XPathLocator(this.tester, "//div[@id='customfields']/ul");
            String userRoleIssueResults = xPathLocator.getText();
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Users: 2 out of 2"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Administrators: 1 users, 1 groups"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Developers: 1 users, 2 groups"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Users: 1 users, 2 groups"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Issues created: 2 out of 2"));
            this.navigateToUser("wilma");
            this.tester.clickLinkWithText("Set Password");
            this.tester.setFormElement("password", "wilma");
            this.tester.setFormElement("confirm", "wilma");
            this.tester.submit("Update");
            this.navigation.logout();
            this.navigation.login("wilma", "wilma");
            this.navigation.issue().viewIssue("MKY-1");
            ViewIssueDetails details = this.parse.issue().parseViewIssuePage();
            TestProjectImportResults.assertEquals((String)"MKY-1", (String)details.getKey());
            TestProjectImportResults.assertEquals((String)"Bug", (String)details.getIssueType());
            TestProjectImportResults.assertEquals((String)"In Progress", (String)details.getStatus());
            TestProjectImportResults.assertEquals((String)"Blocker", (String)details.getPriority());
            TestProjectImportResults.assertEquals((String)"Fred Normal", (String)details.getAssignee());
            TestProjectImportResults.assertEquals((String)"Wilma Flinstone", (String)details.getReporter());
            List<Comment> comments = this.parse.issue().parseComments();
            TestProjectImportResults.assertEquals((int)1, (int)comments.size());
            TestProjectImportResults.assertTrue((boolean)comments.contains(new Comment("I am a comment added by Wilma, that has been edited.", "Wilma Flinstone added a comment  - 12/Jun/08 3:03 PM - edited")));
            this.tester.clickLinkWithText("Work Log");
            List<Worklog> worklogs = this.parse.issue().parseWorklogs();
            TestProjectImportResults.assertEquals((int)1, (int)worklogs.size());
            TestProjectImportResults.assertTrue((boolean)worklogs.contains(new Worklog("I am a worklog added by Mrs. Rubble.", "2 hours", "betty logged work  - 12/Jun/08 3:18 PM")));
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
            this.navigation.logout();
            this.navigation.login("admin", "admin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCanEditIssue() throws Exception {
        boolean isOracle = new EnvironmentUtils(this.tester, this.getEnvironmentData(), this.navigation).isOracle();
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportStandardSimpleData.xml", "TestProjectImportStandardSimpleDataNoProject.xml");
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/ul");
            String projectDetailsResults = xPathLocator.getText();
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Key: MKY"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Description: This is a description for a monkey project."));
            if (isOracle) {
                Thread.sleep(2000L);
            }
            this.navigation.issue().viewIssue("MKY-1");
            this.tester.clickLink("editIssue");
            this.tester.setFormElement("summary", "This is the test bug with all the field values set, and I have edited it.");
            this.tester.setFormElement("description", "I am a description field");
            this.tester.setFormElement("environment", "I am environment field");
            this.tester.setFormElement("customfield_10011", "I am free text field value.");
            this.tester.submit("Update");
            ViewIssueDetails details = this.parse.issue().parseViewIssuePage();
            TestProjectImportResults.assertEquals((String)"MKY-1", (String)details.getKey());
            TestProjectImportResults.assertEquals((String)"Bug", (String)details.getIssueType());
            TestProjectImportResults.assertEquals((String)"In Progress", (String)details.getStatus());
            TestProjectImportResults.assertEquals((String)"Blocker", (String)details.getPriority());
            TestProjectImportResults.assertEquals((String)"Fred Normal", (String)details.getAssignee());
            TestProjectImportResults.assertEquals((String)"Wilma Flinstone", (String)details.getReporter());
            TestProjectImportResults.assertEquals((String)"1", (String)details.getVotes());
            this.tester.clickLink("view-voters");
            this.tester.assertTextPresent("voter_link_admin");
            this.tester.clickLinkWithText("MKY-1");
            TestProjectImportResults.assertEquals((String)"1", (String)details.getWatchers());
            this.tester.clickLink("manage-watchers");
            this.tester.assertLinkPresent("watcher_link_wilma");
            this.tester.clickLinkWithText("MKY-1");
            TestProjectImportResults.assertTrue((boolean)details.getAvailableWorkflowActions().contains("Resolve Issue"));
            TestProjectImportResults.assertTrue((boolean)details.getAvailableWorkflowActions().contains("Close Issue"));
            TestProjectImportResults.assertEquals((String)"monkey", (String)details.getProjectName());
            TestProjectImportResults.assertEquals((String)"This is the test bug with all the field values set, and I have edited it.", (String)details.getSummary());
            TestProjectImportResults.assertEquals((String)"I am a description field", (String)details.getDescription());
            TestProjectImportResults.assertEquals((String)"03/Jun/08 3:00 PM", (String)details.getCreatedDate());
            TestProjectImportResults.assertEquals((String)"09/Jun/08", (String)details.getDueDate());
            TestProjectImportResults.assertTrue((boolean)details.getComponents().contains("First Test Component"));
            TestProjectImportResults.assertTrue((boolean)details.getComponents().contains("Second Test Component"));
            TestProjectImportResults.assertTrue((boolean)details.getAffectsVersions().contains("Cool Version"));
            TestProjectImportResults.assertTrue((boolean)details.getAffectsVersions().contains("Uncool Version"));
            TestProjectImportResults.assertTrue((boolean)details.getFixVersions().contains("Uncool Version"));
            TestProjectImportResults.assertTrue((boolean)details.getFixVersions().contains("Medium Cool Version"));
            TestProjectImportResults.assertEquals((String)"2d", (String)details.getOriginalEstimate());
            TestProjectImportResults.assertEquals((String)"20h", (String)details.getRemainingEstimate());
            TestProjectImportResults.assertEquals((String)"1d 4h", (String)details.getTimeSpent());
            TestProjectImportResults.assertEquals((String)"I am environment field", (String)details.getEnvironment());
            this.tester.assertLinkPresentWithText("MKY-2");
            this.tester.assertLinkPresentWithText("HSP-1");
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Cascading Select CF", "Parent Option 1"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Cascading Select CF", "Child Option 1"));
            TestProjectImportResults.assertEquals((String)"01/Jun/08 2:57 PM", (String)details.getCustomFields().get("Date Time CF"));
            TestProjectImportResults.assertEquals((String)"user-dudes", (String)details.getCustomFields().get("Group Picker CF"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Multi Checkboxes CF", "Multi Checkbox Option 2"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Multi Checkboxes CF", "Multi Checkbox Option 1"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Multi Select CF", "Multi Select Option 1"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Multi Select CF", "Multi Select Option 2"));
            TestProjectImportResults.assertEquals((String)"42.01", (String)details.getCustomFields().get("Number Field CF"));
            TestProjectImportResults.assertEquals((String)"Radio Option 1", (String)details.getCustomFields().get("Radio Buttons CF"));
            TestProjectImportResults.assertEquals((String)"Select List Option 1", (String)details.getCustomFields().get("Select List CF"));
            TestProjectImportResults.assertEquals((String)"I am text field 255 value.", (String)details.getCustomFields().get("Text Field 255"));
            TestProjectImportResults.assertEquals((String)"Fred Normal", (String)details.getCustomFields().get("User Picker CF"));
            TestProjectImportResults.assertEquals((String)"01/Apr/08", (String)details.getCustomFields().get("Date Picker CF"));
            TestProjectImportResults.assertEquals((String)"I am free text field value.", (String)details.getCustomFields().get("Free Text Field CF"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Multi Group Picker CF", "admin-dudes"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Multi Group Picker CF", "dev-dudes"));
            TestProjectImportResults.assertEquals((String)"homosapien", (String)details.getCustomFields().get("Project Picker CF"));
            TestProjectImportResults.assertEquals((String)"Fred Normal", (String)details.getCustomFields().get("Multi User Picker CF"));
            TestProjectImportResults.assertEquals((String)"Medium Cool Version", (String)details.getCustomFields().get("Single Version Picker CF"));
            TestProjectImportResults.assertEquals((String)"http://www.google.com", (String)details.getCustomFields().get("URL Field CF"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Version Picker CF", "Medium Cool Version"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Version Picker CF", "Cool Version"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Version Picker CF", "Uncool Version"));
            List<Comment> comments = this.parse.issue().parseComments();
            TestProjectImportResults.assertEquals((int)4, (int)comments.size());
            TestProjectImportResults.assertTrue((boolean)comments.contains(new Comment("I am a comment added by Wilma, that has been edited.", "Wilma Flinstone added a comment  - 12/Jun/08 3:03 PM - edited")));
            TestProjectImportResults.assertTrue((boolean)comments.contains(new Comment("I am a comment added by Adminstrator.", "Adminitrator added a comment  - 12/Jun/08 3:11 PM - Restricted to Developers")));
            TestProjectImportResults.assertTrue((boolean)comments.contains(new Comment("I am another Admin comment", "Adminitrator added a comment  - 12/Jun/08 3:15 PM - Restricted to jira-administrators")));
            TestProjectImportResults.assertTrue((boolean)comments.contains(new Comment("I am a comment added by betty.", "betty added a comment  - 12/Jun/08 3:16 PM - Restricted to jira-developers - edited")));
            this.tester.clickLinkWithText("Work Log");
            List<Worklog> worklogs = this.parse.issue().parseWorklogs();
            TestProjectImportResults.assertEquals((int)3, (int)worklogs.size());
            TestProjectImportResults.assertTrue((boolean)worklogs.contains(new Worklog("I am Fred logging work, edited.", "1 day", "Fred Normal logged work  - 12/Jun/08 3:13 PM - Restricted to Developers - edited")));
            TestProjectImportResults.assertTrue((boolean)worklogs.contains(new Worklog("I am admin worklog.", "2 hours", "Adminitrator logged work  - 12/Jun/08 3:15 PM - Restricted to jira-developers")));
            TestProjectImportResults.assertTrue((boolean)worklogs.contains(new Worklog("I am a worklog added by Mrs. Rubble.", "2 hours", "betty logged work  - 12/Jun/08 3:18 PM")));
            this.tester.clickLinkWithText(CHANGE_HISTORY);
            ChangeHistoryList list = this.parse.issue().parseChangeHistory();
            list.assertContainsChangeHistory(this.getExpectedChangeHistoryListForAllData());
            ChangeHistorySet changeHistorySet = (ChangeHistorySet)list.get(list.size() - 2);
            TestProjectImportResults.assertEquals((String)"Adminitrator", (String)changeHistorySet.getChangedBy());
            TestProjectImportResults.assertEquals((String)"Project Import", (String)((ChangeHistoryField)changeHistorySet.getFieldChanges().iterator().next()).getFieldName());
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCustomFieldIssueTypeConstraints() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportCustomFieldConfig.xml", "TestProjectImportCustomFieldConfig2.xml");
            this.text.assertTextPresentHtmlEncoded("The custom field 'Text Field 255' in the backup project is used by issue types 'Bug, Improvement' but the field with the same name in the current JIRA instance is not available to those issue types in this project.");
            this.tester.assertSubmitButtonNotPresent("Import");
            this.tester.clickLink("view_custom_fields");
            this.tester.clickLink("config_customfield_10008");
            this.tester.clickLinkWithText("Edit Configuration");
            this.tester.checkCheckbox("issuetypes", "1");
            this.tester.checkCheckbox("issuetypes", "4");
            this.tester.submit("Modify");
            this.tester.gotoPage("/secure/admin/ProjectImportSummary!reMapAndValidate.jspa");
            this.advanceThroughWaitingPage();
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/ul");
            String projectDetailsResults = xPathLocator.getText();
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Key: MKY"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Description: This is a description for a monkey project."));
            this.navigation.issue().viewIssue("MKY-2");
            this.tester.assertTextNotPresent("I am a hidden value that will only be shown when the configuration changes.");
            this.navigation.gotoAdmin();
            this.tester.clickLink("view_custom_fields");
            this.tester.clickLink("config_customfield_10008");
            this.tester.clickLinkWithText("Edit Configuration");
            this.tester.checkCheckbox("issuetypes", "1");
            this.tester.checkCheckbox("issuetypes", "4");
            this.tester.checkCheckbox("issuetypes", "2");
            this.tester.submit("Modify");
            this.navigation.issue().viewIssue("MKY-2");
            this.tester.assertTextPresent("I am a hidden value that will only be shown when the configuration changes.");
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCanTransitionIssue() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportStandardSimpleData.xml", "TestProjectImportStandardSimpleDataNoProject.xml");
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/ul");
            String projectDetailsResults = xPathLocator.getText();
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Key: MKY"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Description: This is a description for a monkey project."));
            this.navigation.issue().viewIssue("MKY-1");
            this.tester.assertTextPresent("This is the test bug with all the field values set.");
            this.tester.clickLinkWithText("Resolve Issue");
            this.tester.assertTextPresent("Resolve Issue");
            this.tester.assertTextPresent("Resolving an issue indicates that the developers are satisfied the issue is finished.");
            this.tester.submit("Transition");
            ViewIssueDetails viewIssueDetails = this.parse.issue().parseViewIssuePage();
            TestProjectImportResults.assertEquals((String)"Resolved", (String)viewIssueDetails.getStatus());
            TestProjectImportResults.assertEquals((String)"Fixed", (String)viewIssueDetails.getResolution());
            TestProjectImportResults.assertTrue((boolean)viewIssueDetails.getAvailableWorkflowActions().contains("Close Issue"));
            TestProjectImportResults.assertTrue((boolean)viewIssueDetails.getAvailableWorkflowActions().contains("Reopen Issue"));
            TestProjectImportResults.assertEquals((int)2, (int)viewIssueDetails.getAvailableWorkflowActions().size());
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    public void testIssueDataSimpleAllData() throws Exception {
        this._testSimpleImport("10000_bsattach.txt");
        this._testSimpleImport("10000");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _testSimpleImport(String attachmentFilename) throws Exception {
        File tempFile = null;
        File attachmentsBackupDir = null;
        File projectDir = null;
        File issueDir = null;
        File attachmentFile = null;
        try {
            attachmentsBackupDir = new File(new File(this.administration.getJiraHomeDirectory(), "import"), "attachments");
            attachmentsBackupDir.mkdir();
            projectDir = new File(attachmentsBackupDir, "MKY");
            projectDir.mkdir();
            issueDir = new File(projectDir, "MKY-1");
            issueDir.mkdir();
            attachmentFile = new File(issueDir, attachmentFilename);
            attachmentFile.createNewFile();
            tempFile = this.doProjectImport("TestProjectImportStandardSimpleData.xml", "TestProjectImportStandardSimpleDataNoProject.xml");
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/ul");
            String projectDetailsResults = xPathLocator.getText();
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Key: MKY"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Description: This is a description for a monkey project."));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Lead: Fred Normal"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "URL: http://monkeyproject.example.com"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Default Assignee: Project Lead"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Components: 3"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Versions: 3"));
            xPathLocator = new XPathLocator(this.tester, "//div[@id='customfields']/ul");
            String userRoleIssueResults = xPathLocator.getText();
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Users: 2 out of 2"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Administrators: 1 users, 1 groups"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Developers: 1 users, 2 groups"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Users: 1 users, 2 groups"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Issues created: 2 out of 2"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Attachments: 1 out of 1"));
            this.navigation.issueNavigator().displayAllIssues();
            this.tester.assertTextPresent("MKY-1");
            this.tester.assertTextPresent("MKY-2");
            this.navigation.issue().viewIssue("MKY-1");
            ViewIssueDetails details = this.parse.issue().parseViewIssuePage();
            TestProjectImportResults.assertEquals((String)"MKY-1", (String)details.getKey());
            TestProjectImportResults.assertEquals((String)"Bug", (String)details.getIssueType());
            TestProjectImportResults.assertEquals((String)"In Progress", (String)details.getStatus());
            TestProjectImportResults.assertEquals((String)"Blocker", (String)details.getPriority());
            TestProjectImportResults.assertEquals((String)"Fred Normal", (String)details.getAssignee());
            TestProjectImportResults.assertEquals((String)"Wilma Flinstone", (String)details.getReporter());
            TestProjectImportResults.assertEquals((String)"1", (String)details.getVotes());
            this.tester.clickLink("view-voters");
            this.tester.assertTextPresent("voter_link_admin");
            this.tester.clickLinkWithText("MKY-1");
            TestProjectImportResults.assertEquals((String)"1", (String)details.getWatchers());
            this.tester.clickLink("manage-watchers");
            this.tester.assertLinkPresent("watcher_link_wilma");
            this.tester.clickLinkWithText("MKY-1");
            TestProjectImportResults.assertTrue((boolean)details.getAvailableWorkflowActions().contains("Resolve Issue"));
            TestProjectImportResults.assertTrue((boolean)details.getAvailableWorkflowActions().contains("Close Issue"));
            TestProjectImportResults.assertEquals((String)"monkey", (String)details.getProjectName());
            TestProjectImportResults.assertEquals((String)"This is the test bug with all the field values set.", (String)details.getSummary());
            TestProjectImportResults.assertEquals((String)"I am a description field", (String)details.getDescription());
            TestProjectImportResults.assertEquals((String)"03/Jun/08 3:00 PM", (String)details.getCreatedDate());
            TestProjectImportResults.assertEquals((String)"06/Jun/08 2:09 PM", (String)details.getUpdatedDate());
            TestProjectImportResults.assertEquals((String)"09/Jun/08", (String)details.getDueDate());
            TestProjectImportResults.assertEquals(null, (String)details.getResolutionDate());
            TestProjectImportResults.assertTrue((boolean)details.getComponents().contains("First Test Component"));
            TestProjectImportResults.assertTrue((boolean)details.getComponents().contains("Second Test Component"));
            TestProjectImportResults.assertTrue((boolean)details.getAffectsVersions().contains("Cool Version"));
            TestProjectImportResults.assertTrue((boolean)details.getAffectsVersions().contains("Uncool Version"));
            TestProjectImportResults.assertTrue((boolean)details.getFixVersions().contains("Uncool Version"));
            TestProjectImportResults.assertTrue((boolean)details.getFixVersions().contains("Medium Cool Version"));
            TestProjectImportResults.assertEquals((int)3, (int)details.getLabels().size());
            TestProjectImportResults.assertTrue((boolean)details.getLabels().contains("duderino"));
            TestProjectImportResults.assertTrue((boolean)details.getLabels().contains("fancy"));
            TestProjectImportResults.assertTrue((boolean)details.getLabels().contains("labelset"));
            TestProjectImportResults.assertEquals((String)"2d", (String)details.getOriginalEstimate());
            TestProjectImportResults.assertEquals((String)"20h", (String)details.getRemainingEstimate());
            TestProjectImportResults.assertEquals((String)"1d 4h", (String)details.getTimeSpent());
            TestProjectImportResults.assertTrue((boolean)details.getAttachments().contains("bsattach.txt"));
            TestProjectImportResults.assertEquals((String)"I am environment field", (String)details.getEnvironment());
            this.tester.assertLinkPresentWithText("MKY-2");
            this.tester.assertLinkPresentWithText("HSP-1");
            this.tester.assertLinkPresentWithText("HSP-2");
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Cascading Select CF", "Parent Option 1"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Cascading Select CF", "Child Option 1"));
            TestProjectImportResults.assertEquals((String)"01/Jun/08 2:57 PM", (String)details.getCustomFields().get("Date Time CF"));
            TestProjectImportResults.assertEquals((String)"user-dudes", (String)details.getCustomFields().get("Group Picker CF"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Labels CF", "duck duffy mickey mouse"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Multi Checkboxes CF", "Multi Checkbox Option 2"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Multi Checkboxes CF", "Multi Checkbox Option 1"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Multi Select CF", "Multi Select Option 1"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Multi Select CF", "Multi Select Option 2"));
            TestProjectImportResults.assertEquals((String)"42.01", (String)details.getCustomFields().get("Number Field CF"));
            TestProjectImportResults.assertEquals((String)"Radio Option 1", (String)details.getCustomFields().get("Radio Buttons CF"));
            TestProjectImportResults.assertEquals((String)"Select List Option 1", (String)details.getCustomFields().get("Select List CF"));
            TestProjectImportResults.assertEquals((String)"I am text field 255 value.", (String)details.getCustomFields().get("Text Field 255"));
            TestProjectImportResults.assertEquals((String)"Fred Normal", (String)details.getCustomFields().get("User Picker CF"));
            TestProjectImportResults.assertEquals((String)"01/Apr/08", (String)details.getCustomFields().get("Date Picker CF"));
            TestProjectImportResults.assertEquals((String)"I am free text field value.", (String)details.getCustomFields().get("Free Text Field CF"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Multi Group Picker CF", "admin-dudes"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Multi Group Picker CF", "dev-dudes"));
            TestProjectImportResults.assertEquals((String)"homosapien", (String)details.getCustomFields().get("Project Picker CF"));
            TestProjectImportResults.assertEquals((String)"Fred Normal", (String)details.getCustomFields().get("Multi User Picker CF"));
            TestProjectImportResults.assertEquals((String)"Medium Cool Version", (String)details.getCustomFields().get("Single Version Picker CF"));
            TestProjectImportResults.assertEquals((String)"http://www.google.com", (String)details.getCustomFields().get("URL Field CF"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Version Picker CF", "Medium Cool Version"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Version Picker CF", "Cool Version"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Version Picker CF", "Uncool Version"));
            List<Comment> comments = this.parse.issue().parseComments();
            TestProjectImportResults.assertEquals((int)4, (int)comments.size());
            TestProjectImportResults.assertTrue((boolean)comments.contains(new Comment("I am a comment added by Wilma, that has been edited.", "Wilma Flinstone added a comment  - 12/Jun/08 3:03 PM - edited")));
            TestProjectImportResults.assertTrue((boolean)comments.contains(new Comment("I am a comment added by Adminstrator.", "Adminitrator added a comment  - 12/Jun/08 3:11 PM - Restricted to Developers")));
            TestProjectImportResults.assertTrue((boolean)comments.contains(new Comment("I am another Admin comment", "Adminitrator added a comment  - 12/Jun/08 3:15 PM - Restricted to jira-administrators")));
            TestProjectImportResults.assertTrue((boolean)comments.contains(new Comment("I am a comment added by betty.", "betty added a comment  - 12/Jun/08 3:16 PM - Restricted to jira-developers - edited")));
            this.tester.clickLinkWithText("Work Log");
            List<Worklog> worklogs = this.parse.issue().parseWorklogs();
            TestProjectImportResults.assertEquals((int)3, (int)worklogs.size());
            TestProjectImportResults.assertTrue((boolean)worklogs.contains(new Worklog("I am Fred logging work, edited.", "1 day", "Fred Normal logged work  - 12/Jun/08 3:13 PM - Restricted to Developers - edited")));
            TestProjectImportResults.assertTrue((boolean)worklogs.contains(new Worklog("I am admin worklog.", "2 hours", "Adminitrator logged work  - 12/Jun/08 3:15 PM - Restricted to jira-developers")));
            TestProjectImportResults.assertTrue((boolean)worklogs.contains(new Worklog("I am a worklog added by Mrs. Rubble.", "2 hours", "betty logged work  - 12/Jun/08 3:18 PM")));
            this.tester.clickLinkWithText(CHANGE_HISTORY);
            ChangeHistoryList list = this.parse.issue().parseChangeHistory();
            list.assertContainsChangeHistory(this.getExpectedChangeHistoryListForAllData());
            ChangeHistorySet changeHistorySet = (ChangeHistorySet)list.get(list.size() - 1);
            TestProjectImportResults.assertEquals((String)"Adminitrator", (String)changeHistorySet.getChangedBy());
            TestProjectImportResults.assertEquals((String)"Project Import", (String)((ChangeHistoryField)changeHistorySet.getFieldChanges().iterator().next()).getFieldName());
            this.tester.clickLinkWithText("HSP-1");
            this.tester.assertTextPresent("I am a homosap task");
            this.tester.assertLinkPresentWithText("MKY-1");
            ChangeHistoryList hsp1ChangeHistoryList = this.parse.issue().parseChangeHistory();
            hsp1ChangeHistoryList.assertContainsChangeHistory(this.getExpectedHSP1ChangeHistory());
            this.navigation.issue().viewIssue("HSP-2");
            ChangeHistoryList hsp2ChangeHistoryList = this.parse.issue().parseChangeHistory();
            hsp2ChangeHistoryList.assertContainsChangeHistory(this.getExpectedHSP2ChangeHistory());
        }
        finally {
            if (attachmentFile != null) {
                attachmentFile.delete();
            }
            if (tempFile != null) {
                tempFile.delete();
            }
            if (issueDir != null) {
                issueDir.delete();
            }
            if (projectDir != null) {
                projectDir.delete();
            }
        }
    }

    public void testIssueDataSimpleAllDataResolutionDate() throws Exception {
        this.doProjectImport("TestProjectImportStandardSimpleDataResolutionDate.xml", "TestProjectImportStandardSimpleDataNoProject.xml");
        this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
        this.tester.assertSubmitButtonPresent("Import");
        this.tester.submit("Import");
        this.advanceThroughWaitingPage();
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/ul");
        String projectDetailsResults = xPathLocator.getText();
        TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Key: MKY"));
        TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Description: This is a description for a monkey project."));
        TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Lead: Fred Normal"));
        TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "URL: http://monkeyproject.example.com"));
        TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Default Assignee: Project Lead"));
        TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Components: 3"));
        TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Versions: 3"));
        xPathLocator = new XPathLocator(this.tester, "//div[@id='customfields']/ul");
        String userRoleIssueResults = xPathLocator.getText();
        TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Users: 2 out of 2"));
        TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Administrators: 1 users, 1 groups"));
        TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Developers: 1 users, 2 groups"));
        TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Users: 1 users, 2 groups"));
        TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Issues created: 3 out of 3"));
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("MKY-1");
        this.tester.assertTextPresent("MKY-2");
        this.tester.assertTextPresent("MKY-3");
        this.navigation.issue().viewIssue("MKY-1");
        ViewIssueDetails details = this.parse.issue().parseViewIssuePage();
        TestProjectImportResults.assertEquals((String)"monkey", (String)details.getProjectName());
        TestProjectImportResults.assertEquals((String)"This is the test bug with all the field values set.", (String)details.getSummary());
        TestProjectImportResults.assertEquals((String)"I am a description field", (String)details.getDescription());
        TestProjectImportResults.assertEquals((String)"03/Jun/08 3:00 PM", (String)details.getCreatedDate());
        TestProjectImportResults.assertEquals((String)"06/Jun/08 2:09 PM", (String)details.getUpdatedDate());
        TestProjectImportResults.assertEquals((String)"09/Jun/08", (String)details.getDueDate());
        TestProjectImportResults.assertEquals(null, (String)details.getResolutionDate());
        this.navigation.issue().viewIssue("MKY-3");
        ViewIssueDetails resolvedDetails = this.parse.issue().parseViewIssuePage();
        TestProjectImportResults.assertEquals((String)"This is the test bug with all the field values set and with resolution", (String)resolvedDetails.getSummary());
        TestProjectImportResults.assertEquals((String)"01/May/08 2:04 PM", (String)resolvedDetails.getCreatedDate());
        TestProjectImportResults.assertEquals((String)"01/Dec/08 2:05 PM", (String)resolvedDetails.getUpdatedDate());
        TestProjectImportResults.assertEquals((String)"09/Jun/08", (String)resolvedDetails.getDueDate());
        TestProjectImportResults.assertEquals((String)"19/Nov/08 2:04 PM", (String)resolvedDetails.getResolutionDate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonExistantCustomFieldValueIsIgnoredAndImportIsSuccessful() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportStandardNonExistantCustomFieldData.xml", "TestProjectImportStandardSimpleDataNoProject.xml");
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.text.assertTextPresentHtmlEncoded("The custom field 'Resolved date CF' will not be imported because the custom field type 'com.atlassian.jira.toolkit:resolveddate' is not installed.");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/ul");
            String projectDetailsResults = xPathLocator.getText();
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Key: MKY"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Description: This is a description for a monkey project."));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Lead: Fred Normal"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "URL: http://monkeyproject.example.com"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Default Assignee: Project Lead"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Components: 3"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Versions: 3"));
            xPathLocator = new XPathLocator(this.tester, "//div[@id='customfields']/ul");
            String userRoleIssueResults = xPathLocator.getText();
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Users: 2 out of 2"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Administrators: 1 users, 1 groups"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Developers: 1 users, 2 groups"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Users: 1 users, 2 groups"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Issues created: 2 out of 2"));
            this.navigation.issueNavigator().displayAllIssues();
            this.tester.assertTextPresent("MKY-1");
            this.tester.assertTextPresent("MKY-2");
            this.navigation.issue().viewIssue("MKY-1");
            ViewIssueDetails details = this.parse.issue().parseViewIssuePage();
            TestProjectImportResults.assertEquals((String)"MKY-1", (String)details.getKey());
            TestProjectImportResults.assertEquals((String)"Bug", (String)details.getIssueType());
            TestProjectImportResults.assertEquals((String)"Resolved", (String)details.getStatus());
            TestProjectImportResults.assertEquals((String)"Blocker", (String)details.getPriority());
            TestProjectImportResults.assertEquals((String)"Fred Normal", (String)details.getAssignee());
            TestProjectImportResults.assertEquals((String)"Wilma Flinstone", (String)details.getReporter());
            TestProjectImportResults.assertEquals((String)"1", (String)details.getVotes());
            this.tester.clickLink("view-voters");
            this.tester.assertTextPresent("voter_link_admin");
            this.tester.clickLinkWithText("MKY-1");
            TestProjectImportResults.assertEquals((String)"1", (String)details.getWatchers());
            this.tester.clickLink("manage-watchers");
            this.tester.assertLinkPresent("watcher_link_wilma");
            this.tester.clickLinkWithText("MKY-1");
            TestProjectImportResults.assertTrue((boolean)details.getAvailableWorkflowActions().contains("Reopen Issue"));
            TestProjectImportResults.assertTrue((boolean)details.getAvailableWorkflowActions().contains("Close Issue"));
            TestProjectImportResults.assertEquals((String)"monkey", (String)details.getProjectName());
            TestProjectImportResults.assertEquals((String)"This is the test bug with all the field values set.", (String)details.getSummary());
            TestProjectImportResults.assertEquals((String)"I am a description field", (String)details.getDescription());
            TestProjectImportResults.assertEquals((String)"03/Jun/08 3:00 PM", (String)details.getCreatedDate());
            TestProjectImportResults.assertEquals((String)"06/Jun/08 2:09 PM", (String)details.getUpdatedDate());
            TestProjectImportResults.assertEquals((String)"09/Jun/08", (String)details.getDueDate());
            TestProjectImportResults.assertTrue((boolean)details.getComponents().contains("First Test Component"));
            TestProjectImportResults.assertTrue((boolean)details.getComponents().contains("Second Test Component"));
            TestProjectImportResults.assertTrue((boolean)details.getAffectsVersions().contains("Cool Version"));
            TestProjectImportResults.assertTrue((boolean)details.getAffectsVersions().contains("Uncool Version"));
            TestProjectImportResults.assertTrue((boolean)details.getFixVersions().contains("Uncool Version"));
            TestProjectImportResults.assertTrue((boolean)details.getFixVersions().contains("Medium Cool Version"));
            TestProjectImportResults.assertEquals((String)"2d", (String)details.getOriginalEstimate());
            TestProjectImportResults.assertEquals((String)"20h", (String)details.getRemainingEstimate());
            TestProjectImportResults.assertEquals((String)"1d 4h", (String)details.getTimeSpent());
            TestProjectImportResults.assertEquals((String)"I am environment field", (String)details.getEnvironment());
            this.tester.assertLinkPresentWithText("MKY-2");
            this.tester.assertLinkPresentWithText("HSP-1");
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Cascading Select CF", "Parent Option 1"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Cascading Select CF", "Child Option 1"));
            TestProjectImportResults.assertEquals((String)"01/Jun/08 2:57 PM", (String)details.getCustomFields().get("Date Time CF"));
            TestProjectImportResults.assertEquals((String)"user-dudes", (String)details.getCustomFields().get("Group Picker CF"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Multi Checkboxes CF", "Multi Checkbox Option 2"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Multi Checkboxes CF", "Multi Checkbox Option 1"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Multi Select CF", "Multi Select Option 1"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Multi Select CF", "Multi Select Option 2"));
            TestProjectImportResults.assertEquals((String)"42.01", (String)details.getCustomFields().get("Number Field CF"));
            TestProjectImportResults.assertEquals((String)"Radio Option 1", (String)details.getCustomFields().get("Radio Buttons CF"));
            TestProjectImportResults.assertEquals((String)"Select List Option 1", (String)details.getCustomFields().get("Select List CF"));
            TestProjectImportResults.assertEquals((String)"I am text field 255 value.", (String)details.getCustomFields().get("Text Field 255"));
            TestProjectImportResults.assertEquals((String)"Fred Normal", (String)details.getCustomFields().get("User Picker CF"));
            TestProjectImportResults.assertEquals((String)"01/Apr/08", (String)details.getCustomFields().get("Date Picker CF"));
            TestProjectImportResults.assertEquals((String)"I am free text field value.", (String)details.getCustomFields().get("Free Text Field CF"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Multi Group Picker CF", "admin-dudes"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Multi Group Picker CF", "dev-dudes"));
            TestProjectImportResults.assertEquals((String)"homosapien", (String)details.getCustomFields().get("Project Picker CF"));
            TestProjectImportResults.assertEquals((String)"Fred Normal", (String)details.getCustomFields().get("Multi User Picker CF"));
            TestProjectImportResults.assertEquals((String)"Medium Cool Version", (String)details.getCustomFields().get("Single Version Picker CF"));
            TestProjectImportResults.assertEquals((String)"http://www.google.com", (String)details.getCustomFields().get("URL Field CF"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Version Picker CF", "Medium Cool Version"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Version Picker CF", "Cool Version"));
            TestProjectImportResults.assertTrue((boolean)details.customFieldValueContains("Version Picker CF", "Uncool Version"));
            TestProjectImportResults.assertNull((Object)details.getCustomFields().get("Resolved date CF"));
            this.tester.assertTextNotPresent("Resolved date CF");
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIssueDataSimpleMinimalData() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportStandardSimpleData.xml", "TestProjectImportStandardSimpleDataNoProject.xml");
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/ul");
            String projectDetailsResults = xPathLocator.getText();
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Key: MKY"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Description: This is a description for a monkey project."));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Lead: Fred Normal"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "URL: http://monkeyproject.example.com"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Default Assignee: Project Lead"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Components: 3"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Versions: 3"));
            xPathLocator = new XPathLocator(this.tester, "//div[@id='customfields']/ul");
            String userRoleIssueResults = xPathLocator.getText();
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Users: 2 out of 2"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Administrators: 1 users, 1 groups"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Developers: 1 users, 2 groups"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Users: 1 users, 2 groups"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(userRoleIssueResults, "Issues created: 2 out of 2"));
            this.navigation.issue().viewIssue("MKY-2");
            ViewIssueDetails details = this.parse.issue().parseViewIssuePage();
            TestProjectImportResults.assertEquals((String)"MKY-2", (String)details.getKey());
            TestProjectImportResults.assertEquals((String)"New Feature", (String)details.getIssueType());
            TestProjectImportResults.assertEquals((String)"Open", (String)details.getStatus());
            TestProjectImportResults.assertEquals((String)"Critical", (String)details.getPriority());
            TestProjectImportResults.assertEquals((String)"Fred Normal", (String)details.getAssignee());
            TestProjectImportResults.assertEquals((String)"Adminitrator", (String)details.getReporter());
            TestProjectImportResults.assertEquals((String)"0", (String)details.getVotes());
            TestProjectImportResults.assertEquals((String)"0", (String)details.getWatchers());
            TestProjectImportResults.assertTrue((boolean)details.getAvailableWorkflowActions().contains("Resolve Issue"));
            TestProjectImportResults.assertTrue((boolean)details.getAvailableWorkflowActions().contains("Close Issue"));
            TestProjectImportResults.assertEquals((String)"monkey", (String)details.getProjectName());
            TestProjectImportResults.assertEquals((String)"I am a test issue with almost no field values set", (String)details.getSummary());
            TestProjectImportResults.assertEquals((String)"01/Jun/08 3:20 PM", (String)details.getCreatedDate());
            TestProjectImportResults.assertEquals((String)"02/Jun/08 3:53 PM", (String)details.getUpdatedDate());
            TestProjectImportResults.assertEquals(null, (String)details.getDueDate());
            TestProjectImportResults.assertEquals(null, (String)details.getDescription());
            TestProjectImportResults.assertTrue((boolean)details.getComponents().contains("None"));
            TestProjectImportResults.assertTrue((boolean)details.getAffectsVersions().contains("None"));
            TestProjectImportResults.assertTrue((boolean)details.getFixVersions().contains("None"));
            TestProjectImportResults.assertEquals(null, (String)details.getOriginalEstimate());
            TestProjectImportResults.assertEquals(null, (String)details.getRemainingEstimate());
            TestProjectImportResults.assertEquals(null, (String)details.getTimeSpent());
            TestProjectImportResults.assertEquals((int)0, (int)details.getAttachments().size());
            TestProjectImportResults.assertEquals(null, (String)details.getEnvironment());
            this.tester.assertLinkPresentWithText("MKY-1");
            TestProjectImportResults.assertEquals((int)0, (int)details.getCustomFields().size());
            List<Comment> comments = this.parse.issue().parseComments();
            TestProjectImportResults.assertEquals((int)0, (int)comments.size());
            this.tester.clickLinkWithText("Work Log");
            List<Worklog> worklogs = this.parse.issue().parseWorklogs();
            TestProjectImportResults.assertEquals((int)0, (int)worklogs.size());
            this.tester.clickLinkWithText(CHANGE_HISTORY);
            ChangeHistoryList list = this.parse.issue().parseChangeHistory();
            list.assertContainsChangeHistory(this.getExpectedChangeHistoryListForMinimal());
            ChangeHistorySet changeHistorySet = (ChangeHistorySet)list.get(list.size() - 1);
            TestProjectImportResults.assertEquals((String)"Adminitrator", (String)changeHistorySet.getChangedBy());
            TestProjectImportResults.assertEquals((String)"Project Import", (String)((ChangeHistoryField)changeHistorySet.getFieldChanges().iterator().next()).getFieldName());
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    private ChangeHistoryList getExpectedChangeHistoryListForMinimal() {
        ChangeHistoryList expectedList = new ChangeHistoryList();
        expectedList.addChangeSet("Adminitrator").add("Field", "Original Value", "New Value").add("Link", null, "This issue duplicates MKY-1 [ MKY-1 ]");
        expectedList.addChangeSet("Adminitrator").add("User Picker CF", null, "betty");
        return expectedList;
    }

    private ChangeHistoryList getExpectedHSP1ChangeHistory() {
        ChangeHistoryList expectedList = new ChangeHistoryList();
        expectedList.addChangeSet("Fred Normal").add("Field", "Original Value", "New Value").add("Link", null, "This issue duplicates MKY-1 [ MKY-1 ]");
        expectedList.addChangeSet("Adminitrator").add("Link", "This issue duplicates MKY-1 [ MKY-1 ]", null);
        expectedList.addChangeSet("Adminitrator").add("Reporter", "Fred Normal [ fred ]", "Adminitrator [ admin ]");
        expectedList.addChangeSet("Adminitrator").add("Link", null, "This issue duplicates MKY-1 [ MKY-1 ]");
        return expectedList;
    }

    private ChangeHistoryList getExpectedHSP2ChangeHistory() {
        ChangeHistoryList expectedList = new ChangeHistoryList();
        expectedList.addChangeSet("Adminitrator").add("Field", "Original Value", "New Value").add("Link", null, "This issue is duplicated by MKY-1 [ MKY-1 ]");
        return expectedList;
    }

    private ChangeHistoryList getExpectedChangeHistoryListForAllData() {
        ChangeHistoryList expectedList = new ChangeHistoryList();
        expectedList.addChangeSet("Adminitrator").add("Field", "Original Value", "New Value").add("Multi Checkboxes CF", "[Multi Checkbox Option 2, Multi Checkbox Option 1]", "[Multi Checkbox Option 1, Multi Checkbox Option 2]").add("Version Picker CF", "Medium Cool Version, Uncool Version, Cool Version [ 10002, 10001, 10000 ]", "Cool Version, Uncool Version, Medium Cool Version [ 10000, 10001, 10002 ]").add("Multi User Picker CF", "[admin, fred]", "[betty, fred]").add("Multi Select CF ", "[Multi Select Option 2, Multi Select Option 1]", "[Multi Select Option 1, Multi Select Option 2]");
        expectedList.addChangeSet("Fred Normal").add("Remaining Estimate", null, "2 days [ 172800 ]").add("Original Estimate", null, "2 days [ 172800 ]").add("Version Picker CF", "Medium Cool Version, Uncool Version, Cool Version [ 10002, 10001, 10000 ]", "Cool Version, Uncool Version, Medium Cool Version [ 10000, 10001, 10002 ]").add("Multi Checkboxes CF", "[Multi Checkbox Option 2, Multi Checkbox Option 1]", "[Multi Checkbox Option 1, Multi Checkbox Option 2]").add("Multi Select CF", "[Multi Select Option 2, Multi Select Option 1]", "[Multi Select Option 1, Multi Select Option 2]");
        expectedList.addChangeSet("Fred Normal").add("Time Spent", null, "1 day [ 86400 ]").add("Remaining Estimate", "2 days [ 172800 ]", "1 day [ 86400 ]");
        expectedList.addChangeSet("Adminitrator").add("Time Spent", "1 day [ 86400 ]", "1 day, 2 hours [ 93600 ]").add("Remaining Estimate", "1 day [ 86400 ]", "22 hours [ 79200 ]");
        expectedList.addChangeSet("betty").add("Remaining Estimate", "22 hours [ 79200 ]", "20 hours [ 72000 ]").add("Time Spent", "1 day, 2 hours [ 93600 ]", "1 day, 4 hours [ 100800 ]");
        expectedList.addChangeSet("Adminitrator").add("Link", null, "This issue is duplicated by MKY-2 [ MKY-2 ]");
        expectedList.addChangeSet("Fred Normal").add("Status", "Open [ 1 ]", "In Progress [ 3 ]");
        expectedList.addChangeSet("Fred Normal").add("Version Picker CF", "Medium Cool Version, Uncool Version, Cool Version [ 10002, 10001, 10000 ]", "Cool Version, Uncool Version, Medium Cool Version [ 10000, 10001, 10002 ]").add("Multi Checkboxes CF", "[Multi Checkbox Option 2, Multi Checkbox Option 1]", "[Multi Checkbox Option 1, Multi Checkbox Option 2]").add("Due Date", "2008-07-02 00:00:00.0").add("Multi Select CF", "[Multi Select Option 2, Multi Select Option 1]", "[Multi Select Option 1, Multi Select Option 2]");
        expectedList.addChangeSet("Fred Normal").add("Link", null, "This issue is duplicated by HSP-1 [ HSP-1 ]");
        expectedList.addChangeSet("Adminitrator").add("Multi Checkboxes CF", "[Multi Checkbox Option 2, Multi Checkbox Option 1]", "[Multi Checkbox Option 1, Multi Checkbox Option 2]").add("Fix Version/s", null, "Uncool Version [ 10001 ]").add("Version Picker CF", "Medium Cool Version, Cool Version, Uncool Version [ 10002, 10000, 10001 ]", "Cool Version, Uncool Version, Medium Cool Version [ 10000, 10001, 10002 ]").add("Fix Version/s", null, "Medium Cool Version [ 10002 ]");
        expectedList.addChangeSet("Adminitrator").add("Link", null, "This issue duplicates HSP-2 [ HSP-2 ]");
        return expectedList;
    }

    private boolean stringContains(String value, String subString) {
        return value.indexOf(subString) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateProject() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportStandardSimpleData.xml", "TestProjectImportStandardSimpleDataNoProject.xml");
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/ul");
            String projectDetailsResults = xPathLocator.getText();
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Key: MKY"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Description: This is a description for a monkey project."));
            this.tester.clickLinkWithText("MKY");
            this.assertions.assertNodeByIdHasText("project-config-header-name", "monkey");
            ProjectClient pc = new ProjectClient(this.environmentData);
            Project project = pc.get("MKY");
            TestProjectImportResults.assertEquals((String)"monkey", (String)project.name);
            TestProjectImportResults.assertEquals((String)"This is a description for a monkey project.", (String)project.description);
            TestProjectImportResults.assertEquals((String)"http://monkeyproject.example.com", (String)project.url);
            TestProjectImportResults.assertEquals((String)"Fred Normal", (String)project.lead.displayName);
            this.assertMonkeyProjectParts(false);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    private void assertMonkeyProjectParts(boolean testComponentLead) {
        ProjectClient pc = new ProjectClient(this.environmentData);
        List<Component> components = pc.getComponents("MKY");
        TestProjectImportResults.assertEquals((int)3, (int)components.size());
        TestProjectImportResults.assertEquals((String)"First Test Component", (String)components.get((int)0).name);
        if (testComponentLead) {
            TestProjectImportResults.assertEquals((String)"wilma", (String)components.get((int)0).lead.name);
        }
        TestProjectImportResults.assertEquals((String)"Second Test Component", (String)components.get((int)1).name);
        TestProjectImportResults.assertEquals((String)"Third Test Component", (String)components.get((int)2).name);
        List<Version> versions = pc.getVersions("MKY");
        TestProjectImportResults.assertEquals((int)3, (int)versions.size());
        TestProjectImportResults.assertEquals((String)"Cool Version", (String)versions.get((int)0).name);
        TestProjectImportResults.assertEquals((String)"Uncool Version", (String)versions.get((int)1).name);
        TestProjectImportResults.assertEquals((String)"Medium Cool Version", (String)versions.get((int)2).name);
        ProjectRoleClient prc = new ProjectRoleClient(this.environmentData);
        Map mky = prc.get("MKY");
        TestProjectImportResults.assertEquals((int)3, (int)mky.size());
        ProjectRole projectRole = prc.get("MKY", "Administrators");
        TestProjectImportResults.assertEquals((int)2, (int)projectRole.actors.size());
        TestProjectImportResults.assertEquals((String)"admin-dudes", (String)projectRole.actors.get((int)0).name);
        TestProjectImportResults.assertEquals((String)"atlassian-group-role-actor", (String)projectRole.actors.get((int)0).type);
        TestProjectImportResults.assertEquals((String)"admin", (String)projectRole.actors.get((int)1).name);
        TestProjectImportResults.assertEquals((String)"atlassian-user-role-actor", (String)projectRole.actors.get((int)1).type);
        projectRole = prc.get("MKY", "Developers");
        TestProjectImportResults.assertEquals((int)3, (int)projectRole.actors.size());
        TestProjectImportResults.assertEquals((String)"dev-dudes", (String)projectRole.actors.get((int)0).name);
        TestProjectImportResults.assertEquals((String)"atlassian-group-role-actor", (String)projectRole.actors.get((int)0).type);
        TestProjectImportResults.assertEquals((String)"fred", (String)projectRole.actors.get((int)1).name);
        TestProjectImportResults.assertEquals((String)"atlassian-user-role-actor", (String)projectRole.actors.get((int)1).type);
        TestProjectImportResults.assertEquals((String)"jira-developers", (String)projectRole.actors.get((int)2).name);
        TestProjectImportResults.assertEquals((String)"atlassian-group-role-actor", (String)projectRole.actors.get((int)2).type);
        projectRole = prc.get("MKY", "Users");
        TestProjectImportResults.assertEquals((int)3, (int)projectRole.actors.size());
        TestProjectImportResults.assertEquals((String)"jira-users", (String)projectRole.actors.get((int)0).name);
        TestProjectImportResults.assertEquals((String)"atlassian-group-role-actor", (String)projectRole.actors.get((int)0).type);
        TestProjectImportResults.assertEquals((String)"user-dudes", (String)projectRole.actors.get((int)1).name);
        TestProjectImportResults.assertEquals((String)"atlassian-group-role-actor", (String)projectRole.actors.get((int)1).type);
        TestProjectImportResults.assertEquals((String)"wilma", (String)projectRole.actors.get((int)2).name);
        TestProjectImportResults.assertEquals((String)"atlassian-user-role-actor", (String)projectRole.actors.get((int)2).type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateProjectOverwriteDetails() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImportUpdateProject("TestProjectImportStandardSimpleData.xml", "TestProjectImportStandardSimpleDataNoProject.xml", true);
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/ul");
            String projectDetailsResults = xPathLocator.getText();
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Key: MKY"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Description: This is a description for a monkey project."));
            this.tester.submit("OK");
            this.assertions.assertNodeByIdHasText("project-config-header-name", "monkey");
            ProjectClient pc = new ProjectClient(this.environmentData);
            Project project = pc.get("MKY");
            TestProjectImportResults.assertEquals((String)"monkey", (String)project.name);
            TestProjectImportResults.assertEquals((String)"This is a description for a monkey project.", (String)project.description);
            TestProjectImportResults.assertEquals((String)"http://monkeyproject.example.com", (String)project.url);
            TestProjectImportResults.assertEquals((String)"Fred Normal", (String)project.lead.displayName);
            this.assertMonkeyProjectParts(false);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateProjectOverwriteDetailsWithSenderAddressAndComponentLeads() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportEnterpriseSimpleData.xml", "TestProjectImportEnterpriseSimpleDataEmptyProject.xml");
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/ul");
            String projectDetailsResults = xPathLocator.getText();
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Key: MKY"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Description: This is a description for a monkey project."));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Sender Address: jira-monkey-test@example.com"));
            ProjectClient pc = new ProjectClient(this.environmentData);
            Project mky = pc.get("MKY");
            TestProjectImportResults.assertEquals((String)"MKY", (String)mky.key);
            TestProjectImportResults.assertEquals((String)"monkey", (String)mky.name);
            TestProjectImportResults.assertEquals((String)"This is a description for a monkey project.", (String)mky.description);
            TestProjectImportResults.assertEquals((String)"fred", (String)mky.lead.name);
            this.tester.gotoPage("/plugins/servlet/project-config/MKY/summary");
            this.tester.assertTextInElement("project-config-email", "jira-monkey-test@example.com");
            this.assertMonkeyProjectParts(true);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateProjectDoNotOverwriteDetails() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImportUpdateProject("TestProjectImportStandardSimpleData.xml", "TestProjectImportStandardSimpleDataNoProject.xml", false);
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/ul");
            String projectDetailsResults = xPathLocator.getText();
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Key: MKY"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Description: existing monk thing"));
            ProjectClient pc = new ProjectClient(this.environmentData);
            Project project = pc.get("MKY");
            TestProjectImportResults.assertEquals((String)"King Monkey", (String)project.name);
            TestProjectImportResults.assertEquals((String)"existing monk thing", (String)project.description);
            TestProjectImportResults.assertEquals((String)"http://www.kingkong.net", (String)project.url);
            TestProjectImportResults.assertEquals((String)"John Smith", (String)project.lead.displayName);
            List<Component> components = pc.getComponents("MKY");
            TestProjectImportResults.assertEquals((int)3, (int)components.size());
            TestProjectImportResults.assertEquals((String)"First Test Component", (String)components.get((int)0).name);
            TestProjectImportResults.assertEquals((String)"Second Test Component", (String)components.get((int)1).name);
            TestProjectImportResults.assertEquals((String)"Third Test Component", (String)components.get((int)2).name);
            List<Version> versions = pc.getVersions("MKY");
            TestProjectImportResults.assertEquals((int)3, (int)versions.size());
            TestProjectImportResults.assertEquals((String)"Cool Version", (String)versions.get((int)0).name);
            TestProjectImportResults.assertEquals((String)"Uncool Version", (String)versions.get((int)1).name);
            TestProjectImportResults.assertEquals((String)"Medium Cool Version", (String)versions.get((int)2).name);
            ProjectRoleClient prc = new ProjectRoleClient(this.environmentData);
            Map mky = prc.get("MKY");
            TestProjectImportResults.assertEquals((int)3, (int)mky.size());
            ProjectRole projectRole = prc.get("MKY", "Administrators");
            TestProjectImportResults.assertEquals((int)1, (int)projectRole.actors.size());
            TestProjectImportResults.assertEquals((String)"jira-administrators", (String)projectRole.actors.get((int)0).name);
            TestProjectImportResults.assertEquals((String)"atlassian-group-role-actor", (String)projectRole.actors.get((int)0).type);
            projectRole = prc.get("MKY", "Developers");
            TestProjectImportResults.assertEquals((int)1, (int)projectRole.actors.size());
            TestProjectImportResults.assertEquals((String)"jira-developers", (String)projectRole.actors.get((int)0).name);
            TestProjectImportResults.assertEquals((String)"atlassian-group-role-actor", (String)projectRole.actors.get((int)0).type);
            projectRole = prc.get("MKY", "Users");
            TestProjectImportResults.assertEquals((int)1, (int)projectRole.actors.size());
            TestProjectImportResults.assertEquals((String)"jira-users", (String)projectRole.actors.get((int)0).name);
            TestProjectImportResults.assertEquals((String)"atlassian-group-role-actor", (String)projectRole.actors.get((int)0).type);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testViewIssueIssueSecurityLevel() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportEnterpriseSimpleData.xml", "TestProjectImportEnterpriseSimpleDataEmptyProject.xml");
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/ul");
            String projectDetailsResults = xPathLocator.getText();
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Key: MKY"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Description: This is a description for a monkey project."));
            this.navigation.issueNavigator().displayAllIssues();
            this.tester.assertTextPresent("MKY-1");
            this.tester.assertTextPresent("MKY-2");
            this.navigation.issue().viewIssue("MKY-1");
            ViewIssueDetails details = this.parse.issue().parseViewIssuePage();
            TestProjectImportResults.assertEquals((String)"MKY-1", (String)details.getKey());
            TestProjectImportResults.assertEquals((String)"Security Level 3", (String)details.getSecurityLevel());
            this.navigation.issue().viewIssue("MKY-2");
            details = this.parse.issue().parseViewIssuePage();
            TestProjectImportResults.assertEquals((String)"MKY-2", (String)details.getKey());
            TestProjectImportResults.assertEquals((String)"Security Level 2", (String)details.getSecurityLevel());
            this.navigation.logout();
            this.navigation.login("wilma", "wilma");
            this.navigation.issue().viewIssue("MKY-1");
            this.tester.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
            this.navigation.issue().viewIssue("MKY-2");
            this.tester.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
            this.navigation.issueNavigator().displayAllIssues();
            this.tester.assertTextNotPresent("MKY-1");
            this.tester.assertTextNotPresent("MKY-2");
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
            this.navigation.logout();
            this.navigation.login("admin", "admin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIssueWorkflowActionsNonStandardWorkflow() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportEnterpriseCrazyWorkflowData.xml", "TestProjectImportEnterpriseCrazyWorkflowDataEmptyProject.xml");
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/ul");
            String projectDetailsResults = xPathLocator.getText();
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Key: MKY"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Description: This is a description for a monkey project."));
            this.navigation.issue().viewIssue("MKY-1");
            this.tester.assertTextPresent("This is the test bug with all the field values set.");
            ViewIssueDetails viewIssueDetails = this.parse.issue().parseViewIssuePage();
            TestProjectImportResults.assertEquals((String)"Crazy Open", (String)viewIssueDetails.getStatus());
            TestProjectImportResults.assertTrue((boolean)viewIssueDetails.getAvailableWorkflowActions().contains("Be Dangerous"));
            TestProjectImportResults.assertTrue((boolean)viewIssueDetails.getAvailableWorkflowActions().contains("Be Crazy Done"));
            this.tester.clickLinkWithText("Be Dangerous");
            viewIssueDetails = this.parse.issue().parseViewIssuePage();
            TestProjectImportResults.assertEquals((String)"Hecka Dangerous", (String)viewIssueDetails.getStatus());
            TestProjectImportResults.assertTrue((boolean)viewIssueDetails.getAvailableWorkflowActions().contains("Be Dylan"));
            TestProjectImportResults.assertTrue((boolean)viewIssueDetails.getAvailableWorkflowActions().contains("Be Mark"));
            TestProjectImportResults.assertEquals((int)2, (int)viewIssueDetails.getAvailableWorkflowActions().size());
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportSubtask() throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportEnterpriseSimpleData.xml", "TestProjectImportEnterpriseSimpleDataEmptyProject.xml");
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/ul");
            String projectDetailsResults = xPathLocator.getText();
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Key: MKY"));
            TestProjectImportResults.assertTrue((boolean)this.stringContains(projectDetailsResults, "Description: This is a description for a monkey project."));
            this.navigation.issueNavigator().displayAllIssues();
            this.tester.assertTextPresent("MKY-1");
            this.tester.assertTextPresent("MKY-2");
            this.tester.assertTextPresent("MKY-3");
            this.navigation.issue().viewIssue("MKY-3");
            ViewIssueDetails issueDetails = this.parse.issue().parseViewIssuePage();
            TestProjectImportResults.assertEquals((String)"MKY-3", (String)issueDetails.getKey());
            TestProjectImportResults.assertEquals((String)"Sub-task 2", (String)issueDetails.getIssueType());
            TestProjectImportResults.assertEquals((String)"Gotta do some small stuff to get teh parent done.", (String)issueDetails.getDescription());
            this.tester.assertLinkPresentWithText("MKY-1");
            this.tester.clickLink("subtask-to-issue");
            this.tester.assertTextPresent("Convert Sub-task to Issue: MKY-3");
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    File doProjectImportUpdateProject(String backupFileName, String currentSystemXML, boolean overwrite) {
        File tempFile = this.importAndExportBackupAndSetupCurrentInstance(backupFileName, currentSystemXML);
        long projectId = this.administration.project().addProject("King Monkey", "MKY", "john");
        this.administration.project().editProject(projectId, null, "existing monk thing", "http://www.kingkong.net");
        this.navigation.gotoAdminSection("project_import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupXmlPath", tempFile.getAbsolutePath());
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "monkey");
        if (overwrite) {
            this.tester.checkCheckbox("overwrite", "true");
        } else {
            this.tester.uncheckCheckbox("overwrite");
        }
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        return tempFile;
    }

    public void navigateToUser(String username) {
        this.log("Navigating in UserBrowser to User " + username);
        this.tester.gotoPage(PAGE_USER_BROWSER);
        this.tester.clickLink(username);
    }
}

