/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter.management;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
public class TestChangeSharedFilterOwnerByAdmins
extends FuncTestCase {
    private static final String DEV1 = "developer";
    private static final String DEV2 = "anotherdev";
    private static final String USER = "Fred";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestChangeSharedFilterOwnerByAdmins.xml");
    }

    public void testAnAdminIsAbleToChangeOwnersOfFiltersSharedWithAGroupHeDoesNotBelongTo() {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10006L).name("Shared Filter With Group jira-developers owned by developer").owner("Another Developer").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().changeFilterOwner(10006L, DEV2).filters().list();
        TestChangeSharedFilterOwnerByAdmins.assertNotNull(actualFilterItems);
        TestChangeSharedFilterOwnerByAdmins.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
        TestChangeSharedFilterOwnerByAdmins.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.in(actualFilterItems)));
    }

    public void testAnAdminIsAbleToChangeOwnerOfFiltersSharedWithAGroupHeBelongsTo() throws Exception {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10002L).name("Shared Filter With Group jira-users owned by fred").owner("Developer").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().changeFilterOwner(10002L, DEV1).filters().list();
        TestChangeSharedFilterOwnerByAdmins.assertNotNull(actualFilterItems);
        TestChangeSharedFilterOwnerByAdmins.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
        TestChangeSharedFilterOwnerByAdmins.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.in(actualFilterItems)));
    }

    public void testAnAdminIsAbleToChangeOwnerOfFiltersSharedWithARoleHeIsNotPartOf() throws Exception {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10004L).name("Shared Filter With Role Developers on homosapien owned by developer").owner("Another Developer").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().changeFilterOwner(10004L, DEV2).filters().list();
        TestChangeSharedFilterOwnerByAdmins.assertNotNull(actualFilterItems);
        TestChangeSharedFilterOwnerByAdmins.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
        TestChangeSharedFilterOwnerByAdmins.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.in(actualFilterItems)));
    }

    public void testAnAdminIsAbleToChangeOwnerOfFiltersSharedWithARoleHeIsPartOf() throws Exception {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10001L).name("Shared Filter With Role Users on homosapien owned by fred").owner("Developer").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().changeFilterOwner(10001L, DEV1).filters().list();
        TestChangeSharedFilterOwnerByAdmins.assertNotNull(actualFilterItems);
        TestChangeSharedFilterOwnerByAdmins.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
        TestChangeSharedFilterOwnerByAdmins.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.in(actualFilterItems)));
    }

    public void testAnAdminCannotChangeOwnerOfFiltersWhenNewOwnerDoesNotHaveSharePermission() throws Exception {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10004L).name("Shared Filter With Role Developers on homosapien owned by developer").owner("Fred Normal").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().changeFilterOwner(10004L, USER).filters().list();
        TestChangeSharedFilterOwnerByAdmins.assertNotNull(actualFilterItems);
        TestChangeSharedFilterOwnerByAdmins.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
        TestChangeSharedFilterOwnerByAdmins.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.not((Predicate)Predicates.in(actualFilterItems))));
    }
}

