/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.navigation.FilterNavigation;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.parser.filter.FilterList;
import com.atlassian.jira.functest.framework.parser.filter.WebTestSharePermission;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
public class TestSearchFiltersShareType
extends FuncTestCase {
    private static final String JIRA_ADMINISTRATORS_GROUP = "jira-administrators";
    private static final String JIRA_DEVELOPERS_GROUP = "jira-developers";
    private static final Long HOMOSAPIEN_PROJECT_ID = 10000L;
    private static final Long MONKEY_PROJECT_ID = 10001L;
    private static final String MONKEY_PROJECT_NAME = "monkey";
    private static final Long NAGGERS_ROLE_ID = 10010L;
    private static final String NAGGERS_ROLE_NAME = "Naggers";
    private static final String ADMIN_USER_STRING = "Administrator (admin)";
    private static final String WIFE_USER_STRING = "wife the nagger (wife)";
    private static final String JIRA_USERS_GROUP = "jira-users";
    private static final int PAGE_SIZE = 20;
    private static final String NEXT_LINK_TEXT = "Next >>";
    private static final String PREVIOUS_LINK_TEXT = "<< Previous";
    private static final FilterItem ADMIN_GROUP_FILTER = new FilterItem(10080L, "developer", "", "developer the great and wise (developer)", 0L, (List<WebTestSharePermission>)ImmutableList.of((Object)new WebTestSharePermission("group", "jira-developers", null)), Boolean.FALSE, 0L, Collections.<String>emptyList(), 1L);
    private static final FilterItem WIFE_GROUP_FILTER = new FilterItem(10080L, "developer", "", "developer the great and wise (developer)", 0L, (List<WebTestSharePermission>)ImmutableList.of((Object)new WebTestSharePermission("project", "monkey", "Naggers")), Boolean.FALSE, 0L, Collections.<String>emptyList(), 1L);
    private FilterNavigation[] filterNavigationScreens;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.navigation.login("admin", "admin");
        this.administration.restoreData("sharedfilters/TestBrowseFiltersShareType.xml");
        this.filterNavigationScreens = new FilterNavigation[]{this.navigation.manageFilters(), this.navigation.filterPickerPopup()};
    }

    @Override
    protected void tearDownTest() {
        this.navigation.logout();
    }

    public void testFindUsingAnonymous() {
        ArrayList expectedAdminItems = Lists.newArrayList();
        this.addGroupFilters(expectedAdminItems, "groupusers", 'a', 'e', 10040L, JIRA_USERS_GROUP);
        this.executeGroupSearch(JIRA_USERS_GROUP, null, "admin", this.navigation.manageFilters());
        String query = this.tester.getDialog().getResponse().getURL().getQuery();
        this.checkSearchResults(expectedAdminItems);
        this.navigation.logout();
        this.tester.gotoPage("secure/ManageFilters.jspa?" + query);
        ArrayList expectedAnonymousItems = Lists.newArrayList();
        this.addPublicFilters(expectedAnonymousItems, "", 'a', 'z', 10005L);
        this.checkSearchResults(expectedAnonymousItems);
        this.navigation.login("admin");
        this.tester.gotoPage("secure/ManageFilters.jspa?" + query);
        this.checkSearchResults(expectedAdminItems);
    }

    public void testFindAdminGroupsNoResults() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreens) {
            this.testFindAdminGroupsNoResults(aFilterNavigationScreen);
        }
    }

    public void testFindDeveloperGroups() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreens) {
            this.testFindDeveloperGroups(aFilterNavigationScreen);
        }
    }

    public void testFindDeveloperWithConditions() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreens) {
            this.testFindDeveloperWithConditions(aFilterNavigationScreen);
        }
    }

    public void testFindUsersGroups() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreens) {
            this.testFindUsersGroups(aFilterNavigationScreen);
        }
    }

    public void testFindHomosapienProjectNoResults() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreens) {
            this.testFindHomosapienProjectNoResults(aFilterNavigationScreen);
        }
    }

    public void testFindMonkeyProjectAsAdmin() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreens) {
            this.testFindMonkeyProjectAsAdmin(aFilterNavigationScreen);
        }
    }

    public void testFindMonkeyProjectAsWife() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreens) {
            this.testFindMonkeyProjectAsWife(aFilterNavigationScreen);
        }
    }

    public void testFindMonkeyProjectWithRoleNaggersAsWife() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreens) {
            this.testFindMonkeyProjectWithRoleNaggersAsWife(aFilterNavigationScreen);
        }
    }

    public void testFindMonkeyProjectWithRoleNaggersAsWifeAndConditions() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreens) {
            this.testFindMonkeyProjectWithRoleNaggersAsWifeAndConditions(aFilterNavigationScreen);
        }
    }

    public void testFindAdminGroupsNoResults(FilterNavigation filterNavigation) {
        this.executeGroupSearch(JIRA_ADMINISTRATORS_GROUP, null, null, filterNavigation);
        TestSearchFiltersShareType.assertTrue((boolean)this.parseBrowse().isEmpty());
    }

    public void testFindDeveloperGroups(FilterNavigation filterNavigation) {
        List<Object> expectedItems = Lists.newArrayList();
        expectedItems.add(ADMIN_GROUP_FILTER);
        this.addGroupFilters(expectedItems, "groupdevs", 'a', 'z', 10045L, JIRA_DEVELOPERS_GROUP);
        expectedItems = filterNavigation.sanitiseSearchFilterItems(expectedItems);
        this.executeGroupSearch(JIRA_DEVELOPERS_GROUP, null, null, filterNavigation);
        this.checkSearchResults(expectedItems);
    }

    public void testFindDeveloperWithConditions(FilterNavigation filterNavigation) {
        this.executeGroupSearch(JIRA_DEVELOPERS_GROUP, "developer", "developer", filterNavigation);
        List<Object> expectedItems = Lists.newArrayList((Object[])new FilterItem[]{ADMIN_GROUP_FILTER});
        expectedItems = filterNavigation.sanitiseSearchFilterItems(expectedItems);
        this.checkSearchResults(expectedItems);
    }

    public void testFindUsersGroups(FilterNavigation filterNavigation) {
        List<Object> expectedItems = Lists.newArrayList();
        this.addGroupFilters(expectedItems, "groupusers", 'a', 'e', 10040L, JIRA_USERS_GROUP);
        this.executeGroupSearch(JIRA_USERS_GROUP, null, null, filterNavigation);
        expectedItems = filterNavigation.sanitiseSearchFilterItems(expectedItems);
        this.checkSearchResults(expectedItems);
    }

    public void testFindHomosapienProjectNoResults(FilterNavigation filterNavigation) {
        this.executeProjectSearch(HOMOSAPIEN_PROJECT_ID, null, null, null, filterNavigation);
        TestSearchFiltersShareType.assertTrue((boolean)this.parseBrowse().isEmpty());
    }

    public void testFindMonkeyProjectAsAdmin(FilterNavigation filterNavigation) {
        List<Object> expectedItems = Lists.newArrayList();
        this.addProjectFilters(expectedItems, "projectmonkey", 'a', 'z', 10090L, ADMIN_USER_STRING, MONKEY_PROJECT_NAME, null);
        this.executeProjectSearch(MONKEY_PROJECT_ID, null, null, null, filterNavigation);
        expectedItems = filterNavigation.sanitiseSearchFilterItems(expectedItems);
        this.checkSearchResults(expectedItems);
    }

    public void testFindMonkeyProjectAsWife(FilterNavigation filterNavigation) {
        this.navigation.logout();
        this.navigation.login("wife", "wife");
        List<Object> expectedItems = Lists.newArrayList();
        this.addProjectFilters(expectedItems, "projectmonkey", 'a', 'z', 10090L, ADMIN_USER_STRING, MONKEY_PROJECT_NAME, null);
        this.addProjectFilters(expectedItems, "naggers", 'a', 'j', 10120L, WIFE_USER_STRING, MONKEY_PROJECT_NAME, NAGGERS_ROLE_NAME);
        expectedItems.add(WIFE_GROUP_FILTER);
        expectedItems = filterNavigation.sanitiseSearchFilterItems(expectedItems);
        this.executeProjectSearch(MONKEY_PROJECT_ID, null, null, null, filterNavigation);
        this.checkSearchResults(expectedItems);
    }

    public void testFindMonkeyProjectWithRoleNaggersAsWife(FilterNavigation filterNavigation) {
        this.navigation.logout();
        this.navigation.login("wife", "wife");
        List<Object> expectedItems = Lists.newArrayList();
        this.addProjectFilters(expectedItems, "naggers", 'a', 'j', 10120L, WIFE_USER_STRING, MONKEY_PROJECT_NAME, NAGGERS_ROLE_NAME);
        expectedItems.add(WIFE_GROUP_FILTER);
        expectedItems = filterNavigation.sanitiseSearchFilterItems(expectedItems);
        this.executeProjectSearch(MONKEY_PROJECT_ID, NAGGERS_ROLE_ID, null, null, filterNavigation);
        this.checkSearchResults(expectedItems);
    }

    public void testFindMonkeyProjectWithRoleNaggersAsWifeAndConditions(FilterNavigation filterNavigation) {
        this.navigation.logout();
        this.navigation.login("wife", "wife");
        List<Object> expectedItems = Lists.newArrayList();
        this.addProjectFilters(expectedItems, "naggers", 'a', 'j', 10120L, WIFE_USER_STRING, MONKEY_PROJECT_NAME, NAGGERS_ROLE_NAME);
        expectedItems = filterNavigation.sanitiseSearchFilterItems(expectedItems);
        this.executeProjectSearch(MONKEY_PROJECT_ID, NAGGERS_ROLE_ID, null, "wife", filterNavigation);
        this.checkSearchResults(expectedItems);
    }

    private void checkSearchResults(List<FilterItem> expectedItems) {
        Collections.sort(expectedItems, NameComparator.NAME_COMPARATOR);
        this.checkNext(expectedItems);
        this.checkPrevious(expectedItems);
        this.tester.clickLink("filter_sort_name");
        Collections.sort(expectedItems, Ordering.from((Comparator)NameComparator.NAME_COMPARATOR).reverse());
        this.checkNext(expectedItems);
        this.checkPrevious(expectedItems);
        this.tester.clickLink("filter_sort_owner");
        Collections.sort(expectedItems, this.createAuthorComparator(false));
        this.checkNext(expectedItems);
        this.checkPrevious(expectedItems);
        this.tester.clickLink("filter_sort_owner");
        Collections.sort(expectedItems, this.createAuthorComparator(true));
        this.checkNext(expectedItems);
        this.checkPrevious(expectedItems);
        this.tester.clickLink("filter_sort_popularity");
        Collections.sort(expectedItems, this.createPopularComparator(true));
        this.checkNext(expectedItems);
        this.checkPrevious(expectedItems);
        this.tester.clickLink("filter_sort_popularity");
        Collections.sort(expectedItems, this.createPopularComparator(false));
        this.checkNext(expectedItems);
        this.checkPrevious(expectedItems);
    }

    private Comparator<FilterItem> createAuthorComparator(boolean reverse) {
        AuthorComparator authorComparator = AuthorComparator.AUTHOR_COMPARATOR;
        if (reverse) {
            authorComparator = Ordering.from((Comparator)authorComparator).reverse();
        }
        return Ordering.from((Comparator)authorComparator).compound((Comparator)NameComparator.NAME_COMPARATOR);
    }

    private Comparator<FilterItem> createPopularComparator(boolean reverse) {
        PopularComparator authorComparator = PopularComparator.POPULAR_COMPARATOR;
        if (reverse) {
            authorComparator = Ordering.from((Comparator)authorComparator).reverse();
        }
        return Ordering.from((Comparator)authorComparator).compound((Comparator)NameComparator.NAME_COMPARATOR);
    }

    private void addProjectFilters(List<FilterItem> items, String name, char startChar, char endChar, long initialId, String userName, String project, String roleId) {
        WebTestSharePermission permission = new WebTestSharePermission("project", project, roleId);
        this.addFilters(items, name, startChar, endChar, initialId, userName, Collections.singletonList(permission));
    }

    private void addGroupFilters(List<FilterItem> items, String name, char startChar, char endChar, long initialId, String groupName) {
        WebTestSharePermission permission = new WebTestSharePermission("group", groupName, null);
        this.addFilters(items, name, startChar, endChar, initialId, ADMIN_USER_STRING, Collections.singletonList(permission));
    }

    private void addPublicFilters(List<FilterItem> items, String name, char startChar, char endChar, long initialId) {
        WebTestSharePermission permission = new WebTestSharePermission("global", null, null);
        this.addFilters(items, name, startChar, endChar, initialId, ADMIN_USER_STRING, Collections.singletonList(permission));
    }

    private void addFilters(List<FilterItem> items, String name, char startChar, char endChar, long initialId, String user, List shares) {
        long currentId = initialId;
        for (char currentChar = startChar; currentChar <= endChar; currentChar = (char)(currentChar + '\u0001')) {
            items.add(new FilterItem(currentId, name + currentChar, "", user, 0L, shares, Boolean.FALSE, 0L, Collections.EMPTY_LIST, 0L));
            ++currentId;
        }
    }

    private void executeProjectSearch(Long projectId, Long roleId, String text, String userName, FilterNavigation filterNavigation) {
        filterNavigation.searchFilters();
        this.tester.setWorkingForm("filterSearchForm");
        this.fillInOtherParameters(text, userName);
        this.tester.setFormElement("searchShareType", "project");
        this.tester.setFormElement("projectShare", projectId.toString());
        this.tester.setFormElement("roleShare", roleId == null ? "" : roleId.toString());
        this.tester.submit("Search");
    }

    private void executeGroupSearch(String groupName, String text, String userName, FilterNavigation filterNavigation) {
        filterNavigation.searchFilters();
        this.tester.setWorkingForm("filterSearchForm");
        this.fillInOtherParameters(text, userName);
        this.tester.setFormElement("searchShareType", "group");
        this.tester.setFormElement("groupShare", groupName);
        this.tester.submit("Search");
    }

    private void fillInOtherParameters(String text, String userName) {
        if (StringUtils.isNotBlank((String)text)) {
            this.tester.setFormElement("searchName", text);
        }
        if (StringUtils.isNotBlank((String)userName)) {
            this.tester.setFormElement("searchOwnerUserName", userName);
        }
    }

    private void checkNext(List<FilterItem> items) {
        int iterations = items.size() / 20;
        int remainder = items.size() % 20;
        if (iterations == 0 || 20 == items.size()) {
            this.tester.assertLinkNotPresentWithText(PREVIOUS_LINK_TEXT);
            this.tester.assertLinkNotPresentWithText(NEXT_LINK_TEXT);
            TestSearchFiltersShareType.assertEquals((String)"All filters not on first screen.", items, this.parseBrowse());
        } else {
            for (int i = 1; i <= iterations; ++i) {
                int startPos = (i - 1) * 20;
                int endPos = i * 20;
                List<FilterItem> expectedItems = items.subList(startPos, endPos);
                List<FilterItem> list = this.parseBrowse();
                this.assertions.assertEquals("Page " + i + " did not contain expected items.", expectedItems, list);
                if (i == 1) {
                    this.tester.assertLinkNotPresentWithText(PREVIOUS_LINK_TEXT);
                } else {
                    this.tester.assertLinkPresentWithText(PREVIOUS_LINK_TEXT);
                }
                this.tester.assertTextPresent("" + (startPos + 1) + " - " + endPos);
                if (remainder == 0 && i == iterations) {
                    this.tester.assertLinkNotPresent(NEXT_LINK_TEXT);
                    continue;
                }
                this.tester.assertLinkPresentWithText(NEXT_LINK_TEXT);
                this.tester.clickLinkWithText(NEXT_LINK_TEXT);
            }
            if (remainder != 0) {
                this.tester.assertLinkPresentWithText(PREVIOUS_LINK_TEXT);
                this.tester.assertLinkNotPresentWithText(NEXT_LINK_TEXT);
                int startPos = iterations * 20;
                this.tester.assertTextPresent("" + (startPos + 1) + " - " + items.size());
                List<FilterItem> expectedItems = items.subList(startPos, items.size());
                TestSearchFiltersShareType.assertEquals((String)"Last page did not contain expected items.", expectedItems, this.parseBrowse());
            }
        }
    }

    private void checkPrevious(List items) {
        int iterations = items.size() / 20;
        int remainder = items.size() % 20;
        if (iterations == 0 || items.size() == 20) {
            this.tester.assertLinkNotPresentWithText(PREVIOUS_LINK_TEXT);
            this.tester.assertLinkNotPresentWithText(NEXT_LINK_TEXT);
            TestSearchFiltersShareType.assertEquals((String)"All filters not on first screen.", (Object)items, this.parseBrowse());
        } else {
            if (remainder != 0) {
                this.tester.assertLinkNotPresentWithText(NEXT_LINK_TEXT);
                int startPos = iterations * 20;
                this.tester.assertTextPresent("" + (startPos + 1) + " - " + items.size());
                List expectedItems = items.subList(startPos, items.size());
                TestSearchFiltersShareType.assertEquals((String)"Last page did not contain expected items.", expectedItems, this.parseBrowse());
                this.tester.clickLinkWithText(PREVIOUS_LINK_TEXT);
            }
            for (int i = iterations; i > 0; --i) {
                int startPos = (i - 1) * 20;
                int endPos = i * 20;
                List expectedItems = items.subList(startPos, endPos);
                TestSearchFiltersShareType.assertEquals((String)("Page " + i + " did not contain expected items."), expectedItems, this.parseBrowse());
                this.tester.assertTextPresent("" + (startPos + 1) + " - " + endPos);
                if (i == 1) {
                    this.tester.assertLinkNotPresentWithText(PREVIOUS_LINK_TEXT);
                } else {
                    this.tester.clickLinkWithText(PREVIOUS_LINK_TEXT);
                }
                if (remainder == 0 && i == iterations) {
                    this.tester.assertLinkNotPresent(NEXT_LINK_TEXT);
                    continue;
                }
                this.tester.assertLinkPresentWithText(NEXT_LINK_TEXT);
            }
        }
    }

    private List<FilterItem> parseBrowse() {
        FilterList list = this.parse.filter().parseFilterList("mf_browse");
        if (list == null) {
            return Collections.emptyList();
        }
        List<FilterItem> items = list.getFilterItems();
        if (items == null) {
            return Collections.emptyList();
        }
        return items;
    }

    private static class NameComparator
    implements Comparator<FilterItem> {
        public static final NameComparator NAME_COMPARATOR = new NameComparator();

        private NameComparator() {
        }

        @Override
        public int compare(FilterItem item1, FilterItem item2) {
            return item1.getName().compareTo(item2.getName());
        }
    }

    private static class PopularComparator
    implements Comparator<FilterItem> {
        public static final PopularComparator POPULAR_COMPARATOR = new PopularComparator();

        private PopularComparator() {
        }

        @Override
        public int compare(FilterItem item1, FilterItem item2) {
            return item1.getFavCount().compareTo(item2.getFavCount());
        }
    }

    private static class AuthorComparator
    implements Comparator<FilterItem> {
        public static final AuthorComparator AUTHOR_COMPARATOR = new AuthorComparator();
        private static final Pattern NAME_REGEX = Pattern.compile("\\((.*)\\)");

        private AuthorComparator() {
        }

        private static String getName(String authorName) {
            Matcher matcher = NAME_REGEX.matcher(authorName);
            if (matcher.find()) {
                return matcher.group(1);
            }
            return authorName;
        }

        @Override
        public int compare(FilterItem item1, FilterItem item2) {
            String author1 = AuthorComparator.getName(item1.getAuthor());
            String author2 = AuthorComparator.getName(item2.getAuthor());
            return author1.compareTo(author2);
        }
    }
}

