/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigator.IssueTypeCondition;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearch;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearchBuilder;
import com.atlassian.jira.functest.framework.navigator.QuerySearchCondition;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.parser.filter.FilterList;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
public class TestSaveAsFilterSimple
extends FuncTestCase {
    private static final NavigatorSearch NAV_SEARCH1;
    private static final NavigatorSearch NAV_SEARCH2;
    private static final long FEATURE_FILTER_ID = 10001L;
    private static final String ALL_FILTER_NAME = "AllFilter";
    private static final String FEATURE_FILTER_NAME = "FeatureFilter";
    private static final NavigatorSearch FEATURE_FILTER;
    private static final SharedEntityInfo FEATURE_FILTER_INFO;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestSaveAsFilterSimple.xml");
    }

    public void testSaveFavouriteByDefault() {
        this.navigation.login("admin");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("Save");
        this.tester.assertFormElementEquals("favourite", "true");
    }

    public void testSaveAsFavouriteByDefault() {
        this.navigation.login("admin");
        this.navigation.issueNavigator().loadFilter(10001L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.navigation.issueNavigator().modifySearch(NAV_SEARCH2);
        this.tester.clickLinkWithText("Save as");
        this.tester.assertFormElementEquals("favourite", "true");
    }

    public void testSaveNoSearchInSession() {
        this.navigation.login("admin");
        this.tester.gotoPage("secure/SaveAsFilter!default.jspa");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "There is no current search request.");
        this.tester.gotoPage("secure/SaveAsFilter.jspa");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "There is no current search request.");
    }

    public void testAnonymousCantSave() {
        this.navigation.logout();
        this.navigation.gotoDashboard();
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertLinkNotPresentWithText("Save");
        this.tester.gotoPage("secure/SaveAsFilter!default.jspa");
        this.tester.assertSubmitButtonNotPresent("Save");
        this.tester.gotoPage("secure/SaveAsFilter.jspa");
        this.tester.assertSubmitButtonNotPresent("Save");
    }

    public void testSaveInvalidName() {
        SharedEntityInfo info = new SharedEntityInfo(null, null, false, null);
        this.navigation.login("admin");
        this.navigation.issueNavigator().displayAllIssues();
        this.saveFilterNoId(info);
        this.assertCurrentScreenCorrect(info);
        this.text.assertTextPresent(new WebPageLocator(this.tester), "You must specify a name to save this filter as.");
    }

    public void testSaveAsInvalidName() {
        SharedEntityInfo info = new SharedEntityInfo(null, "This is a cool description", true, null);
        this.navigation.login("admin");
        this.navigation.issueNavigator().loadFilter(10001L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.navigation.issueNavigator().modifySearch(NAV_SEARCH2);
        this.saveAsFilterNoId(info);
        this.assertCurrentScreenCorrect(info);
        this.text.assertTextPresent(new WebPageLocator(this.tester), "You must specify a name to save this filter as.");
        this.navigation.issueNavigator().loadFilter(10001L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.assertSearchSavedCorrectly(FEATURE_FILTER_INFO, FEATURE_FILTER);
    }

    public void testSaveWithAFilterNameThatsTooLong() {
        this.navigation.login("admin");
        this.navigation.issueNavigator().loadFilter(10001L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.navigation.issueNavigator().modifySearch(NAV_SEARCH2);
        char[] nameChars = new char[500];
        Arrays.fill(nameChars, 'x');
        String name = new String(nameChars);
        String description = "Description";
        boolean favourite = false;
        String linkText = "Save";
        this.saveFilter(name, "Description", false, "Save");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "The entered filter name is too long, it must be less than 255 chars.");
    }

    public void testSaveAlreadySaved() {
        SharedEntityInfo info = new SharedEntityInfo(ALL_FILTER_NAME, "This is a cool description", true, null);
        this.navigation.login("admin");
        this.navigation.issueNavigator().displayAllIssues();
        this.saveFilterNoId(info);
        this.assertCurrentScreenCorrect(info);
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Filter with same name already exists.");
    }

    public void testSaveAsAlreadySaved() {
        this.navigation.login("admin");
        SharedEntityInfo info = new SharedEntityInfo(FEATURE_FILTER_NAME, null, true, null);
        this.navigation.issueNavigator().loadFilter(10001L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.navigation.issueNavigator().modifySearch(NAV_SEARCH2);
        this.saveAsFilterNoId(info);
        this.assertCurrentScreenCorrect(info);
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Filter with same name already exists.");
        this.navigation.issueNavigator().loadFilter(10001L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.assertSearchSavedCorrectly(FEATURE_FILTER_INFO, FEATURE_FILTER);
    }

    public void testInvalidFavourite() {
        this.navigation.login("admin");
        SharedEntityInfo info = new SharedEntityInfo("testInvalidFavourite", null, false, null);
        this.navigation.issueNavigator().createSearch(NAV_SEARCH1);
        this.tester.gotoPage("secure/SaveAsFilter.jspa?filterName=testInvalidFavourite&favourite=badjskajds&submit=Save");
        this.assertSearchSavedCorrectly(info, NAV_SEARCH1);
    }

    public void testInvalidFilterId() {
        this.navigation.login("admin");
        SharedEntityInfo info = new SharedEntityInfo("testInvalidFilterId", null, true, null);
        this.navigation.issueNavigator().createSearch(NAV_SEARCH1);
        this.tester.gotoPage("secure/SaveAsFilter.jspa?filterName=testInvalidFilterId&submit=Save&filterId10001");
        long id = this.getFilterIdAfterSave();
        TestSaveAsFilterSimple.assertFalse((String)"Should only create new filters.", (10001L == id ? 1 : 0) != 0);
        this.assertSearchSavedCorrectly(info, NAV_SEARCH1);
        this.navigation.issueNavigator().loadFilter(10001L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.assertSearchSavedCorrectly(FEATURE_FILTER_INFO, FEATURE_FILTER);
    }

    public void testSaveAnonymousSearch() {
        this.navigation.logout();
        this.navigation.gotoDashboard();
        SharedEntityInfo info = new SharedEntityInfo("testSaveAnonymousSearch", null, false, null);
        this.navigation.issueNavigator().createSearch(NAV_SEARCH2);
        this.navigation.login("admin");
        this.navigation.issueNavigator().gotoNavigator();
        this.saveFilter(info);
        this.assertSearchSavedCorrectly(info, NAV_SEARCH2);
    }

    public void testXSSSaveFilter() {
        this.navigation.login("admin");
        SharedEntityInfo navigatorSearchInfo = new SharedEntityInfo("<b>testXSSSaveFilter</b>", "<b>description is rea=lly cool</b>", true, null);
        this.createAndCheckFilter(navigatorSearchInfo, NAV_SEARCH1);
    }

    public void testXSSSaveAsFilter() {
        this.navigation.login("admin");
        SharedEntityInfo navigatorSearchInfo = new SharedEntityInfo("<b>testXSSSaveAsFilter</b>", "<b>description is rea=lly cool</b>", true, null);
        this.modifyAndCheckFilter(navigatorSearchInfo, NAV_SEARCH1);
    }

    public void testSaveFilter() {
        this.navigation.login("admin");
        SharedEntityInfo searchInfo = new SharedEntityInfo("testSaveFilter", null, true, null);
        this.createAndCheckFilter(searchInfo, NAV_SEARCH1);
    }

    public void testSaveAsFilter() {
        this.navigation.login("admin");
        SharedEntityInfo searchInfo = new SharedEntityInfo("testSaveAsFilter", null, true, null);
        this.modifyAndCheckFilter(searchInfo, NAV_SEARCH2);
    }

    public void testSaveFilterWithDescription() {
        this.navigation.login("admin");
        SharedEntityInfo info = new SharedEntityInfo("testSaveFilterWithDescription", "Yet another description 4 testing.", true, null);
        this.createAndCheckFilter(info, NAV_SEARCH2);
    }

    public void testSaveAsFilterWithDescription() {
        this.navigation.login("admin");
        SharedEntityInfo info = new SharedEntityInfo("testSaveAsFilterWithDescription", "Description 4 test", true, null);
        this.modifyAndCheckFilter(info, NAV_SEARCH1);
    }

    public void testSaveFilterWithNotFavourite() {
        this.navigation.login("admin");
        SharedEntityInfo searchInfo = new SharedEntityInfo("testSaveFilterWithNot F= avourite", null, false, null);
        this.createAndCheckFilter(searchInfo, NAV_SEARCH1);
    }

    public void testSaveAsFilterWithNotFavourite() {
        this.navigation.login("admin");
        SharedEntityInfo searchInfo = new SharedEntityInfo("testSaveAsFilterWithNotFavourite", "Yey this is a saved filter", false, null);
        this.modifyAndCheckFilter(searchInfo, NAV_SEARCH2);
    }

    private long modifyAndCheckFilter(SharedEntityInfo info, NavigatorSearch search) {
        this.navigation.issueNavigator().loadFilter(10001L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.navigation.issueNavigator().modifySearch(search);
        long id = this.saveAsFilter(info);
        this.assertSearchSavedCorrectly(info, search);
        this.navigation.issueNavigator().loadFilter(10001L, null);
        this.assertSearchSavedCorrectly(FEATURE_FILTER_INFO, FEATURE_FILTER);
        return id;
    }

    private long createAndCheckFilter(SharedEntityInfo info, NavigatorSearch search) {
        this.navigation.issueNavigator().createSearch(search);
        long id = this.saveFilter(info);
        this.assertSearchSavedCorrectly(info, search);
        return id;
    }

    private void saveFilterNoId(SharedEntityInfo info) {
        this.saveFilter(info.getName(), info.getDescription(), info.isFavourite(), "Save");
    }

    private void saveAsFilterNoId(SharedEntityInfo info) {
        this.saveFilter(info.getName(), info.getDescription(), info.isFavourite(), "Save As");
    }

    private long saveFilter(SharedEntityInfo info) {
        this.saveFilterNoId(info);
        return this.getFilterIdAfterSave();
    }

    private long saveAsFilter(SharedEntityInfo search) {
        this.saveAsFilterNoId(search);
        return this.getFilterIdAfterSave();
    }

    private void saveFilter(String name, String description, boolean favourite, String linkText) {
        if (favourite) {
            this.tester.clickLinkWithText(linkText);
            this.tester.setFormElement("filterName", name);
            this.tester.setFormElement("filterDescription", description);
            this.tester.submit("saveasfilter_submit");
        } else {
            this.saveUsingPut(name, description, favourite);
        }
    }

    private void saveUsingPut(String name, String description, boolean favourite) {
        this.tester.gotoPage(this.createSaveUrl(name, description, favourite));
    }

    private String createSaveUrl(String name, String description, boolean favourite) {
        StringBuilder buffer = new StringBuilder("secure/SaveAsFilter.jspa?submit=Save");
        if (!StringUtils.isBlank((String)name)) {
            buffer.append("&filterName=").append(this.encode(name));
        }
        if (!StringUtils.isBlank((String)description)) {
            buffer.append("&filterDescription=").append(this.encode(description));
        }
        buffer.append("&favourite=").append(String.valueOf(favourite));
        return buffer.toString();
    }

    private String encode(String name) {
        try {
            return URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private long getFilterIdAfterSave() {
        URL url = this.tester.getDialog().getResponse().getURL();
        if (url.getQuery() == null) {
            TestSaveAsFilterSimple.fail((String)"Unable to save filter: Not redirected to navigator.");
        } else {
            Pattern pattern = Pattern.compile("requestId=(\\d+)");
            Matcher matcher = pattern.matcher(url.getQuery());
            if (matcher.find()) {
                return Long.parseLong(matcher.group(1));
            }
            TestSaveAsFilterSimple.fail((String)"Unable to save filter: Not redirected to navigator.");
        }
        return Long.MIN_VALUE;
    }

    private void assertSearchSavedCorrectly(SharedEntityInfo info, NavigatorSearch expectedSearch) {
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.assertions.getIssueNavigatorAssertions().assertSimpleSearch(expectedSearch, this.tester);
        this.assertions.getIssueNavigatorAssertions().assertSearchInfo(info);
        this.assertFilterOnManage(info);
    }

    private void assertCurrentScreenCorrect(SharedEntityInfo info) {
        this.tester.assertFormElementEquals("filterName", info.getName());
        this.tester.assertFormElementEquals("filterDescription", info.getDescription());
        this.tester.assertFormElementEquals("favourite", String.valueOf(info.isFavourite()));
    }

    private void assertFilterOnManage(SharedEntityInfo info) {
        this.navigation.manageFilters().myFilters();
        FilterList list = this.parse.filter().parseFilterList("mf_owned");
        for (FilterItem item : list.getFilterItems()) {
            if (!info.getName().equals(item.getName())) continue;
            if (info.getDescription() == null) {
                TestSaveAsFilterSimple.assertNull((Object)item.getDescription());
            } else {
                TestSaveAsFilterSimple.assertEquals((String)info.getDescription(), (String)item.getDescription());
            }
            TestSaveAsFilterSimple.assertEquals((boolean)info.isFavourite(), (boolean)item.isFav());
            return;
        }
        TestSaveAsFilterSimple.fail((String)"Filter not displayed on manage filters.");
    }

    static {
        FEATURE_FILTER_INFO = new SharedEntityInfo(FEATURE_FILTER_NAME, null, false, null);
        NavigatorSearchBuilder builder = new NavigatorSearchBuilder();
        builder.addIssueType(IssueTypeCondition.IssueType.BUG);
        builder.addQueryString("test").addQueryField(QuerySearchCondition.QueryField.SUMMARY);
        NAV_SEARCH1 = builder.createSearch();
        builder = new NavigatorSearchBuilder();
        builder.addQueryString("super bad").addQueryField(QuerySearchCondition.QueryField.ENVIRONMENT);
        NAV_SEARCH2 = builder.createSearch();
        builder = new NavigatorSearchBuilder();
        builder.addIssueType(IssueTypeCondition.IssueType.NEW_FEATURE);
        FEATURE_FILTER = builder.createSearch();
    }
}

