/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.BROWSE_PROJECT, Category.FILTERS})
public class TestPresetFiltersWebFragment
extends JIRAWebTest {
    public TestPresetFiltersWebFragment(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.administration.restoreData("TestWebFragment.xml");
    }

    @Override
    public void tearDown() {
        this.navigation.login("admin");
        this.administration.restoreBlankInstance();
        super.tearDown();
    }

    public void testPresetFiltersWebFragment() {
        this.navigation.logout();
        this.assertStandardFiltersNotVisible();
        this.assertUserFiltersNotVisible();
        this.navigation.login("admin");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(10, "");
        this.navigation.browseProject("HSP");
        this.assertStandardFiltersVisible("HSP");
        this.assertUserFiltersVisible("HSP");
        this.navigation.logout();
        this.navigation.browseProject("HSP");
        this.assertStandardFiltersVisible("HSP");
        this.assertUserFiltersNotVisible();
    }

    public void testVersionLinksPresent() {
        this.administration.restoreData("TestVersionAndComponentOpenIssueSummary.xml");
        this.navigation.browseProject("HSP");
        this.assertStandardFiltersVisible("HSP");
        this.assertUserFiltersVisible("HSP");
        this.tester.gotoPage("/browse/HSP/fixforversion/10001");
        String baseJql = "&jqlQuery=fixVersion+%3D+%22New+Version+4%22+AND+project+%3D+HSP";
        this.assertLinkPresentWithURL("filter_all", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=fixVersion+%3D+%22New+Version+4%22+AND+project+%3D+HSP");
        this.assertLinkPresentWithURL("filter_outstanding", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=fixVersion+%3D+%22New+Version+4%22+AND+project+%3D+HSP+AND+resolution+%3D+Unresolved+ORDER+BY+updated+DESC");
        this.tester.assertLinkNotPresent("filter_unscheduled");
        this.assertLinkPresentWithURL("filter_mostimportant", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=fixVersion+%3D+%22New+Version+4%22+AND+project+%3D+HSP+AND+resolution+%3D+Unresolved+ORDER+BY+priority+DESC");
        this.assertLinkPresentWithURL("filter_resolvedrecently", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=fixVersion+%3D+%22New+Version+4%22+AND+project+%3D+HSP+AND+resolutiondate+%3E%3D-1w+ORDER+BY+updated+DESC");
        this.assertLinkPresentWithURL("filter_addedrecently", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=fixVersion+%3D+%22New+Version+4%22+AND+project+%3D+HSP+AND+created%3E%3D-1w+ORDER+BY+created+DESC");
        this.assertLinkPresentWithURL("filter_updatedrecently", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=fixVersion+%3D+%22New+Version+4%22+AND+project+%3D+HSP+AND+updated%3E%3D-1w+ORDER+BY+updated+DESC");
        this.assertLinkPresentWithURL("filter_assignedtome", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=fixVersion+%3D+%22New+Version+4%22+AND+project+%3D+HSP+AND+assignee+%3D+currentUser%28%29+AND+resolution+%3D+Unresolved");
        this.assertLinkPresentWithURL("filter_reportedbyme", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=fixVersion+%3D+%22New+Version+4%22+AND+project+%3D+HSP+AND+reporter+%3D+currentUser%28%29");
    }

    public void testComponentLinksPresent() {
        this.administration.restoreData("TestVersionAndComponentOpenIssueSummary.xml");
        this.navigation.browseProject("HSP");
        this.assertStandardFiltersVisible("HSP");
        this.assertUserFiltersVisible("HSP");
        this.tester.gotoPage("/browse/HSP/component/10000");
        String baseJql = "&jqlQuery=component+%3D+%22New+Component+1%22+AND+project+%3D+HSP";
        this.assertLinkPresentWithURL("filter_all", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=component+%3D+%22New+Component+1%22+AND+project+%3D+HSP");
        this.assertLinkPresentWithURL("filter_outstanding", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=component+%3D+%22New+Component+1%22+AND+project+%3D+HSP+AND+resolution+%3D+Unresolved+ORDER+BY+updated+DESC");
        this.assertLinkPresentWithURL("filter_unscheduled", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=component+%3D+%22New+Component+1%22+AND+project+%3D+HSP+AND+resolution+%3D+Unresolved+AND+fixVersion+is+EMPTY+ORDER+BY+priority+DESC");
        this.assertLinkPresentWithURL("filter_mostimportant", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=component+%3D+%22New+Component+1%22+AND+project+%3D+HSP+AND+resolution+%3D+Unresolved+ORDER+BY+priority+DESC");
        this.assertLinkPresentWithURL("filter_resolvedrecently", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=component+%3D+%22New+Component+1%22+AND+project+%3D+HSP+AND+resolutiondate+%3E%3D-1w+ORDER+BY+updated+DESC");
        this.assertLinkPresentWithURL("filter_addedrecently", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=component+%3D+%22New+Component+1%22+AND+project+%3D+HSP+AND+created%3E%3D-1w+ORDER+BY+created+DESC");
        this.assertLinkPresentWithURL("filter_updatedrecently", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=component+%3D+%22New+Component+1%22+AND+project+%3D+HSP+AND+updated%3E%3D-1w+ORDER+BY+updated+DESC");
        this.assertLinkPresentWithURL("filter_assignedtome", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=component+%3D+%22New+Component+1%22+AND+project+%3D+HSP+AND+assignee+%3D+currentUser%28%29+AND+resolution+%3D+Unresolved");
        this.assertLinkPresentWithURL("filter_reportedbyme", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=component+%3D+%22New+Component+1%22+AND+project+%3D+HSP+AND+reporter+%3D+currentUser%28%29");
    }

    private void assertUserFiltersNotVisible() {
        this.tester.assertLinkNotPresent("filter_assignedtome");
        this.tester.assertLinkNotPresent("filter_reportedbyme");
    }

    private void assertUserFiltersVisible(String projectKey) {
        this.assertLinkPresentWithURL("filter_assignedtome", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=project+%3D+" + projectKey + "+AND+assignee+%3D+currentUser%28%29+AND+resolution+%3D+Unresolved");
        this.assertLinkPresentWithURL("filter_reportedbyme", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=project+%3D+" + projectKey + "+AND+reporter+%3D+currentUser%28%29");
    }

    private void assertStandardFiltersVisible(String projectKey) {
        this.assertLinkPresentWithURL("filter_all", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=project+%3D+" + projectKey);
        this.assertLinkPresentWithURL("filter_outstanding", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=project+%3D+" + projectKey + "+AND+resolution+%3D+Unresolved+ORDER+BY+updated+DESC");
        this.assertLinkPresentWithURL("filter_unscheduled", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=project+%3D+" + projectKey + "+AND+resolution+%3D+Unresolved+AND+fixVersion+is+EMPTY+ORDER+BY+priority+DESC");
        this.assertLinkPresentWithURL("filter_mostimportant", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=project+%3D+" + projectKey + "+AND+resolution+%3D+Unresolved+ORDER+BY+priority+DESC");
        this.assertLinkPresentWithURL("filter_resolvedrecently", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=project+%3D+" + projectKey + "+AND+resolutiondate+%3E%3D-1w+ORDER+BY+updated+DESC");
        this.assertLinkPresentWithURL("filter_addedrecently", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=project+%3D+" + projectKey + "+AND+created%3E%3D-1w+ORDER+BY+created+DESC");
        this.assertLinkPresentWithURL("filter_updatedrecently", "/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=project+%3D+" + projectKey + "+AND+updated%3E%3D-1w+ORDER+BY+updated+DESC");
    }

    private void assertStandardFiltersNotVisible() {
        this.tester.assertLinkNotPresent("filter_all");
        this.tester.assertLinkNotPresent("filter_outstanding");
        this.tester.assertLinkNotPresent("filter_unscheduled");
        this.tester.assertLinkNotPresent("filter_mostimportant");
        this.tester.assertLinkNotPresent("filter_resolvedrecently");
        this.tester.assertLinkNotPresent("filter_addedrecently");
        this.tester.assertLinkNotPresent("filter_updatedrecently");
    }
}

