/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.navigation.FilterNavigation;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.parser.filter.FilterList;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
public class TestPopularFilters
extends FuncTestCase {
    private static final String POPULAR_TABLE_ID = "mf_popular";

    @Override
    protected void setUpTest() {
        this.administration.restoreData("BaseProfessionalFilters.xml");
    }

    public void testPopularityViewPopup() throws Exception {
        this._testPopularityView(this.navigation.filterPickerPopup(), false);
    }

    public void testPopularityViewManageFilters() throws Exception {
        this._testPopularityView(this.navigation.manageFilters(), true);
    }

    private void _testPopularityView(FilterNavigation filterNavigation, boolean testAnonymous) throws Exception {
        LinkedHashMap expectedPopularityMap = new LinkedHashMap();
        this.setPopularityMapToOne(expectedPopularityMap);
        filterNavigation.popularFilters();
        this.assertPopularityAndListOrder(expectedPopularityMap);
        this.navigation.logout();
        this.navigation.login("developer", "developer");
        filterNavigation.popularFilters();
        this.assertPopularityAndListOrder(expectedPopularityMap);
        this.addFavourite(expectedPopularityMap, 'a', 2L);
        this.addFavourite(expectedPopularityMap, 'b', 2L);
        filterNavigation.popularFilters();
        this.assertPopularityAndListOrder(expectedPopularityMap);
        this.navigation.logout();
        this.navigation.login("fred");
        filterNavigation.popularFilters();
        this.assertPopularityAndListOrder(expectedPopularityMap);
        this.addFavourite(expectedPopularityMap, 'a', 3L);
        this.addFavourite(expectedPopularityMap, 'b', 3L);
        this.addFavourite(expectedPopularityMap, 'c', 2L);
        this.addFavourite(expectedPopularityMap, 'd', 2L);
        filterNavigation.popularFilters();
        this.assertPopularityAndListOrder(expectedPopularityMap);
        this.removeFavourite(expectedPopularityMap, 'd', 1L);
        this.removeFavourite(expectedPopularityMap, 'c', 1L);
        this.removeFavourite(expectedPopularityMap, 'b', 2L);
        filterNavigation.popularFilters();
        this.assertPopularityAndListOrder(expectedPopularityMap);
        this.navigation.logout();
        this.navigation.login("wife");
        expectedPopularityMap = new LinkedHashMap();
        this.addExpectedPopularityToMap(expectedPopularityMap, 'a', 3L);
        this.addExpectedPopularityToMap(expectedPopularityMap, 'b', 2L);
        this.addFavourite(expectedPopularityMap, 't', 2L);
        this.setPopularityMapToOne(expectedPopularityMap);
        filterNavigation.popularFilters();
        this.assertPopularityAndListOrder(expectedPopularityMap);
        expectedPopularityMap = new LinkedHashMap();
        this.addExpectedPopularityToMap(expectedPopularityMap, 'a', 3L);
        this.addExpectedPopularityToMap(expectedPopularityMap, 'b', 2L);
        this.setPopularityMapToOne(expectedPopularityMap);
        this.removeFavourite(expectedPopularityMap, 't', 1L);
        filterNavigation.popularFilters();
        this.assertPopularityAndListOrder(expectedPopularityMap);
        if (testAnonymous) {
            this.navigation.logout();
            filterNavigation.popularFilters();
            this.assertPopularityAndListOrder(expectedPopularityMap);
        }
    }

    private void assertPopularityAndListOrder(LinkedHashMap expectedPopularityMap) {
        FilterList actualList = this.parse.filter().parseFilterList(POPULAR_TABLE_ID);
        List<FilterItem> filterItems = actualList.getFilterItems();
        for (FilterItem filterItem : filterItems) {
            String name = filterItem.getName();
            Long actualPopularity = filterItem.getFavCount();
            Long expectedPopularity = (Long)expectedPopularityMap.get(name);
            TestPopularFilters.assertEquals((String)("Asserting has the right popularity for : " + name), (Object)expectedPopularity, (Object)actualPopularity);
        }
        int i = 0;
        Iterator iterator = expectedPopularityMap.keySet().iterator();
        while (iterator.hasNext()) {
            FilterItem filterItem = actualList.getFilterItems().get(i);
            String expectedName = (String)iterator.next();
            TestPopularFilters.assertEquals((String)("Asserting order of filter items order : " + i), (String)expectedName, (String)filterItem.getName());
            ++i;
        }
    }

    private void addFavourite(LinkedHashMap expectedPopularityMap, char filterName, long expectedPopularity) {
        this.addFavourite(filterName);
        expectedPopularityMap.put(Character.toString(filterName), expectedPopularity);
    }

    private void removeFavourite(LinkedHashMap expectedPopularityMap, char filterName, long expectedPopularity) {
        this.removeFavourite(filterName);
        expectedPopularityMap.put(Character.toString(filterName), expectedPopularity);
    }

    private void setPopularityMapToOne(LinkedHashMap expectedPopularityMap) {
        for (int i = 97; i <= 116; ++i) {
            String key = Character.toString((char)i);
            if (expectedPopularityMap.containsKey(key)) continue;
            this.addExpectedPopularityToMap(expectedPopularityMap, (char)i, 1L);
        }
    }

    private void addExpectedPopularityToMap(LinkedHashMap expectedPopularityMap, char filterName, long expectedPopularity) {
        expectedPopularityMap.put(Character.toString(filterName), expectedPopularity);
    }

    private void addFavourite(char filterName) {
        int id = this.getEntityId(filterName);
        this.navigation.manageFilters().addFavourite(id);
    }

    private void removeFavourite(char filterName) {
        int id = this.getEntityId(filterName);
        this.navigation.manageFilters().removeFavourite(id);
    }

    private int getEntityId(char filterName) {
        return 10005 + Math.abs(97 - filterName);
    }
}

