/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
public class TestFilterSubscription
extends JIRAWebTest {
    public TestFilterSubscription(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.administration.restoreBlankInstance();
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("Save");
        this.tester.setFormElement("filterName", "Test Filter");
        this.tester.submit("saveasfilter_submit");
        this.tester.clickLinkWithText("Subscriptions");
    }

    public void testDefaultDailyTrigger() {
        this.tester.clickLinkWithText("Add subscription");
        this.tester.submit("Subscribe");
        this.assertTextPresent("0 0 1 ? * *");
        this.assertTextPresent("Daily at 1:00 am");
    }

    public void testNonDefaultDailyTriggerEvery2Hours() {
        this.tester.clickLinkWithText("Add subscription");
        this.tester.selectOption("filter.subscription.prefix.interval", "every 2 hours");
        this.tester.selectOption("filter.subscription.prefix.runToHours", "5");
        this.tester.selectOption("filter.subscription.prefix.runToMeridian", "pm");
        this.tester.submit("Subscribe");
        this.assertTextPresent("0 0 1-16/2 ? * *");
        this.assertTextPresent("Daily every 2 hours from 1:00 am to 5:00 pm");
        this.tester.clickLink("edit_subscription");
        this.tester.setWorkingForm("jiraform");
        this.assertOptionSelectedById("filter.subscription.prefix.dailyWeeklyMonthly", "daily");
        this.assertOptionSelected("filter.subscription.prefix.interval", "every 2 hours");
        this.assertOptionSelected("filter.subscription.prefix.runFromHours", "1");
        this.assertOptionSelected("filter.subscription.prefix.runFromMeridian", "am");
        this.assertOptionSelected("filter.subscription.prefix.runToHours", "5");
        this.assertOptionSelected("filter.subscription.prefix.runToMeridian", "pm");
    }

    public void testNonDefaultDailyTriggerEvery2HoursAllDay() {
        this.tester.clickLinkWithText("Add subscription");
        this.tester.selectOption("filter.subscription.prefix.interval", "every 2 hours");
        this.tester.selectOption("filter.subscription.prefix.runFromHours", "5");
        this.tester.selectOption("filter.subscription.prefix.runFromMeridian", "pm");
        this.tester.selectOption("filter.subscription.prefix.runToHours", "5");
        this.tester.selectOption("filter.subscription.prefix.runToMeridian", "pm");
        this.tester.submit("Subscribe");
        this.assertTextPresent("0 0 */2 ? * *");
        this.assertTextPresent("Daily every 2 hours");
        this.assertTextNotPresent("from 5:00 pm to 5:00 pm");
        this.tester.clickLink("edit_subscription");
        this.tester.setWorkingForm("jiraform");
        this.assertOptionSelectedById("filter.subscription.prefix.dailyWeeklyMonthly", "daily");
        this.assertOptionSelected("filter.subscription.prefix.interval", "every 2 hours");
        this.assertOptionSelected("filter.subscription.prefix.runFromHours", "12");
        this.assertOptionSelected("filter.subscription.prefix.runFromMeridian", "am");
        this.assertOptionSelected("filter.subscription.prefix.runToHours", "12");
        this.assertOptionSelected("filter.subscription.prefix.runToMeridian", "am");
    }

    public void testAdvancedExpressionWithBothMinuteAndHourIncrements() {
        String cronExpr = "0 0/15 */3 ? * *";
        this.tester.clickLinkWithText("Add subscription");
        this.tester.checkCheckbox("filter.subscription.prefix.dailyWeeklyMonthly", "advanced");
        this.tester.setFormElement("filter.subscription.prefix.cronString", "0 0/15 */3 ? * *");
        this.tester.submit("Subscribe");
        this.assertTextPresent("0 0/15 */3 ? * *");
        this.clickLink("edit_subscription");
        this.setWorkingForm("jiraform");
        this.assertOptionSelectedById("filter.subscription.prefix.dailyWeeklyMonthly", "advanced");
        this.assertFormElementHasValue("filter.subscription.prefix.cronString", "0 0/15 */3 ? * *");
    }

    public void testAdvancedExpressionWithMinuteIncrementButSingleHour() {
        String cronExpr = "0 0/15 7 ? * *";
        this.tester.clickLinkWithText("Add subscription");
        this.tester.checkCheckbox("filter.subscription.prefix.dailyWeeklyMonthly", "advanced");
        this.tester.setFormElement("filter.subscription.prefix.cronString", "0 0/15 7 ? * *");
        this.tester.submit("Subscribe");
        this.tester.assertTextPresent("0 0/15 7 ? * *");
        this.tester.clickLink("edit_subscription");
        this.tester.setWorkingForm("jiraform");
        this.assertOptionSelectedById("filter.subscription.prefix.dailyWeeklyMonthly", "advanced");
        this.assertFormElementHasValue("filter.subscription.prefix.cronString", "0 0/15 7 ? * *");
    }

    public void testAdvancedExpressionWithMinuteIncrementAndSingleHourRange() {
        String cronExpr = "0 0/15 7-7 ? * *";
        this.tester.clickLinkWithText("Add subscription");
        this.tester.checkCheckbox("filter.subscription.prefix.dailyWeeklyMonthly", "advanced");
        this.tester.setFormElement("filter.subscription.prefix.cronString", "0 0/15 7-7 ? * *");
        this.tester.submit("Subscribe");
        this.assertTextPresent("0 0/15 7-7 ? * *");
        this.assertTextPresent("Daily every 15 minutes from 7:00 am to 8:00 am");
        this.tester.clickLink("edit_subscription");
        this.tester.setWorkingForm("jiraform");
        this.assertOptionSelectedById("filter.subscription.prefix.dailyWeeklyMonthly", "daily");
        this.assertOptionSelected("filter.subscription.prefix.interval", "every 15 minutes");
        this.assertOptionSelected("filter.subscription.prefix.runFromHours", "7");
        this.assertOptionSelected("filter.subscription.prefix.runFromMeridian", "am");
        this.assertOptionSelected("filter.subscription.prefix.runToHours", "8");
        this.assertOptionSelected("filter.subscription.prefix.runToMeridian", "am");
    }

    public void testDailyInvalidRange() {
        this.tester.clickLinkWithText("Add subscription");
        this.tester.checkCheckbox("filter.subscription.prefix.dailyWeeklyMonthly", "daily");
        this.tester.selectOption("filter.subscription.prefix.interval", "every 3 hours");
        this.tester.selectOption("filter.subscription.prefix.runFromHours", "1");
        this.tester.selectOption("filter.subscription.prefix.runToHours", "12");
        this.tester.submit("Subscribe");
        this.assertTextPresent("You must select a from time that is before the to time.");
    }

    public void testDefaultDaysPerWeekSingleDay() {
        this.tester.clickLinkWithText("Add subscription");
        this.tester.checkCheckbox("filter.subscription.prefix.dailyWeeklyMonthly", "daysOfWeek");
        this.tester.checkCheckbox("filter.subscription.prefix.weekday", "2");
        this.submit("Subscribe");
        this.assertTextPresent("0 0 1 ? * 2");
        this.assertTextPresent("Monday at 1:00 am");
    }

    public void testDefaultDaysPerWeekMultipleDays() {
        this.tester.clickLinkWithText("Add subscription");
        this.tester.checkCheckbox("filter.subscription.prefix.dailyWeeklyMonthly", "daysOfWeek");
        this.tester.checkCheckbox("filter.subscription.prefix.weekday", "2");
        this.tester.checkCheckbox("filter.subscription.prefix.weekday", "3");
        this.tester.checkCheckbox("filter.subscription.prefix.weekday", "5");
        this.tester.submit("Subscribe");
        this.assertTextPresent("0 0 1 ? * 2,3,5");
        this.assertTextPresent("Each Monday, Tuesday and Thursday at 1:00 am");
    }

    public void testNoDaysPerWeekSelected() {
        this.tester.clickLinkWithText("Add subscription");
        this.tester.checkCheckbox("filter.subscription.prefix.dailyWeeklyMonthly", "daysOfWeek");
        this.tester.submit("Subscribe");
        this.assertTextPresent("You must select one or more days of the week for the Days per Week mode.");
    }

    public void testDaysPerWeekInvalidRange() {
        this.tester.clickLinkWithText("Add subscription");
        this.tester.checkCheckbox("filter.subscription.prefix.dailyWeeklyMonthly", "daysOfWeek");
        this.tester.checkCheckbox("filter.subscription.prefix.weekday", "1");
        this.tester.selectOption("filter.subscription.prefix.interval", "every 3 hours");
        this.tester.selectOption("filter.subscription.prefix.runFromHours", "1");
        this.tester.selectOption("filter.subscription.prefix.runToHours", "12");
        this.tester.submit("Subscribe");
        this.assertTextPresent("You must select a from time that is before the to time.");
    }

    public void testInvalidForOneModeButValidForThisMode() {
        this.tester.clickLinkWithText("Add subscription");
        this.tester.checkCheckbox("filter.subscription.prefix.dailyWeeklyMonthly", "daysOfWeek");
        this.tester.selectOption("filter.subscription.prefix.interval", "every 3 hours");
        this.tester.selectOption("filter.subscription.prefix.runToHours", "12");
        this.tester.submit("Subscribe");
        this.assertTextPresent("You must select a from time that is before the to time.");
        this.tester.checkCheckbox("filter.subscription.prefix.dailyWeeklyMonthly", "daysOfMonth");
        this.tester.selectOption("filter.subscription.prefix.runOnceHours", "3");
        this.tester.submit("Subscribe");
        this.assertTextPresent("0 0 3 1 * ?");
        this.assertTextPresent("The 1st day of every month at 3:00 am");
    }

    public void testEditDaily() {
        this.tester.clickLinkWithText("Add subscription");
        this.tester.submit("Subscribe");
        this.assertTextPresent("0 0 1 ? * *");
        this.assertTextPresent("Daily at 1:00 am");
        this.tester.clickLink("edit_subscription");
        this.tester.checkCheckbox("filter.subscription.prefix.dailyWeeklyMonthly", "daily");
        this.tester.selectOption("filter.subscription.prefix.interval", "every 2 hours");
        this.tester.selectOption("filter.subscription.prefix.runFromHours", "10");
        this.tester.selectOption("filter.subscription.prefix.runToHours", "8");
        this.tester.selectOption("filter.subscription.prefix.runToMeridian", "pm");
        this.tester.submit("Update");
        this.assertTextPresent("0 0 10-19/2 ? * *");
        this.assertTextPresent("Daily every 2 hours from 10:00 am to 8:00 pm");
        this.tester.clickLink("edit_subscription");
        this.tester.selectOption("filter.subscription.prefix.interval", "once per day");
        this.tester.checkCheckbox("filter.subscription.prefix.dailyWeeklyMonthly", "daysOfWeek");
        this.tester.checkCheckbox("filter.subscription.prefix.weekday", "2");
        this.tester.selectOption("filter.subscription.prefix.runOnceHours", "6");
        this.tester.selectOption("filter.subscription.prefix.runOnceMins", "35");
        this.tester.submit("Update");
        this.assertTextPresent("0 35 6 ? * 2");
        this.assertTextPresent("Each Monday at 6:35 am");
        this.tester.clickLink("edit_subscription");
        this.tester.checkCheckbox("filter.subscription.prefix.dailyWeeklyMonthly", "daysOfMonth");
        this.tester.submit("Update");
        this.assertTextPresent("0 35 6 1 * ?");
        this.assertTextPresent("The 1st day of every month at 6:35 am");
        this.tester.clickLink("edit_subscription");
        this.tester.checkCheckbox("filter.subscription.prefix.daysOfMonthOpt", "dayOfWeekOfMonth");
        this.tester.selectOption("filter.subscription.prefix.week", "last");
        this.tester.selectOption("filter.subscription.prefix.day", "Wednesday");
        this.tester.selectOption("filter.subscription.prefix.runOnceMeridian", "pm");
        this.tester.submit("Update");
        this.assertTextPresent("0 35 18 ? * 4L");
        this.assertTextPresent("The last Wednesday of every month at 6:35 pm");
    }

    public void testDefaultDayOfMonthMode() {
        this.tester.clickLinkWithText("Add subscription");
        this.tester.checkCheckbox("filter.subscription.prefix.dailyWeeklyMonthly", "daysOfMonth");
        this.tester.submit("Subscribe");
        this.assertTextPresent("0 0 1 1 * ?");
        this.assertTextPresent("The 1st day of every month at 1:00 am");
    }

    public void testLastDayOfMonthMode() {
        this.tester.clickLinkWithText("Add subscription");
        this.tester.checkCheckbox("filter.subscription.prefix.dailyWeeklyMonthly", "daysOfMonth");
        this.tester.selectOption("filter.subscription.prefix.monthDay", "last");
        this.tester.selectOption("filter.subscription.prefix.runOnceHours", "12");
        this.tester.selectOption("filter.subscription.prefix.runOnceMins", "35");
        this.tester.submit("Subscribe");
        this.assertTextPresent("0 35 0 L * ?");
        this.assertTextPresent("The last day of every month at 12:35 am");
    }

    public void testComplexMonthMode() {
        this.tester.clickLinkWithText("Add subscription");
        this.tester.checkCheckbox("filter.subscription.prefix.dailyWeeklyMonthly", "daysOfMonth");
        this.tester.checkCheckbox("filter.subscription.prefix.daysOfMonthOpt", "dayOfWeekOfMonth");
        this.tester.selectOption("filter.subscription.prefix.week", "fourth");
        this.tester.selectOption("filter.subscription.prefix.day", "Thursday");
        this.tester.selectOption("filter.subscription.prefix.runOnceHours", "4");
        this.tester.selectOption("filter.subscription.prefix.runOnceMins", "35");
        this.tester.submit("Subscribe");
        this.assertTextPresent("0 35 4 ? * 5#4");
        this.assertTextPresent("The fourth Thursday of every month at 4:35 am");
    }

    public void testAdvancedMode() {
        this.tester.clickLinkWithText("Add subscription");
        this.tester.checkCheckbox("filter.subscription.prefix.dailyWeeklyMonthly", "advanced");
        this.tester.setFormElement("filter.subscription.prefix.cronString", "Invalid");
        this.tester.submit("Subscribe");
        this.assertTextPresent("Illegal characters for this position: INV");
        this.tester.setFormElement("filter.subscription.prefix.cronString", "0 35 4 * * *");
        this.tester.submit("Subscribe");
        this.assertTextPresent("There was a problem validating your cron expression. Please check the syntax and try again.");
        this.tester.setFormElement("filter.subscription.prefix.cronString", "0 37 4 * * ?");
        this.tester.submit("Subscribe");
        this.assertTextPresent("0 37 4 * * ?");
        this.assertTextNotPresent("Daily at 4:37 am");
    }

    public void testDeleteSubscription() {
        this.tester.clickLinkWithText("Add subscription");
        this.tester.checkCheckbox("filter.subscription.prefix.dailyWeeklyMonthly", "daysOfMonth");
        this.tester.submit("Subscribe");
        this.assertTextPresent("0 0 1 1 * ?");
        this.assertTextPresent("The 1st day of every month at 1:00 am");
        this.tester.clickLinkWithText("Delete");
        this.assertTextPresent("View Subscriptions for Test Filter");
        this.assertTextNotPresent("0 0 1 1 * ?");
    }

    public void testSubscribeToFilterWithNoPermissions() {
        this.navigation.logout();
        this.navigation.login("fred");
        this.tester.gotoPage("/secure/FilterSubscription!default.jspa?filterId=10000");
        this.assertTextPresent("The selected filter is not available to you, perhaps it has been deleted or had its permissions changed.");
        this.tester.submit("Subscribe");
        this.assertTextSequence(new String[]{"Access Denied", "It seems that you have tried to perform an operation which you are not permitted to perform."});
    }

    public void testDeleteGroupWithSubscription() {
        this.navigation.logout();
        this.navigation.login("admin");
        this.navigation.gotoAdminSection("group_browser");
        this.tester.setFormElement("addName", "delete-me");
        this.tester.submit("add_group");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.submit("show");
        this.tester.clickLinkWithText("Save");
        this.tester.setFormElement("filterName", "delete-group-filter");
        this.tester.submit("saveasfilter_submit");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("managefilters");
        this.tester.clickLink("subscribe_delete-group-filter");
        this.tester.selectOption("groupName", "delete-me");
        this.tester.submit("Subscribe");
        this.navigation.gotoAdmin();
        this.tester.clickLink("group_browser");
        this.tester.clickLink("del_delete-me");
        this.text.assertTextPresent(this.locator.page(), "This group is referenced in the following filter subscriptions:");
        this.text.assertTextPresent(this.locator.page(), "'delete-group-filter' owned by user : 'admin'");
        this.text.assertTextPresent(this.locator.page(), "These filter subscriptions will be automatically deleted.");
        this.tester.submit("Delete");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("managefilters");
        this.text.assertTextNotPresent(this.locator.page(), "1 Subscription");
    }
}

