/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.navigation.FilterNavigation;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.parser.filter.FilterList;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
public class TestFilterRelatedEntitiesDelete
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("sharedfilters/TestFilterRelatedEntitiesDelete.xml");
    }

    public void testEntityDelete() {
        FilterNavigation filterNavigation = this.navigation.manageFilters();
        this.tester.gotoPage("secure/admin/user/DeleteGroup!default.jspa?name=group_delete_me");
        this.tester.submit("Delete");
        filterNavigation.myFilters();
        FilterList filterList = this.parse.filter().parseFilterList("mf_owned");
        this.assertFilterSharingIsPrivate(filterList, "shared with group");
        this.tester.gotoPage("secure/project/DeleteProjectRole!default.jspa?id=10003");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "role_delete_me");
        this.tester.submit("Delete");
        filterNavigation.myFilters();
        filterList = this.parse.filter().parseFilterList("mf_owned");
        this.assertFilterSharingIsPrivate(filterList, "shared  with project role");
        this.tester.gotoPage("secure/project/DeleteProject!default.jspa?pid=10001&returnUrl=ViewProjects.jspa");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "deleteme");
        this.tester.submit("Delete");
        filterNavigation.myFilters();
        filterList = this.parse.filter().parseFilterList("mf_owned");
        this.assertFilterSharingIsPrivate(filterList, "shared with project");
    }

    public void testUserDelete() throws Exception {
        FilterNavigation filterNavigation = this.navigation.manageFilters();
        filterNavigation.goToDefault();
        this.assertFilterIsInList(this.parse.filter().parseFilterList("mf_favourites"), "shared by user_can_share_filters");
        this.navigation.gotoAdmin();
        this.tester.gotoPage("secure/admin/user/DeleteUser!default.jspa?returnUrl=UserBrowser.jspa&name=user_can_share_filters");
        this.tester.submit("Delete");
        filterNavigation.goToDefault();
        this.assertFilterIsNotInList(this.parse.filter().parseFilterList("mf_favourites"), "shared by user_can_share_filters");
    }

    private void assertFilterSharingIsPrivate(FilterList filterList, String filterName) {
        List<FilterItem> filterItems = filterList.getFilterItems();
        for (FilterItem filterItem : filterItems) {
            String name = filterItem.getName();
            if (!name.equals(filterName)) continue;
            List sharing = filterItem.getSharing();
            TestFilterRelatedEntitiesDelete.assertEquals((int)0, (int)sharing.size());
            return;
        }
        TestFilterRelatedEntitiesDelete.fail((String)("Couldnt find named fitler in list : " + filterName));
    }

    private void assertFilterIsNotInList(FilterList filterList, String filterName) {
        List<FilterItem> filterItems = filterList.getFilterItems();
        for (FilterItem filterItem : filterItems) {
            if (!filterItem.getName().equals(filterName)) continue;
            TestFilterRelatedEntitiesDelete.fail((String)("This filter '" + filterName + "' should not exist in the filter list"));
        }
    }

    private void assertFilterIsInList(FilterList filterList, String filterName) {
        List<FilterItem> filterItems = filterList.getFilterItems();
        for (FilterItem filterItem : filterItems) {
            if (!filterItem.getName().equals(filterName)) continue;
            return;
        }
        TestFilterRelatedEntitiesDelete.fail((String)("Failed to find filter in list : " + filterName));
    }
}

