/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.navigation.FilterNavigation;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.parser.filter.FilterList;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
public class TestFilterDelete
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("sharedfilters/SharedFiltersBase.xml");
    }

    public void testBasicNavigationPage() {
        FilterNavigation filterNavigation = this.navigation.manageFilters();
        long filterId = filterNavigation.createFilter("Delete Me", "This will be deleted");
        filterNavigation.myFilters();
        this.assertFilterIsInList(this.parse.filter().parseFilterList("mf_owned"), "Delete Me");
        filterNavigation.goToDefault();
        this.assertFilterIsInList(this.parse.filter().parseFilterList("mf_favourites"), "Delete Me");
        this.tester.gotoPage("secure/DeleteFilter!default.jspa?filterId=" + filterId + "&returnUrl=ManageFilters.jspa");
        this.tester.submit("Delete");
        this.assertOnManageFiltersPage();
        filterNavigation.myFilters();
        this.assertFilterIsNotInList(this.parse.filter().parseFilterList("mf_owned"), "Delete Me");
        filterNavigation.goToDefault();
        this.assertFilterIsNotInList(this.parse.filter().parseFilterList("mf_favourites"), "Delete Me");
    }

    private void assertFilterIsNotInList(FilterList filterList, String filterName) {
        List<FilterItem> filterItems = filterList.getFilterItems();
        for (FilterItem filterItem : filterItems) {
            if (!filterItem.getName().equals(filterName)) continue;
            TestFilterDelete.fail((String)("This filter '" + filterName + "' should not exist in the filter list"));
        }
    }

    private void assertFilterIsInList(FilterList filterList, String filterName) {
        List<FilterItem> filterItems = filterList.getFilterItems();
        for (FilterItem filterItem : filterItems) {
            if (!filterItem.getName().equals(filterName)) continue;
            return;
        }
        TestFilterDelete.fail((String)("Failed to find filter in list : " + filterName));
    }

    private void assertOnManageFiltersPage() {
        this.assertions.assertNodeHasText("//div[@id='content-top']/h2", "Manage Filters");
    }
}

