/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.DASHBOARDS, Category.PORTLETS})
public class TestFavouritesPortletAndPopup
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestUpgradeFavourites.xml");
    }

    public void testFilterPopUp() {
        this.navigation.login("admin");
        this.gotoFilterPopUp();
        TableLocator tableLocator = new TableLocator(this.tester, "filter_list");
        TestFavouritesPortletAndPopup.assertEquals((int)4, (int)tableLocator.getTable().getRowCount());
        TableCellLocator tableCellLocator = new TableCellLocator(this.tester, "filter_list", 1, 0);
        this.text.assertTextPresent(tableCellLocator, "All");
        this.text.assertTextPresent(tableCellLocator.getHTML(), "requestId=10000");
        tableCellLocator = new TableCellLocator(this.tester, "filter_list", 2, 0);
        this.text.assertTextPresent(tableCellLocator, "New Features");
        this.text.assertTextPresent(tableCellLocator.getHTML(), "requestId=10020");
        tableCellLocator = new TableCellLocator(this.tester, "filter_list", 3, 0);
        this.text.assertTextPresent(tableCellLocator, "Nick");
        this.text.assertTextPresent(tableCellLocator.getHTML(), "requestId=10010");
        this.navigation.manageFilters().removeFavourite(10000);
        this.gotoFilterPopUp();
        tableLocator = new TableLocator(this.tester, "filter_list");
        TestFavouritesPortletAndPopup.assertEquals((int)3, (int)tableLocator.getTable().getRowCount());
        tableCellLocator = new TableCellLocator(this.tester, "filter_list", 1, 0);
        this.text.assertTextPresent(tableCellLocator, "New Features");
        this.text.assertTextPresent(tableCellLocator.getHTML(), "requestId=10020");
        tableCellLocator = new TableCellLocator(this.tester, "filter_list", 2, 0);
        this.text.assertTextPresent(tableCellLocator, "Nick");
        this.text.assertTextPresent(tableCellLocator.getHTML(), "requestId=10010");
        this.navigation.manageFilters().removeFavourite(10020);
        this.gotoFilterPopUp();
        tableLocator = new TableLocator(this.tester, "filter_list");
        TestFavouritesPortletAndPopup.assertEquals((int)2, (int)tableLocator.getTable().getRowCount());
        tableCellLocator = new TableCellLocator(this.tester, "filter_list", 1, 0);
        this.text.assertTextPresent(tableCellLocator, "Nick");
        this.text.assertTextPresent(tableCellLocator.getHTML(), "requestId=10010");
        this.navigation.manageFilters().removeFavourite(10010);
        this.gotoFilterPopUp();
        tableLocator = new TableLocator(this.tester, "filter_list");
        TestFavouritesPortletAndPopup.assertNull((Object)tableLocator.getTable());
        this.tester.assertTextPresent("You have no favourite filters at the moment.");
        this.tester.assertTextPresent("Manage Filters");
        this.navigation.manageFilters().addFavourite(10001);
        this.gotoFilterPopUp();
        tableLocator = new TableLocator(this.tester, "filter_list");
        TestFavouritesPortletAndPopup.assertEquals((int)2, (int)tableLocator.getTable().getRowCount());
        tableCellLocator = new TableCellLocator(this.tester, "filter_list", 1, 0);
        this.text.assertTextPresent(tableCellLocator, "All My");
        this.text.assertTextPresent(tableCellLocator.getHTML(), "requestId=10001");
    }

    public void gotoFilterPopUp() {
        this.tester.gotoPage("secure/FavouriteFilters.jspa");
    }
}

