/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.parser.filter.FilterList;
import com.atlassian.jira.functest.framework.parser.filter.WebTestSharePermission;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
public class TestFavouriteAndMyFilters
extends FuncTestCase {
    private static final List NO_OPERATIONS = Collections.emptyList();
    private static final List<WebTestSharePermission> GLOBAL_SHARE = ImmutableList.of((Object)new WebTestSharePermission("global", null, null));
    private static final List<WebTestSharePermission> GROUP_DEVELOPERS_SHARE = ImmutableList.of((Object)new WebTestSharePermission("group", "jira-developers", null));
    private static final String JOE = "joe";
    private static final String ADMIN_LONG = "admin (admin)";
    private static final String JOE_LONG = "joe (joe)";
    private static final String NOBODY = "nobody";
    private static final String NOBODY_LONG = "nobody (nobody)";
    private static final List<String> OPERATIONS = ImmutableList.of((Object)"Edit", (Object)"Delete", (Object)"Columns");
    static final FilterItem FILTER_10000 = new FilterItem(10000L, "All", "", "admin (admin)", 2L, Collections.<WebTestSharePermission>emptyList(), false, 1L, OPERATIONS, 0L);
    static final FilterItem FILTER_10001 = new FilterItem(10001L, "All My", "yadayada", "joe (joe)", 2L, GLOBAL_SHARE, true, 2L, OPERATIONS, 3L);
    static final FilterItem FILTER_10010 = new FilterItem(10010L, "Nick", "", "admin (admin)", 2L, GLOBAL_SHARE, false, 4L, OPERATIONS, 0L);
    static final FilterItem FILTER_10020 = new FilterItem(10020L, "New Features", "", "admin (admin)", 0L, GROUP_DEVELOPERS_SHARE, true, 0L, OPERATIONS, 1L);
    static final FilterItem FILTER_10030 = new FilterItem(10030L, "Nobody's All", "Yadyayda", "nobody (nobody)", 2L, Collections.<WebTestSharePermission>emptyList(), true, 0L, OPERATIONS, 1L);
    private static final int SHARE_FILTERS = 22;

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestDeleteUserForFiltersAndSubscriptions.xml");
    }

    public void testStickyTabs() {
        this.navigation.login("admin", "admin");
        this.tester.gotoPage("secure/ManageFilters.jspa");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@id='filter_type_table']/li", "Favourite");
        this.navigation.manageFilters().myFilters();
        this.tester.assertTextPresent("My");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@id='filter_type_table']/li", "My");
        this.tester.gotoPage("secure/ManageFilters.jspa");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@id='filter_type_table']/li", "My");
        this.navigation.manageFilters().goToDefault();
        this.tester.assertTextPresent("Favourite");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@id='filter_type_table']/li", "Favourite");
        this.tester.gotoPage("secure/ManageFilters.jspa");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@id='filter_type_table']/li", "Favourite");
    }

    public void testOperations() {
        this._testInitAnonymousScreen();
        this._testInitNobodyScreen();
        this._testInitJoeScreen();
        this._testInitAdminScreen();
        this.administration.removeGlobalPermission(22, "jira-users");
        this._testInitAnonymousScreen();
        this._testInitAdminScreen();
        this._testInitNobodyScreen();
        this.navigation.login(JOE, JOE);
        this.navigation.manageFilters().goToDefault();
        this.assertNavigatorTabsPresent();
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List<FilterItem> filterList = filters.getFilterItems();
        FilterItem filterItem = this.noFavCount(this.makeMine(this.setSubCount(this.setFavCount(this.noOps(FILTER_10001), 3), 2)));
        filterItem.setOperations((List)ImmutableList.of((Object)"Edit", (Object)"Delete", (Object)"Columns"));
        ImmutableList compareList = ImmutableList.of((Object)filterItem);
        TestFavouriteAndMyFilters.assertEquals((Object)compareList, filterList);
    }

    public void testDeleteUser() {
        this._testInitAnonymousScreen();
        this._testInitAdminScreen();
        this._testInitJoeScreen();
        this._testInitNobodyScreen();
        this.navigation.login("admin", "admin");
        this._testDeleteConfirm("admin", 3, 2, 0);
        this._testDeleteConfirm(JOE, 5, 1, 1);
        this._testDeleteConfirm(NOBODY, 5, 0, 0);
        this.tester.submit("Delete");
        this._testJoeScreenAfterNobodyDelete();
        this.navigation.manageFilters().addFavourite(10010);
        this._testAdminScreenAfterNobodyDelete();
        this._testAnonymousScreenAfterNobodyDelete();
        this.navigation.login("admin", "admin");
        this.navigation.manageFilters().removeFavourite(10001);
        this.navigation.manageFilters().allFilters();
        this.assertNavigatorTabsPresent();
        FilterList filters = this.parse.filter().parseFilterList("mf_browse");
        ImmutableList compareList = ImmutableList.of((Object)this.makeMine(this.setSubCount(this.setFavCount(this.noOps(this.makeNotFav(FILTER_10000)), 0), 1)), (Object)this.setSubCount(this.setFavCount(this.noOps(this.makeNotFav(FILTER_10001)), 1), 1), (Object)this.makeMine(this.setSubCount(this.setFavCount(this.noOps(FILTER_10020), 1), 0)), (Object)this.makeMine(this.setSubCount(this.setFavCount(this.noOps(FILTER_10010), 1), 4)));
        TestFavouriteAndMyFilters.assertEquals((Object)compareList, filters.getFilterItems());
        this._testDeleteConfirm(JOE, 5, 1, 0);
        this.tester.submit("Delete");
        this._testAdminScreenAfterJoeDelete();
        this._testAnonymousScreenAfterJoeDelete();
    }

    public void testDeleteFilter() {
        this._testInitAnonymousScreen();
        this._testInitAdminScreen();
        this._testInitJoeScreen();
        this._testInitNobodyScreen();
        this._testDeleteFilterPermission(10020L);
        this.navigation.login(NOBODY, NOBODY);
        this._testDeleteFilterPermission(10020L);
        this.navigation.login("admin", "admin");
        this._testDeleteFilterConfirm(10020L, 0L, 0L);
        this.navigation.login(JOE, JOE);
        this._testDeleteFilterConfirm(10001L, 2L, 2L);
        this.navigation.manageFilters().goToDefault();
        TestFavouriteAndMyFilters.assertTrue((boolean)this.parse.filter().parseFilterList("mf_favourites").isEmpty());
        this.navigation.manageFilters().myFilters();
        this.assertNavigatorTabsPresent();
        TestFavouriteAndMyFilters.assertTrue((boolean)this.parse.filter().parseFilterList("mf_owned").isEmpty());
        this._testDeleteFilterPermission(10000L);
        this.navigation.login("admin", "admin");
        this.navigation.manageFilters().goToDefault();
        this.assertNavigatorTabsPresent();
        this.text.assertTextNotPresent(this.locator.page(), "All My");
        this.navigation.logout();
        this.navigation.manageFilters().goToDefault();
        this.checkAnonymousScreen(Collections.singletonList(this.noOps(this.setSubCount(this.setIssueCount(FILTER_10010, 0), 0))));
        this.navigation.login("admin", "admin");
        this._testDeleteFilterConfirm(10010L, 0L, 4L);
        this.checkAnonymousScreen(null);
        this.text.assertTextPresent(this.locator.page(), "Your search criteria did not match any filters.");
    }

    private void _testDeleteFilterPermission(long filterId) {
        this.tester.gotoPage("secure/DeleteFilter!default.jspa?filterId=" + filterId);
        this.text.assertTextPresent(this.locator.page(), "You do not have permission to delete this filter or this filter may not exist.");
        this.text.assertTextNotPresent(this.locator.page(), "Users who have nominated this filter as a favourite");
        this.text.assertTextNotPresent(this.locator.page(), "Subscriptions attached to this filter");
        this.text.assertTextNotPresent(this.locator.page(), "Deleting this filter will delete all the subscriptions");
        this.tester.assertButtonNotPresent("Delete");
    }

    private void _testDeleteFilterConfirm(long filterId, long favouriteCount, long subscriptionCount) {
        this.tester.gotoPage("secure/DeleteFilter!default.jspa?filterId=" + filterId + "&returnUrl=ManageFilters.jspa");
        WebPageLocator locator = new WebPageLocator(this.tester);
        ArrayList<String> messages = new ArrayList<String>();
        if (favouriteCount == 1L) {
            messages.add("There is 1 other person who has added this filter as a favourite.");
        } else if (favouriteCount > 1L) {
            messages.add("There are " + favouriteCount + " other people who have added this filter as a favourite.");
        } else {
            this.text.assertTextNotPresent(locator, "Users who have nominated this filter as a favourite");
        }
        if (subscriptionCount == 1L) {
            messages.add("There is 1 subscription attached to this filter.");
        } else if (subscriptionCount > 1L) {
            messages.add("There are " + subscriptionCount + " subscriptions attached to this filter. ");
        } else {
            this.text.assertTextPresent(locator, "Deleting this filter will not alter any subscriptions, as there are 0 subscriptions associated with it.");
            this.text.assertTextNotPresent(locator, "Subscriptions attached to this filter");
            this.text.assertTextNotPresent(locator, "Deleting this filter will delete all the subscriptions");
        }
        if (!messages.isEmpty()) {
            this.text.assertTextSequence(locator, messages.toArray(new String[messages.size()]));
        }
        this.tester.submit("Delete");
    }

    private void _testDeleteConfirm(String user, int row, int shared, int favs) {
        this.navigation.gotoAdmin();
        this.tester.gotoPage("secure/admin/user/DeleteUser!default.jspa?returnUrl=UserBrowser.jspa&name=" + user);
        TableCellLocator cellLocator = new TableCellLocator(this.tester, "delete_user_confirm", row, 1);
        this.text.assertTextPresent(cellLocator, "" + shared);
        cellLocator = new TableCellLocator(this.tester, "delete_user_confirm", row + 1, 1);
        this.text.assertTextPresent(cellLocator, "" + favs);
    }

    private void checkAnonymousScreen(List expectedFilters) {
        this.navigation.logout();
        this.navigation.manageFilters().goToDefault();
        this.assertNavigatorTabsPresent();
        this.text.assertTextPresent(this.xpath("//ul[@id='filter_type_table']"), "Search");
        this.text.assertTextPresent(this.xpath("//ul[@id='filter_type_table']"), "Popular");
        this.text.assertTextNotPresent(this.xpath("//ul[@id='filter_type_table']"), "Favourite");
        this.text.assertTextNotPresent(this.xpath("//ul[@id='filter_type_table']"), "My");
        this.navigation.manageFilters().allFilters();
        FilterList filterList = this.parse.filter().parseFilterList("mf_browse");
        List<FilterItem> actualFilters = null;
        if (filterList != null) {
            actualFilters = filterList.getFilterItems();
        }
        TestFavouriteAndMyFilters.assertEquals((Object)expectedFilters, actualFilters);
        TestFavouriteAndMyFilters.assertNull((Object)this.parse.filter().parseFilterList("mf_favourites"));
        TestFavouriteAndMyFilters.assertNull((Object)this.parse.filter().parseFilterList("mf_owned"));
    }

    private void assertNavigatorTabsPresent() {
    }

    private void _testInitAnonymousScreen() {
        List<FilterItem> compareList = CollectionBuilder.newBuilder(this.noOps(this.makeNotFav(this.setIssueCount(this.setSubCount(FILTER_10001, 0), 0))), this.noOps(this.setIssueCount(this.setSubCount(FILTER_10010, 0), 0))).asList();
        this.checkAnonymousScreen(compareList);
    }

    private void _testAnonymousScreenAfterNobodyDelete() {
        ImmutableList compareList = ImmutableList.of((Object)this.noOps(this.makeNotFav(this.setFavCount(this.setIssueCount(this.setSubCount(FILTER_10001, 0), 0), 2))), (Object)this.noOps(this.setFavCount(this.setIssueCount(this.setSubCount(FILTER_10010, 0), 0), 1)));
        this.checkAnonymousScreen((List)compareList);
    }

    private void _testAnonymousScreenAfterJoeDelete() {
        ImmutableList compareList = ImmutableList.of((Object)this.noOps(this.setFavCount(this.setIssueCount(this.setSubCount(FILTER_10010, 0), 0), 0)));
        this.checkAnonymousScreen((List)compareList);
    }

    private void _testInitNobodyScreen() {
        this.navigation.login(NOBODY, NOBODY);
        this.navigation.manageFilters().goToDefault();
        this.assertNavigatorTabsPresent();
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List<FilterItem> filterList = filters.getFilterItems();
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.noFavCount(this.setSubCount(this.noOps(FILTER_10001), 0)));
        compareList.add(this.noFavCount(this.makeMine(FILTER_10030)));
        TestFavouriteAndMyFilters.assertEquals(compareList, filterList);
        this.navigation.manageFilters().myFilters();
        filters = this.parse.filter().parseFilterList("mf_owned");
        compareList = new ArrayList();
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10030)));
        TestFavouriteAndMyFilters.assertEquals(compareList, filters.getFilterItems());
        this.navigation.manageFilters().allFilters();
        filters = this.parse.filter().parseFilterList("mf_browse");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.setSubCount(this.noOps(FILTER_10001), 0));
        compareList.add(this.noOps(this.makeNotFav(FILTER_10020)));
        compareList.add(this.setSubCount(this.noOps(FILTER_10010), 2));
        compareList.add(this.makeMine(this.noOps(FILTER_10030)));
        TestFavouriteAndMyFilters.assertEquals(compareList, filterList);
    }

    private FilterItem setIssueCount(FilterItem filter, int count) {
        FilterItem filterItem1 = filter.cloneFilter();
        filterItem1.setIssues(count);
        return filterItem1;
    }

    private FilterItem setSubCount(FilterItem filter, int count) {
        FilterItem filterItem1 = filter.cloneFilter();
        filterItem1.setSubscriptions(count);
        return filterItem1;
    }

    private FilterItem makeFav(FilterItem filter) {
        FilterItem filterItem1 = filter.cloneFilter();
        filterItem1.setFav(true);
        return filterItem1;
    }

    private FilterItem makeNotFav(FilterItem filter) {
        FilterItem filterItem1 = filter.cloneFilter();
        filterItem1.setFav(false);
        return filterItem1;
    }

    private FilterItem setFavCount(FilterItem filter, int count) {
        FilterItem item = filter.cloneFilter();
        item.setFavCount(count);
        return item;
    }

    private FilterItem noFavCount(FilterItem filter) {
        FilterItem item = filter.cloneFilter();
        item.setFavCount(0L);
        return item;
    }

    private FilterItem noOps(FilterItem filter) {
        FilterItem filterItem = filter.cloneFilter();
        filterItem.setOperations(NO_OPERATIONS);
        return filterItem;
    }

    private FilterItem noAuthor(FilterItem filterItem1) {
        FilterItem filterItem = filterItem1.cloneFilter();
        filterItem.setAuthor(null);
        return filterItem;
    }

    private FilterItem makeMine(FilterItem filter) {
        return filter;
    }

    private void _testInitJoeScreen() {
        this.navigation.login(JOE, JOE);
        this.navigation.manageFilters().goToDefault();
        this.assertNavigatorTabsPresent();
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List<FilterItem> filterList = filters.getFilterItems();
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.noFavCount(this.makeMine(FILTER_10001)));
        TestFavouriteAndMyFilters.assertEquals(compareList, filterList);
        this.navigation.manageFilters().myFilters();
        filters = this.parse.filter().parseFilterList("mf_owned");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10001)));
        TestFavouriteAndMyFilters.assertEquals(compareList, filterList);
        this.navigation.manageFilters().allFilters();
        filters = this.parse.filter().parseFilterList("mf_browse");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noOps(this.makeMine(FILTER_10001)));
        compareList.add(this.noOps(this.setSubCount(FILTER_10010, 2)));
        TestFavouriteAndMyFilters.assertEquals(compareList, filterList);
    }

    private void _testInitAdminScreen() {
        this.navigation.login("admin", "admin");
        this.navigation.manageFilters().goToDefault();
        this.assertNavigatorTabsPresent();
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List<FilterItem> filterList = filters.getFilterItems();
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.noFavCount(this.setSubCount(this.noOps(FILTER_10001), 1)));
        compareList.add(this.noFavCount(this.makeMine(FILTER_10020)));
        TestFavouriteAndMyFilters.assertEquals(compareList, filterList);
        this.navigation.manageFilters().myFilters();
        filters = this.parse.filter().parseFilterList("mf_owned");
        TestFavouriteAndMyFilters.assertFalse((boolean)filters.containsColumn("Author"));
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10000)));
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10020)));
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10010)));
        TestFavouriteAndMyFilters.assertEquals(compareList, filterList);
        this.navigation.manageFilters().allFilters();
        filters = this.parse.filter().parseFilterList("mf_browse");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noOps(this.makeMine(FILTER_10000)));
        compareList.add(this.setSubCount(this.noOps(FILTER_10001), 1));
        compareList.add(this.noOps(this.makeMine(FILTER_10020)));
        compareList.add(this.noOps(this.makeMine(FILTER_10010)));
        TestFavouriteAndMyFilters.assertEquals(compareList, filterList);
    }

    private void _testAdminScreenAfterNobodyDelete() {
        this.navigation.login("admin", "admin");
        this.navigation.manageFilters().goToDefault();
        this.assertNavigatorTabsPresent();
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List<FilterItem> filterList = filters.getFilterItems();
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.noFavCount(this.setSubCount(this.noOps(FILTER_10001), 1)));
        compareList.add(this.noFavCount(this.makeMine(FILTER_10020)));
        TestFavouriteAndMyFilters.assertEquals(compareList, filterList);
        this.navigation.manageFilters().myFilters();
        filters = this.parse.filter().parseFilterList("mf_owned");
        TestFavouriteAndMyFilters.assertFalse((boolean)filters.containsColumn("Author"));
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10000)));
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10020)));
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10010)));
        TestFavouriteAndMyFilters.assertEquals(compareList, filterList);
        this.navigation.manageFilters().allFilters();
        filters = this.parse.filter().parseFilterList("mf_browse");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noOps(this.makeMine(FILTER_10000)));
        compareList.add(this.setFavCount(this.setSubCount(this.noOps(FILTER_10001), 1), 2));
        compareList.add(this.noOps(this.makeMine(FILTER_10020)));
        compareList.add(this.setFavCount(this.noOps(this.makeMine(FILTER_10010)), 1));
        TestFavouriteAndMyFilters.assertEquals(compareList, filterList);
    }

    private void _testAdminScreenAfterJoeDelete() {
        this.navigation.login("admin", "admin");
        this.navigation.manageFilters().goToDefault();
        this.assertNavigatorTabsPresent();
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List<FilterItem> filterList = filters.getFilterItems();
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.noFavCount(this.makeMine(FILTER_10020)));
        TestFavouriteAndMyFilters.assertEquals(compareList, filterList);
        this.navigation.manageFilters().myFilters();
        filters = this.parse.filter().parseFilterList("mf_owned");
        TestFavouriteAndMyFilters.assertFalse((boolean)filters.containsColumn("Author"));
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10000)));
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10020)));
        compareList.add(this.noFavCount(this.setSubCount(this.noAuthor(FILTER_10010), 3)));
        TestFavouriteAndMyFilters.assertEquals(compareList, filterList);
        this.navigation.manageFilters().allFilters();
        filters = this.parse.filter().parseFilterList("mf_browse");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noOps(this.makeMine(FILTER_10000)));
        compareList.add(this.noOps(this.makeMine(FILTER_10020)));
        compareList.add(this.noOps(this.makeMine(this.setSubCount(FILTER_10010, 3))));
        TestFavouriteAndMyFilters.assertEquals(compareList, filterList);
    }

    private void _testJoeScreenAfterNobodyDelete() {
        this.navigation.login(JOE, JOE);
        this.navigation.manageFilters().goToDefault();
        this.assertNavigatorTabsPresent();
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List<FilterItem> filterList = filters.getFilterItems();
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.noFavCount(this.makeMine(FILTER_10001)));
        TestFavouriteAndMyFilters.assertEquals(compareList, filterList);
        this.navigation.manageFilters().myFilters();
        filters = this.parse.filter().parseFilterList("mf_owned");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10001)));
        TestFavouriteAndMyFilters.assertEquals(compareList, filterList);
        this.navigation.manageFilters().allFilters();
        filters = this.parse.filter().parseFilterList("mf_browse");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.setFavCount(this.noOps(this.makeMine(FILTER_10001)), 2));
        compareList.add(this.noOps(this.setSubCount(FILTER_10010, 2)));
        TestFavouriteAndMyFilters.assertEquals(compareList, filterList);
    }
}

