/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.fields;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.FIELDS, Category.ISSUE_NAVIGATOR, Category.ISSUES})
public class TestResolutionDateField
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestResolutionDateField.xml");
    }

    public void testViewIssuePage() {
        this.navigation.issue().viewIssue("HSP-1");
        IdLocator locator = new IdLocator(this.tester, "issue_header_summary");
        this.text.assertTextPresent(locator, "First test issue");
        locator = new IdLocator(this.tester, "status-val");
        this.text.assertTextNotPresent(locator, "Resolved");
        this.navigation.issue().viewIssue("HSP-2");
        locator = new IdLocator(this.tester, "issue_header_summary");
        this.text.assertTextPresent(locator, "Second test issue");
        locator = new IdLocator(this.tester, "status-val");
        this.text.assertTextPresent(locator, "Resolved");
    }

    public void testResolveIssueUpdatesDate() {
        this.navigation.issue().viewIssue("HSP-1");
        IdLocator locator = new IdLocator(this.tester, "issue_header_summary");
        this.text.assertTextPresent(locator, "First test issue");
        locator = new IdLocator(this.tester, "status-val");
        this.text.assertTextNotPresent(locator, "Resolved");
        this.tester.clickLink("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        locator = new IdLocator(this.tester, "issue_header_summary");
        this.text.assertTextPresent(locator, "First test issue");
        locator = new IdLocator(this.tester, "status-val");
        this.text.assertTextPresent(locator, "Resolved");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("Issue Navigator");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 2, 1), "HSP-1");
        String resolvedCell = this.tester.getDialog().getWebTableBySummaryOrId("issuetable").getCellAsText(2, 11).trim();
        TestResolutionDateField.assertTrue((resolvedCell.length() > 0 ? 1 : 0) != 0);
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLink("action_id_3");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        locator = new IdLocator(this.tester, "issue_header_summary");
        this.text.assertTextPresent(locator, "First test issue");
        locator = new IdLocator(this.tester, "status-val");
        this.text.assertTextNotPresent(locator, "Resolved");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("Issue Navigator");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 2, 1), "HSP-1");
        this.assertTableCellEmpty("issuetable", 2, 11);
    }

    public void testIssueNavigatorColumns() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("Issue Navigator");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 0, 11), "Resolved");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 1, 1), "HSP-2");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 1, 11), "14/Oct/08");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 2, 1), "HSP-1");
        this.assertTableCellEmpty("issuetable", 2, 11);
    }

    public void testSearcher() {
        this.navigation.issueNavigator().gotoNavigator();
        this.tester.setFormElement("resolutiondate:after", "13/Oct/08");
        this.tester.setFormElement("resolutiondate:before", "16/Oct/08");
        this.tester.setFormElement("resolutiondate:next", "");
        this.tester.submit("show");
        this.tester.assertTextPresent("Issue Navigator");
        TestResolutionDateField.assertEquals((int)2, (int)this.tester.getDialog().getWebTableBySummaryOrId("issuetable").getRowCount());
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 0, 11), "Resolved");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 1, 1), "HSP-2");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 1, 11), "14/Oct/08");
        this.tester.setFormElement("resolutiondate:after", "15/Oct/08");
        this.tester.setFormElement("resolutiondate:before", "16/Oct/08");
        this.tester.setFormElement("resolutiondate:next", "");
        this.tester.submit("show");
        this.tester.assertTextPresent("No matching issues found.");
        TestResolutionDateField.assertNull((Object)this.tester.getDialog().getWebTableBySummaryOrId("issuetable"));
    }

    public void testIssueViews() {
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLinkWithText("Printable");
        this.tester.assertTextNotPresent("Resolved:");
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.clickLinkWithText("Printable");
        this.tester.assertTextPresent("Resolved:");
    }

    private void assertTableCellEmpty(String tableId, int row, int col) {
        String resolvedCell = this.tester.getDialog().getWebTableBySummaryOrId(tableId).getCellAsText(row, col).trim();
        TestResolutionDateField.assertTrue((resolvedCell.length() == 0 ? 1 : 0) != 0);
    }
}

