/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.fields;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.FIELDS, Category.SCHEMES})
public class TestFieldLayoutSchemes
extends JIRAWebTest {
    private static final String FIELD_LAYOUT_NAME_ONE = "Test Field Configuration One";

    public TestFieldLayoutSchemes(String name) {
        super(name);
    }

    public void testFieldLayoutSchemes() {
        this.restoreBlankInstance();
        if (this.projectExists("homosapien")) {
            TestFieldLayoutSchemes.log("Project 'homosapien' exists");
            if (!this.componentExists("New Component 1", "homosapien")) {
                this.addComponent("homosapien", "New Component 1");
            }
            if (!this.versionExists("New Version 1", "homosapien")) {
                this.addVersion("homosapien", "New Version 1", "Version 1");
            }
        } else {
            this.addProject("homosapien", "HSP", "admin");
            this.addComponent("homosapien", "New Component 1");
            this.addVersion("homosapien", "New Version 1", "Version 1");
        }
        if (this.projectExists("neanderthal")) {
            TestFieldLayoutSchemes.log("Project 'neanderthal' exists");
        } else {
            this.addProject("neanderthal", "NDT", "admin");
        }
        if (this.projectExists("monkey")) {
            TestFieldLayoutSchemes.log("Project 'monkey' exists");
        } else {
            this.addProject("monkey", "MKY", "admin");
        }
        if (this.fieldSchemeExists("New Field Layout Scheme")) {
            this.deleteFieldLayoutScheme("New Field Layout Scheme");
        }
        this.resetFields();
        String issueKey = this.addIssue("homosapien", "HSP", "Bug", "test for field layout schemes", "Major", null, null, null, "Administrator", "test environment 2", "test description for field layout schemes", null, null, null);
        this.fieldSchemesAddScheme();
        this.fieldSchemesAddDuplicateScheme();
        this.fieldSchemesAddInvalidScheme();
        this.fieldSchemesAssociateWithProject();
        this.fieldSchemesCreateIssueWithFieldLayoutSchemeHidden();
        this.fieldSchemesCreateIssueWithFieldLayoutSchemeRequired();
        this.checkNavigatorFields();
        this.checkProjectTabPanels();
        this.fieldSchemesEditIssueWithFieldLayoutSchemeHidden(issueKey);
        this.fieldSchemesEditIssueWithFieldLayoutSchemeRequired(issueKey);
        String issueKey2 = this.addIssue("homosapien", "HSP", "Bug", "test for field layout schemes", "Major", new String[]{"New Component 1"}, new String[]{"New Version 1"}, new String[]{"New Version 1"}, "Administrator", "test environment 2", "test description for field layout schemes", null, null, null);
        this.fieldSchemeMoveIssueWithFieldSchemeHidden(issueKey);
        this.fieldSchemeMoveIssueWithFieldSchemeRequired(issueKey);
        this.fieldSchemeCreateSubTaskWithFieldSchemeHidden(issueKey);
        this.fieldSchemeCreateSubTaskWithFieldSchemeRequired(issueKey);
        this.fieldSchemesDeleteScheme();
        this.deleteIssue(issueKey);
        this.deleteIssue(issueKey2);
    }

    public void fieldSchemesAddScheme() {
        TestFieldLayoutSchemes.log("Field Layout Scheme: Adding a scheme");
        this.addFieldLayoutScheme("New Field Layout Scheme", "field layout scheme for testing");
        this.assertLinkPresentWithText("New Field Layout Scheme");
        this.assertTextPresent("New Field Layout Scheme");
    }

    public void fieldSchemesDeleteScheme() {
        TestFieldLayoutSchemes.log("Field Layout Scheme: Deleting a scheme");
        this.deleteFieldLayoutScheme("New Field Layout Scheme");
        this.assertLinkNotPresentWithText("New Field Layout Scheme");
        this.assertLinkNotPresentWithText("field layout scheme for testing");
    }

    public void fieldSchemesAddDuplicateScheme() {
        TestFieldLayoutSchemes.log("Field Layout Scheme: Adding a scheme with a duplicate name");
        this.addFieldLayoutScheme("New Field Layout Scheme", "field layout scheme for testing");
        this.assertTextPresent("A Field Configuration Scheme with this name already exists.");
    }

    public void fieldSchemesAddInvalidScheme() {
        TestFieldLayoutSchemes.log("Field Layout Scheme: Adding a scheme with a duplicate name");
        this.addFieldLayoutScheme("", "");
        this.assertTextPresent("You must enter a valid name.");
    }

    public void fieldSchemesAssociateWithProject() {
        TestFieldLayoutSchemes.log("Field Layout Scheme: associate a scheme to an issue type in a project");
        this.associateFieldLayoutScheme("neanderthal", "Bug", "New Field Layout Scheme");
        this.assertTextPresent("New Field Layout Scheme");
        this.removeAssociationWithFieldLayoutScheme("neanderthal", "Bug", "New Field Layout Scheme");
        this.assertTextNotPresent("New Field Layout Scheme");
    }

    public void fieldSchemesCreateIssueWithFieldLayoutSchemeRequired() {
        TestFieldLayoutSchemes.log("Create Issue: Attempt to create with issue field layout");
        this.addFieldLayoutSchemeEntry("Bug", FIELD_LAYOUT_NAME_ONE, "New Field Layout Scheme");
        this.associateFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.setRequiredFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Component/s");
        this.setRequiredFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Affects Version/s");
        this.setRequiredFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Fix Version/s");
        this.createIssueStep1();
        this.setFormElement("summary", "test summary");
        this.submit();
        this.assertTextPresent("CreateIssueDetails.jspa");
        this.assertTextPresent("Component/s is required");
        this.assertTextPresent("Affects Version/s is required");
        this.assertTextPresent("Fix Version/s is required");
        this.removeAssociationWithFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.removeFieldLayoutSchemeEntry("Bug", "New Field Layout Scheme");
        this.setOptionalFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Component/s");
        this.setOptionalFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Affects Version/s");
        this.setOptionalFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Fix Version/s");
    }

    public void fieldSchemesCreateIssueWithFieldLayoutSchemeHidden() {
        this.copyFieldLayout(FIELD_LAYOUT_NAME_ONE);
        this.addFieldLayoutSchemeEntry("Bug", FIELD_LAYOUT_NAME_ONE, "New Field Layout Scheme");
        this.associateFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.setHiddenFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Component/s");
        this.setHiddenFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Affects Version/s");
        this.setHiddenFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Fix Version/s");
        TestFieldLayoutSchemes.log("Create Issue: Test the creation of am issue using hidden fields");
        this.createIssueStep1();
        this.assertFormElementNotPresent("components");
        this.assertFormElementNotPresent("versions");
        this.assertFormElementNotPresent("fixVersions");
        this.setShownFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Component/s");
        this.setShownFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Affects Version/s");
        this.setShownFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Fix Version/s");
        this.removeAssociationWithFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.removeFieldLayoutSchemeEntry("Bug", "New Field Layout Scheme");
    }

    private void removeFieldLayoutSchemeEntry(String issueTypeName, String schemeName) {
        this.gotoFieldLayoutSchemes();
        this.clickLinkWithText(schemeName);
        this.assertTextInTable("scheme_entries", issueTypeName);
        try {
            WebTable table = this.getDialog().getResponse().getTableWithID("scheme_entries");
            for (int i = 0; i < table.getRowCount(); ++i) {
                String cellAsText = table.getCellAsText(i, 0);
                if (!TextUtils.stringSet((String)cellAsText) || cellAsText.indexOf(issueTypeName) <= -1) continue;
                table.getTableCell(i, 2).getLinkWith("Delete").click();
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public void fieldSchemesEditIssueWithFieldLayoutSchemeHidden(String issueKey) {
        this.addFieldLayoutSchemeEntry("Bug", FIELD_LAYOUT_NAME_ONE, "New Field Layout Scheme");
        this.associateFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.setHiddenFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Component/s");
        this.setHiddenFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Affects Version/s");
        this.setHiddenFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Fix Version/s");
        TestFieldLayoutSchemes.log("Edit Issue: Test the updating of an issue using hidden fields");
        this.gotoIssue(issueKey);
        this.clickLink("editIssue");
        this.assertFormElementNotPresent("components");
        this.assertFormElementNotPresent("versions");
        this.assertFormElementNotPresent("fixVersions");
        this.setShownFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Component/s");
        this.setShownFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Affects Version/s");
        this.setShownFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Fix Version/s");
        this.removeAssociationWithFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.removeFieldLayoutSchemeEntry("Bug", "New Field Layout Scheme");
    }

    public void checkNavigatorFields() {
        TestFieldLayoutSchemes.log("Check Issue Navigator display for hidden/visible fields");
        this.activateSubTasks();
        this.addFieldLayoutSchemeEntry("Bug", FIELD_LAYOUT_NAME_ONE, "New Field Layout Scheme");
        this.associateFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.setHiddenFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Assignee");
        this.setHiddenFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Due Date");
        this.setHiddenFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Priority");
        this.setHiddenFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Resolution");
        this.getNavigation().issueNavigator().displayAllIssues();
        this.setWorkingForm("issue-filter");
        this.assertTextPresent("Assignee");
        this.assertTextPresent("Due Date");
        this.assertTextPresent("Priority");
        this.assertTextPresent("Resolution");
        this.associateFieldLayoutScheme("neanderthal", "Bug", "New Field Layout Scheme");
        this.associateFieldLayoutScheme("monkey", "Bug", "New Field Layout Scheme");
        this.addFieldLayoutSchemeEntry("New Feature", FIELD_LAYOUT_NAME_ONE, "New Field Layout Scheme");
        this.addFieldLayoutSchemeEntry("Improvement", FIELD_LAYOUT_NAME_ONE, "New Field Layout Scheme");
        this.addFieldLayoutSchemeEntry("Task", FIELD_LAYOUT_NAME_ONE, "New Field Layout Scheme");
        this.addFieldLayoutSchemeEntry("Sub-task", FIELD_LAYOUT_NAME_ONE, "New Field Layout Scheme");
        this.getNavigation().issueNavigator().displayAllIssues();
        this.setWorkingForm("issue-filter");
        this.assertTextNotPresent("Assignee");
        this.assertTextNotPresent("Due Date");
        this.assertTextNotPresent("Priority");
        this.assertTextNotPresent("Resolution");
        this.setShownFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Assignee");
        this.setShownFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Due Date");
        this.setShownFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Priority");
        this.setShownFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Resolution");
        this.getNavigation().issueNavigator().displayAllIssues();
        this.setWorkingForm("issue-filter");
        this.assertTextPresent("Assignee");
        this.assertTextPresent("Due Date");
        this.assertTextPresent("Priority");
        this.assertTextPresent("Resolution");
        this.removeAssociationWithFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.removeAssociationWithFieldLayoutScheme("neanderthal", "Bug", "New Field Layout Scheme");
        this.removeAssociationWithFieldLayoutScheme("monkey", "Bug", "New Field Layout Scheme");
        this.removeFieldLayoutSchemeEntry("Bug", "New Field Layout Scheme");
        this.removeFieldLayoutSchemeEntry("New Feature", "New Field Layout Scheme");
        this.removeFieldLayoutSchemeEntry("Improvement", "New Field Layout Scheme");
        this.removeFieldLayoutSchemeEntry("Task", "New Field Layout Scheme");
        this.removeFieldLayoutSchemeEntry("Sub-task", "New Field Layout Scheme");
        this.deactivateSubTasks();
    }

    public void checkProjectTabPanels() {
        TestFieldLayoutSchemes.log("Check Project Tab Panel for hidden/visible fields");
        this.activateSubTasks();
        this.addFieldLayoutSchemeEntry("Bug", FIELD_LAYOUT_NAME_ONE, "New Field Layout Scheme");
        this.associateFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.setHiddenFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Component/s");
        this.setHiddenFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Fix Version/s");
        this.setHiddenFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Version/s");
        this.gotoPage("/browse/HSP");
        this.assertLinkPresentWithText("Components");
        this.assertLinkPresentWithText("Versions");
        this.assertLinkPresentWithText("Road Map");
        this.assertLinkPresentWithText("Change Log");
        this.associateFieldLayoutScheme("neanderthal", "Bug", "New Field Layout Scheme");
        this.associateFieldLayoutScheme("monkey", "Bug", "New Field Layout Scheme");
        this.addFieldLayoutSchemeEntry("New Feature", FIELD_LAYOUT_NAME_ONE, "New Field Layout Scheme");
        this.addFieldLayoutSchemeEntry("Improvement", FIELD_LAYOUT_NAME_ONE, "New Field Layout Scheme");
        this.addFieldLayoutSchemeEntry("Task", FIELD_LAYOUT_NAME_ONE, "New Field Layout Scheme");
        this.addFieldLayoutSchemeEntry("Sub-task", FIELD_LAYOUT_NAME_ONE, "New Field Layout Scheme");
        this.gotoPage("/browse/HSP");
        this.assertLinkNotPresentWithText("Open Issues");
        this.assertLinkNotPresentWithText("Components");
        this.assertLinkNotPresentWithText("Versions");
        this.assertLinkNotPresentWithText("Road Map");
        this.assertLinkNotPresentWithText("Change Log");
        this.setShownFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Component/s");
        this.setShownFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Fix Version/s");
        this.setShownFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Version/s");
        this.gotoPage("/browse/HSP");
        this.clickLink("issues-panel-panel");
        this.assertTextPresent("Unresolved: By Component");
        this.assertTextPresent("Unresolved: By Version");
        this.removeAssociationWithFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.removeAssociationWithFieldLayoutScheme("neanderthal", "Bug", "New Field Layout Scheme");
        this.removeAssociationWithFieldLayoutScheme("monkey", "Bug", "New Field Layout Scheme");
        this.removeFieldLayoutSchemeEntry("Bug", "New Field Layout Scheme");
        this.removeFieldLayoutSchemeEntry("New Feature", "New Field Layout Scheme");
        this.removeFieldLayoutSchemeEntry("Improvement", "New Field Layout Scheme");
        this.removeFieldLayoutSchemeEntry("Task", "New Field Layout Scheme");
        this.removeFieldLayoutSchemeEntry("Sub-task", "New Field Layout Scheme");
        this.deactivateSubTasks();
    }

    public void fieldSchemesEditIssueWithFieldLayoutSchemeRequired(String issueKey) {
        TestFieldLayoutSchemes.log("Edit Issue: Attempt to edit an issue with issue field layout");
        this.addFieldLayoutSchemeEntry("Bug", FIELD_LAYOUT_NAME_ONE, "New Field Layout Scheme");
        this.associateFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.setRequiredFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Component/s");
        this.setRequiredFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Affects Version/s");
        this.setRequiredFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Fix Version/s");
        this.gotoIssue(issueKey);
        this.clickLink("editIssue");
        this.assertTextPresent("Edit Issue");
        this.submit("Update");
        this.assertTextPresent("Component/s is required");
        this.assertTextPresent("Affects Version/s is required");
        this.assertTextPresent("Fix Version/s is required");
        this.removeAssociationWithFieldLayoutScheme("homosapien", "Bug", "New Field Layout Scheme");
        this.removeFieldLayoutSchemeEntry("Bug", "New Field Layout Scheme");
        this.setOptionalFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Component/s");
        this.setOptionalFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Affects Version/s");
        this.setOptionalFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Fix Version/s");
    }

    public void fieldSchemeMoveIssueWithFieldSchemeHidden(String issueKey) {
        TestFieldLayoutSchemes.log("Move Issue: Test the abilty to hide a field in a particular Field Layout Scheme");
        this.addFieldLayoutSchemeEntry("Improvement", FIELD_LAYOUT_NAME_ONE, "New Field Layout Scheme");
        this.associateFieldLayoutScheme("homosapien", "Improvement", "New Field Layout Scheme");
        this.setHiddenFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Component/s");
        this.setHiddenFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Affects Version/s");
        this.setHiddenFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Fix Version/s");
        this.gotoIssue(issueKey);
        this.clickLink("move-issue");
        this.assertTextPresent("Move Issue");
        this.selectOption("issuetype", "Improvement");
        this.submit();
        this.assertTextPresent("All fields will be updated automatically.");
        this.setShownFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Component/s");
        this.setShownFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Affects Version/s");
        this.setShownFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Fix Version/s");
        this.removeAssociationWithFieldLayoutScheme("homosapien", "Improvement", "New Field Layout Scheme");
        this.removeFieldLayoutSchemeEntry("Improvement", "New Field Layout Scheme");
    }

    public void fieldSchemeMoveIssueWithFieldSchemeRequired(String issueKey) {
        TestFieldLayoutSchemes.log("Move Issue: Test the abilty to make a field required in a particular Field Layout Scheme");
        this.addFieldLayoutSchemeEntry("Improvement", FIELD_LAYOUT_NAME_ONE, "New Field Layout Scheme");
        this.associateFieldLayoutScheme("homosapien", "Improvement", "New Field Layout Scheme");
        this.setRequiredFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Component/s");
        this.setRequiredFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Affects Version/s");
        this.setRequiredFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Fix Version/s");
        this.gotoIssue(issueKey);
        this.clickLink("move-issue");
        this.assertTextPresent("Move Issue");
        this.selectOption("issuetype", "Improvement");
        this.submit();
        this.assertTextPresent("Step 3 of 4");
        this.getDialog().setWorkingForm("jiraform");
        this.submit();
        this.assertTextPresent("Step 3 of 4");
        this.assertTextPresent("Component/s is required");
        this.assertTextPresent("Affects Version/s is required");
        this.assertTextPresent("Fix Version/s is required");
        this.setOptionalFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Component/s");
        this.setOptionalFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Affects Version/s");
        this.setOptionalFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Fix Version/s");
        this.removeAssociationWithFieldLayoutScheme("homosapien", "Improvement", "New Field Layout Scheme");
        this.removeFieldLayoutSchemeEntry("Improvement", "New Field Layout Scheme");
    }

    public void fieldSchemeCreateSubTaskWithFieldSchemeRequired(String issueKey) {
        TestFieldLayoutSchemes.log("Sub Task Create: Enforce Sub Tasks on a field layout scheme");
        this.activateSubTasks();
        this.addFieldLayoutSchemeEntry("Sub-task", FIELD_LAYOUT_NAME_ONE, "New Field Layout Scheme");
        this.associateFieldLayoutScheme("homosapien", "Sub-task", "New Field Layout Scheme");
        this.setRequiredFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Component/s");
        this.setRequiredFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Affects Version/s");
        this.setRequiredFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Fix Version/s");
        this.gotoIssue(issueKey);
        this.clickLink("create-subtask");
        this.assertTextPresent("Create Sub-Task");
        this.setFormElement("summary", "test summary");
        this.submit();
        this.assertTextPresent("Create Sub-Task");
        this.assertTextPresent("Component/s is required");
        this.assertTextPresent("Affects Version/s is required");
        this.assertTextPresent("Fix Version/s is required");
        this.setOptionalFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Component/s");
        this.setOptionalFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Affects Version/s");
        this.setOptionalFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Fix Version/s");
        this.removeAssociationWithFieldLayoutScheme("homosapien", "Sub-task", "New Field Layout Scheme");
        this.removeFieldLayoutSchemeEntry("Sub-task", "New Field Layout Scheme");
        this.deactivateSubTasks();
    }

    public void fieldSchemeCreateSubTaskWithFieldSchemeHidden(String issueKey) {
        TestFieldLayoutSchemes.log("Sub Task Create: Enforce Sub Tasks on a field layout scheme");
        this.activateSubTasks();
        this.addFieldLayoutSchemeEntry("Sub-task", FIELD_LAYOUT_NAME_ONE, "New Field Layout Scheme");
        this.associateFieldLayoutScheme("homosapien", "Sub-task", "New Field Layout Scheme");
        this.setHiddenFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Component/s");
        this.setHiddenFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Affects Version/s");
        this.setHiddenFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Fix Version/s");
        this.gotoIssue(issueKey);
        this.clickLink("create-subtask");
        this.assertTextPresent("Create Sub-Task");
        this.assertFormElementNotPresent("components");
        this.assertFormElementNotPresent("versions");
        this.assertFormElementNotPresent("fixVersions");
        this.setShownFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Component/s");
        this.setShownFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Affects Version/s");
        this.setShownFieldsOnEnterprise(FIELD_LAYOUT_NAME_ONE, "Fix Version/s");
        this.removeAssociationWithFieldLayoutScheme("homosapien", "Sub-task", "New Field Layout Scheme");
        this.removeFieldLayoutSchemeEntry("Sub-task", "New Field Layout Scheme");
        this.deactivateSubTasks();
    }
}

