/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.EMAIL})
public class TestMailServer
extends JIRAWebTest {
    protected static final String FIELD_NAME = "name";
    protected static final String FIELD_FROM = "from";
    protected static final String FIELD_PREFIX = "prefix";
    protected static final String FIELD_SERVER_NAME = "serverName";
    protected static final String FIELD_USERNAME = "username";
    protected static final String FIELD_PASSWORD = "password";
    private static final String FIELD_PORT = "port";
    protected static final String VALUE_NAME_SMTP = "name SMTP";
    protected static final String VALUE_NAME_POP = "name POP";
    protected static final String VALUE_FROM = "from@atlassian.com";
    protected static final String VALUE_PREFIX = "prefix";
    protected static final String VALUE_SERVER_NAME = "server name";
    protected static final String VALUE_USERNAME = "username";
    protected static final String VALUE_PASSWORD = "password";
    protected static final String TITLE_SMTP_MAIL_SERVERS = "<h3 class=\"formtitle\">SMTP Mail Server</h3>";
    protected static final String TITLE_ADD_SMTP_MAIL_SERVER = "<h3 class=\"formtitle\">Add SMTP Mail Server</h3>";
    protected static final String TITLE_POP_MAIL_SERVERS = "<h3 class=\"formtitle\">POP / IMAP Mail Servers</h3>";
    protected static final String TITLE_ADD_POP_MAIL_SERVER = "<h3 class=\"formtitle\">Add POP / IMAP Mail Server</h3>";
    protected static final String TITLE_DELETE_MAIL_SERVER = "<h3 class=\"formtitle\">Delete Mail Server</h3>";
    protected static final String TITLE_SUPPORT_REQUEST = "<h3 class=\"formtitle\">Support Request</h3>";
    protected static final String TITLE_SEND_EMAIL = "<h3 class=\"formtitle\">Send Email</h3>";
    protected static final String TITLE_MAIL_QUEUE = "<h3 class=\"formtitle\">Mail Queue</h3>";
    protected static final String LINK_TEXT_CONFIG_NEW_SMTP = "Configure new SMTP mail server";
    protected static final String LINK_TEXT_CONFIG_NEW_POP = "Configure new POP / IMAP mail server";
    protected static final String LINK_DELETE_SMTP = "deleteSMTP";
    protected static final String LINK_PAGE_MAIL_SERVER = "mail_servers";
    protected static final String LINK_PAGE_SEND_EMAIL = "send_email";
    protected static final String LINK_PAGE_MAIL_QUEUE = "mail_queue";
    protected static final String LABEL_NO_SMTP_MAIL_SERVER = "You do not currently have an SMTP server configured. No outgoing mail will be sent.";
    protected static final String LABEL_NO_SMTP_SUPPORT_REQUEST_PART_ONE = "<span class=\"note\">Note</span>: To send a support request you need to";
    protected static final String LABEL_NO_SMTP_SUPPORT_REQUEST_PART_TWO = "configure</a> a mail server.";
    protected static final String LABEL_NO_SMTP_SEND_EMAIL_PART_ONE = "To send email you need to";
    protected static final String LABEL_NO_SMTP_SEND_EMAIL_PART_TWO = "configure</a> a mail server.";
    protected static final String LABEL_NO_SMTP_MAIL_QUEUE_PART_ONE = "There is no default ";
    protected static final String LABEL_NO_SMTP_MAIL_QUEUE_PART_TWO = "mail server</a>, so mails will not be sent.";
    protected static final String LABEL_NO_POP_MAIL_SERVER = "You do not currently have any POP / IMAP servers configured.";
    protected static final String BUTTON_CANCEL = "cancelButton";
    protected static final String BUTTON_ADD = "Add";
    protected static final String BUTTON_DELETE = "Delete";
    private static final String BUTTON_UPDATE = "Update";
    protected static final String ERROR_SPECIFY_SERVER = "You must specify the name of this Mail Server.";
    protected static final String ERROR_SPECIFY_ADDRESS = "You must specify a valid from address";
    protected static final String ERROR_SPECIFY_PREFIX = "You must specify an email prefix";
    protected static final String ERROR_SPECIFY_SERVER_DETAILS = "You must specify a host name or a JNDI location.";
    protected static final String ERROR_SPECIFY_SERVER_LOCATION = "You must specify the location of the server.";
    protected static final String ERROR_SPECIFY_USERNAME = "You must specify a username";
    protected static final String ERROR_SPECIFY_PASSWORD = "You must specify a password";
    private static final String ERROR_ILLEGAL_PORT = "SMTP port must be a number between 0 and 65535";
    private static final String SUPPORT_REQUEST_ACTION = "/secure/admin/JiraSupportRequest!default.jspa";

    public TestMailServer(String name) {
        super(name);
    }

    public void testValidateSMTPForm() {
        TestMailServer.log("Mail Server - Validating empty form for new SMTP mail server setup");
        this.navigation.gotoAdminSection(LINK_PAGE_MAIL_SERVER);
        this.assertTextPresent(TITLE_SMTP_MAIL_SERVERS);
        this.tester.clickLinkWithText(LINK_TEXT_CONFIG_NEW_SMTP);
        this.assertTextPresent(TITLE_ADD_SMTP_MAIL_SERVER);
        this.tester.submit(BUTTON_ADD);
        this.assertTextPresent(ERROR_SPECIFY_SERVER);
        this.assertTextPresent(ERROR_SPECIFY_ADDRESS);
        this.assertTextPresent(ERROR_SPECIFY_PREFIX);
        this.tester.setFormElement(FIELD_NAME, VALUE_NAME_SMTP);
        this.tester.setFormElement(FIELD_FROM, VALUE_FROM);
        this.tester.setFormElement("prefix", "prefix");
        this.tester.submit(BUTTON_ADD);
        this.assertTextPresent(ERROR_SPECIFY_SERVER_DETAILS);
        this.tester.setFormElement(FIELD_SERVER_NAME, VALUE_SERVER_NAME);
        this.tester.setFormElement("username", "username");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement(FIELD_PORT, String.valueOf(65536));
        this.tester.submit(BUTTON_ADD);
        this.assertTextPresent(ERROR_ILLEGAL_PORT);
        this.tester.submit(BUTTON_ADD);
        this.assertTextPresent(ERROR_ILLEGAL_PORT);
        this.tester.setFormElement(FIELD_PORT, String.valueOf(-1));
        this.tester.submit(BUTTON_ADD);
        this.assertTextPresent(ERROR_ILLEGAL_PORT);
    }

    public void testConfigureNewSMTPServer() {
        TestMailServer.log("Mail Server - Configuring a new SMTP mail server");
        this.navigation.gotoAdminSection(LINK_PAGE_MAIL_SERVER);
        this.assertTextPresent(TITLE_SMTP_MAIL_SERVERS);
        this.tester.clickLinkWithText(LINK_TEXT_CONFIG_NEW_SMTP);
        this.assertTextPresent(TITLE_ADD_SMTP_MAIL_SERVER);
        this.tester.setFormElement(FIELD_NAME, VALUE_NAME_SMTP);
        this.tester.setFormElement(FIELD_FROM, VALUE_FROM);
        this.tester.setFormElement("prefix", "prefix");
        this.tester.setFormElement(FIELD_SERVER_NAME, VALUE_SERVER_NAME);
        this.tester.setFormElement("username", "username");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement(FIELD_PORT, String.valueOf(65535));
        this.tester.submit(BUTTON_ADD);
        this.assertTextPresent(TITLE_SMTP_MAIL_SERVERS);
        this.assertTextPresent(VALUE_NAME_SMTP);
        this.assertTextSequence(new String[]{"From:", VALUE_FROM, "Prefix:", "prefix", "Host:", VALUE_SERVER_NAME, "SMTP Port:", String.valueOf(65535), "Username:", "username"});
        this.tester.assertLinkNotPresentWithText(LINK_TEXT_CONFIG_NEW_SMTP);
        this.tester.clickLink("edit_10000");
        this.tester.setFormElement(FIELD_PORT, String.valueOf(0));
        this.tester.setFormElement("password", "password");
        this.tester.submit(BUTTON_UPDATE);
        this.assertTextSequence(new String[]{"SMTP Port:", "0"});
    }

    public void testSMTPServerExists() {
        TestMailServer.log("Mail Server - Checking labels when a SMTP server is setup");
        this.navigation.gotoAdminSection(LINK_PAGE_MAIL_SERVER);
        this.assertTextNotPresent(LABEL_NO_SMTP_MAIL_SERVER);
        this.assertLinkNotPresentWithText(LINK_TEXT_CONFIG_NEW_SMTP);
        this.navigation.gotoPage(SUPPORT_REQUEST_ACTION);
        this.assertTextPresent(TITLE_SUPPORT_REQUEST);
        this.assertTextNotPresent(LABEL_NO_SMTP_SUPPORT_REQUEST_PART_ONE);
        this.assertTextNotPresent("configure</a> a mail server.");
        this.navigation.gotoAdminSection(LINK_PAGE_SEND_EMAIL);
        this.assertTextPresent(TITLE_SEND_EMAIL);
        this.assertTextNotPresent(LABEL_NO_SMTP_SEND_EMAIL_PART_ONE);
        this.assertTextNotPresent("configure</a> a mail server.");
        this.navigation.gotoAdminSection(LINK_PAGE_MAIL_QUEUE);
        this.assertTextPresent(TITLE_MAIL_QUEUE);
        this.assertTextNotPresent(LABEL_NO_SMTP_MAIL_QUEUE_PART_ONE);
        this.assertTextNotPresent(LABEL_NO_SMTP_MAIL_QUEUE_PART_TWO);
    }

    public void testDeleteSMTPServer() {
        TestMailServer.log("Mail Server - Deleting the SMTP server");
        this.navigation.gotoAdminSection(LINK_PAGE_MAIL_SERVER);
        this.assertTextPresent(TITLE_SMTP_MAIL_SERVERS);
        this.tester.clickLink(LINK_DELETE_SMTP);
        this.assertTextPresent(TITLE_DELETE_MAIL_SERVER);
        this.assertTextPresent("Are you sure you want to delete <b>name SMTP</b>?");
        this.tester.submit(BUTTON_DELETE);
        this.assertTextPresent(LABEL_NO_SMTP_MAIL_SERVER);
        this.assertLinkPresentWithText(LINK_TEXT_CONFIG_NEW_SMTP);
    }

    public void testNoSMTPServer() {
        TestMailServer.log("Mail Server - Checking labels when a SMTP server is NOT setup");
        this.navigation.gotoAdminSection(LINK_PAGE_MAIL_SERVER);
        this.assertTextPresent(LABEL_NO_SMTP_MAIL_SERVER);
        this.assertLinkPresentWithText(LINK_TEXT_CONFIG_NEW_SMTP);
        this.tester.gotoPage(SUPPORT_REQUEST_ACTION);
        this.assertTextPresent(TITLE_SUPPORT_REQUEST);
        this.assertTextPresent(LABEL_NO_SMTP_SUPPORT_REQUEST_PART_ONE);
        this.assertTextPresent("configure</a> a mail server.");
        this.navigation.gotoAdminSection(LINK_PAGE_SEND_EMAIL);
        this.assertTextPresent(TITLE_SEND_EMAIL);
        this.assertTextPresent(LABEL_NO_SMTP_SEND_EMAIL_PART_ONE);
        this.assertTextPresent("configure</a> a mail server.");
        this.navigation.gotoAdminSection(LINK_PAGE_MAIL_QUEUE);
        this.assertTextPresent(TITLE_MAIL_QUEUE);
        this.assertTextPresent(LABEL_NO_SMTP_MAIL_QUEUE_PART_ONE);
        this.assertTextPresent(LABEL_NO_SMTP_MAIL_QUEUE_PART_TWO);
    }

    public void testValidatePOPForm() {
        TestMailServer.log("Mail Server - Validayting empty form for new POP mail server setup");
        this.navigation.gotoAdminSection(LINK_PAGE_MAIL_SERVER);
        this.assertTextPresent(TITLE_POP_MAIL_SERVERS);
        this.tester.clickLinkWithText(LINK_TEXT_CONFIG_NEW_POP);
        this.assertTextPresent(TITLE_ADD_POP_MAIL_SERVER);
        this.tester.submit(BUTTON_ADD);
        this.assertTextPresent(ERROR_SPECIFY_SERVER);
        this.assertTextPresent(ERROR_SPECIFY_SERVER_LOCATION);
        this.assertTextPresent(ERROR_SPECIFY_USERNAME);
        this.assertTextPresent(ERROR_SPECIFY_PASSWORD);
        this.tester.setFormElement(FIELD_NAME, VALUE_NAME_POP);
        this.tester.setFormElement(FIELD_SERVER_NAME, VALUE_SERVER_NAME);
        this.tester.setFormElement("username", "username");
        this.tester.setFormElement("password", "password");
        this.tester.clickButton(BUTTON_CANCEL);
    }

    public void testConfigureNewPOPServer() {
        this.restoreBlankInstance();
        TestMailServer.log("Mail Server - Configuring a new POP mail server");
        this.navigation.gotoAdminSection(LINK_PAGE_MAIL_SERVER);
        this.assertTextPresent(TITLE_POP_MAIL_SERVERS);
        this.configurePopServer(VALUE_NAME_POP, VALUE_SERVER_NAME, "110", "username", "password");
        this.assertTextPresent(TITLE_POP_MAIL_SERVERS);
        this.assertTextPresent(VALUE_NAME_POP);
        this.text.assertTextPresent(this.locator.page(), "Host: server name");
        this.text.assertTextPresent(this.locator.page(), "Username: username");
        this.tester.clickLinkWithText(LINK_TEXT_CONFIG_NEW_POP);
    }

    public void testPOPServerExists() {
        TestMailServer.log("Mail Server - Checking labels when a POP server is setup");
        this.navigation.gotoAdminSection(LINK_PAGE_MAIL_SERVER);
        this.assertTextNotPresent(LABEL_NO_POP_MAIL_SERVER);
    }

    public void testDeletePOPServer() {
        TestMailServer.log("Mail Server - Deleting the POP server");
        this.navigation.gotoAdminSection(LINK_PAGE_MAIL_SERVER);
        this.assertTextPresent(TITLE_POP_MAIL_SERVERS);
        this.tester.clickLink("delete-pop-10000");
        this.assertTextPresent(TITLE_DELETE_MAIL_SERVER);
        this.assertTextPresent("Are you sure you want to delete <b>name POP</b>?");
        this.tester.submit(BUTTON_DELETE);
        this.assertTextPresent(LABEL_NO_SMTP_MAIL_SERVER);
        this.tester.assertLinkPresentWithText(LINK_TEXT_CONFIG_NEW_SMTP);
    }

    public void testNoPOPServer() {
        this.administration.restoreBlankInstance();
        TestMailServer.log("Mail Server - Checking labels when a POP server is NOT setup");
        this.navigation.gotoAdminSection(LINK_PAGE_MAIL_SERVER);
        this.assertTextPresent(LABEL_NO_POP_MAIL_SERVER);
        this.tester.assertLinkPresentWithText(LINK_TEXT_CONFIG_NEW_POP);
    }

    public void testPortSetOnUpdatePopServer() {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(LINK_PAGE_MAIL_SERVER);
        this.configurePopServer(VALUE_NAME_POP, VALUE_SERVER_NAME, "222", "username", "password");
        this.tester.clickLink("edit-pop-10000");
        this.assertFormElementEquals(FIELD_PORT, "222");
    }

    private void configurePopServer(String name, String hostName, String port, String username, String password) {
        this.tester.clickLinkWithText(LINK_TEXT_CONFIG_NEW_POP);
        this.assertTextPresent(TITLE_ADD_POP_MAIL_SERVER);
        this.tester.setFormElement(FIELD_NAME, name);
        this.tester.setFormElement(FIELD_SERVER_NAME, hostName);
        this.tester.setFormElement(FIELD_PORT, port);
        this.tester.setFormElement("username", username);
        this.tester.setFormElement("password", password);
        this.tester.submit(BUTTON_ADD);
    }
}

