/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.functest.framework.email.EmailKit;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.AbstractSubscriptionEmailTest;
import java.util.Iterator;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.EMAIL})
public class TestEmailSubscription
extends AbstractSubscriptionEmailTest {
    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestSubscription.xml");
        this.configureAndStartSmtpServer();
    }

    public void testGroupZeroResults() throws Exception {
        this.subscribeToFilterAndRun(AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_ZERO_RESULTS, "jira-users");
        this.flushMailQueueAndWait(3);
        MimeMessage[] messages = this.getGreenMail().getReceivedMessages();
        MimeMessage currentMessage = EmailKit.findMessageAddressedTo("admin@stuff.com.com", messages);
        TestEmailSubscription.assertNotNull((Object)currentMessage);
        this.assertTextMessageValid(currentMessage, AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_ZERO_RESULTS, "jiratest@atlassian.com", "admin@stuff.com.com", "admin");
        String body = EmailKit.getBody((Part)currentMessage);
        this.assertNotPartialLink(body);
        this.assertEditLink(body);
        currentMessage = EmailKit.findMessageAddressedTo("bob@stuff.com.com", messages);
        TestEmailSubscription.assertNotNull((Object)currentMessage);
        this.assertTextMessageValid(currentMessage, AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_ZERO_RESULTS, "jiratest@atlassian.com", "bob@stuff.com.com", "admin");
        body = EmailKit.getBody((Part)currentMessage);
        this.assertNotPartialLink(body);
        this.assertNotEditLink(body);
        currentMessage = EmailKit.findMessageAddressedTo("fred@example.com", messages);
        TestEmailSubscription.assertNotNull((Object)currentMessage);
        this.assertHtmlMessageValid(currentMessage, AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_ZERO_RESULTS, "jiratest@atlassian.com", "fred@example.com", "admin");
        body = EmailKit.getBody((Part)currentMessage);
        this.assertNotPartialLink(body);
        this.assertNotEditLink(body);
    }

    public void testGroupCompleteResults() throws Exception {
        this.subscribeToFilterAndRun(AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_FULL, "jira-users");
        this.flushMailQueueAndWait(3);
        MimeMessage[] messages = this.getGreenMail().getReceivedMessages();
        MimeMessage currentMessage = EmailKit.findMessageAddressedTo("admin@stuff.com.com", messages);
        TestEmailSubscription.assertNotNull((Object)currentMessage);
        this.assertTextMessageValid(currentMessage, AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_FULL, "jiratest@atlassian.com", "admin@stuff.com.com", "admin");
        String body = EmailKit.getBody((Part)currentMessage);
        this.assertNotPartialLink(body);
        this.assertEditLink(body);
        currentMessage = EmailKit.findMessageAddressedTo("bob@stuff.com.com", messages);
        TestEmailSubscription.assertNotNull((Object)currentMessage);
        this.assertTextMessageValid(currentMessage, AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_FULL, "jiratest@atlassian.com", "bob@stuff.com.com", "admin");
        body = EmailKit.getBody((Part)currentMessage);
        this.assertNotPartialLink(body);
        this.assertNotEditLink(body);
        currentMessage = EmailKit.findMessageAddressedTo("fred@example.com", messages);
        TestEmailSubscription.assertNotNull((Object)currentMessage);
        this.assertHtmlMessageValid(currentMessage, AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_FULL, "jiratest@atlassian.com", "fred@example.com", "admin");
        body = EmailKit.getBody((Part)currentMessage);
        this.assertNotPartialLink(body);
        this.assertNotEditLink(body);
    }

    public void testGroupPartialResults() throws Exception {
        this.subscribeToFilterAndRun(AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_PARTIAL, "jira-users");
        this.flushMailQueueAndWait(3);
        MimeMessage[] messages = this.getGreenMail().getReceivedMessages();
        MimeMessage currentMessage = EmailKit.findMessageAddressedTo("admin@stuff.com.com", messages);
        TestEmailSubscription.assertNotNull((Object)currentMessage);
        this.assertTextMessageValid(currentMessage, AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_PARTIAL, "jiratest@atlassian.com", "admin@stuff.com.com", "admin");
        String body = EmailKit.getBody((Part)currentMessage);
        body = this.assertPartialLink(AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_PARTIAL, body);
        this.assertEditLink(body);
        currentMessage = EmailKit.findMessageAddressedTo("bob@stuff.com.com", messages);
        TestEmailSubscription.assertNotNull((Object)currentMessage);
        this.assertTextMessageValid(currentMessage, AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_PARTIAL, "jiratest@atlassian.com", "bob@stuff.com.com", "admin");
        body = EmailKit.getBody((Part)currentMessage);
        body = this.assertPartialLink(AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_PARTIAL, body);
        this.assertNotEditLink(body);
        currentMessage = EmailKit.findMessageAddressedTo("fred@example.com", messages);
        TestEmailSubscription.assertNotNull((Object)currentMessage);
        this.assertHtmlMessageValid(currentMessage, AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_PARTIAL, "jiratest@atlassian.com", "fred@example.com", "admin");
        body = EmailKit.getBody((Part)currentMessage);
        body = this.assertPartialLink(AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_PARTIAL, body);
        this.assertNotEditLink(body);
    }

    public void testPersonalZeroResults() throws Exception {
        this.navigation.login("fred", "fred");
        this.subscribeToFilterAndRun(AbstractSubscriptionEmailTest.FilterConfig.FRED_FILTER_ZERO_RESULTS, null);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.flushMailQueueAndWait(1);
        MimeMessage[] messages = this.getGreenMail().getReceivedMessages();
        TestEmailSubscription.assertNotNull((Object)messages[0]);
        this.assertHtmlMessageValid(messages[0], AbstractSubscriptionEmailTest.FilterConfig.FRED_FILTER_ZERO_RESULTS, "jiratest@atlassian.com", "fred@example.com", "fred");
        String body = EmailKit.getBody((Part)messages[0]);
        this.assertNotPartialLink(body);
        this.assertEditLink(body);
    }

    public void testPersonalCompleteResults() throws Exception {
        this.navigation.login("fred", "fred");
        this.subscribeToFilterAndRun(AbstractSubscriptionEmailTest.FilterConfig.FRED_FILTER_FULL, null);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.flushMailQueueAndWait(1);
        MimeMessage[] messages = this.getGreenMail().getReceivedMessages();
        TestEmailSubscription.assertNotNull((Object)messages[0]);
        this.assertHtmlMessageValid(messages[0], AbstractSubscriptionEmailTest.FilterConfig.FRED_FILTER_FULL, "jiratest@atlassian.com", "fred@example.com", "fred");
        String body = EmailKit.getBody((Part)messages[0]);
        this.assertNotPartialLink(body);
        this.assertEditLink(body);
    }

    public void testPersonalPartialResults() throws Exception {
        this.navigation.login("fred", "fred");
        this.subscribeToFilterAndRun(AbstractSubscriptionEmailTest.FilterConfig.FRED_FILTER_PARTIAL, null);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.flushMailQueueAndWait(1);
        MimeMessage[] messages = this.getGreenMail().getReceivedMessages();
        TestEmailSubscription.assertNotNull((Object)messages[0]);
        this.assertHtmlMessageValid(messages[0], AbstractSubscriptionEmailTest.FilterConfig.FRED_FILTER_PARTIAL, "jiratest@atlassian.com", "fred@example.com", "fred");
        String body = EmailKit.getBody((Part)messages[0]);
        body = this.assertPartialLink(AbstractSubscriptionEmailTest.FilterConfig.FRED_FILTER_PARTIAL, body);
        this.assertEditLink(body);
    }

    public void testSubscriptionIsHtmlEncoded() throws Exception {
        this.administration.restoreData("Test_JRA_17595.xml");
        this.configureAndStartSmtpServer();
        AbstractSubscriptionEmailTest.FilterConfig ADMIN_FILTER_XSS = new AbstractSubscriptionEmailTest.FilterConfig("FilterTwo", "<b>Description</b>", "ProjectTwo", "TWO", 2, 2){

            @Override
            public Iterator getIssueIterator() {
                return new AbstractSubscriptionEmailTest.CountingIterator(1, this.getReturnedIssues());
            }
        };
        this.subscribeToFilterAndRun(ADMIN_FILTER_XSS, "jira-users");
        this.flushMailQueueAndWait(4);
        MimeMessage[] messages = this.getGreenMail().getReceivedMessages();
        MimeMessage currentMessage = EmailKit.findMessageAddressedTo("admin@stuff.com.com", messages);
        TestEmailSubscription.assertNotNull((Object)currentMessage);
        this.assertHtmlMessageValid(currentMessage, ADMIN_FILTER_XSS, "jiratest@atlassian.com", "admin@stuff.com.com", "admin");
        String body = EmailKit.getBody((Part)currentMessage);
        this.text.assertTextPresent(body, "&lt;b&gt;Description&lt;/b&gt;");
        this.text.assertTextPresent(body, "Administrator &lt;b&gt;bold&lt;/b&gt;");
        currentMessage = EmailKit.findMessageAddressedTo("xss@example.com", messages);
        TestEmailSubscription.assertNotNull((Object)currentMessage);
        body = EmailKit.getBody((Part)currentMessage);
        this.text.assertTextPresent(body, "&lt;b&gt;Description&lt;/b&gt;");
    }

    public void testUserNameIsEncodedInHtml() throws InterruptedException, MessagingException {
        this.administration.restoreData("Test_JRA_17595.xml");
        this.configureAndStartSmtpServer();
        AbstractSubscriptionEmailTest.FilterConfig XSS_FILTER_XSS = new AbstractSubscriptionEmailTest.FilterConfig("XssFilter", "<b>Description</b>", "ProjectTwo", "TWO", 2, 2){

            @Override
            public Iterator getIssueIterator() {
                return new AbstractSubscriptionEmailTest.CountingIterator(1, this.getReturnedIssues());
            }
        };
        this.navigation.login("<b>xss</b>", "<b>xss</b>");
        this.subscribeToFilterAndRun(XSS_FILTER_XSS, null);
        this.navigation.login("admin", "admin");
        this.flushMailQueueAndWait(1);
        MimeMessage[] messages = this.getGreenMail().getReceivedMessages();
        MimeMessage currentMessage = EmailKit.findMessageAddressedTo("xss@example.com", messages);
        TestEmailSubscription.assertNotNull((Object)currentMessage);
        String body = EmailKit.getBody((Part)currentMessage);
        this.text.assertTextPresent(body, "&lt;b&gt;Description&lt;/b&gt;");
        this.text.assertTextSequence(body, new String[]{"<b>Subscriber</b>:", "&lt;b&gt;xss&lt;/b&gt;"});
    }
}

