/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import java.io.IOException;
import javax.mail.MessagingException;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL, Category.FIELDS})
public class TestCustomFieldNotifications
extends EmailFuncTestCase {
    private static final String ISSUE_COMMENT = "\"If it bleeds we can kill it!\"";
    private static final String SUBJECT = "[JIRATEST] (HSP-1) Dude";

    public void testCFNotifications() throws InterruptedException, MessagingException, IOException {
        this.administration.restoreData("TestCustomFieldNotifications.xml");
        this.configureAndStartSmtpServer();
        this.navigation.issue().addComment("HSP-1", ISSUE_COMMENT, null);
        this.flushMailQueueAndWait(6);
        this.assertCorrectNumberEmailsSent(6);
        this.assertEmailSent("user@example.com", SUBJECT, ISSUE_COMMENT);
        this.assertEmailSent("multiuser@example.com", SUBJECT, ISSUE_COMMENT);
        this.assertEmailSent("singlegroup@example.com", SUBJECT, ISSUE_COMMENT);
        this.assertEmailSent("multigroup@example.com", SUBJECT, ISSUE_COMMENT);
        this.assertEmailSent("admin@example.com", SUBJECT, ISSUE_COMMENT);
        this.assertEmailSent("fred@example.com", SUBJECT, ISSUE_COMMENT);
    }

    public void testCFNotificationsPublicIssue() throws InterruptedException, MessagingException, IOException {
        this.administration.restoreData("TestCustomFieldNotifications.xml");
        this.configureAndStartSmtpServer();
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(10, "");
        this.navigation.issue().addComment("HSP-1", ISSUE_COMMENT, null);
        this.flushMailQueueAndWait(7);
        this.assertCorrectNumberEmailsSent(7);
        this.assertEmailSent("user@example.com", SUBJECT, ISSUE_COMMENT);
        this.assertEmailSent("multiuser@example.com", SUBJECT, ISSUE_COMMENT);
        this.assertEmailSent("singlegroup@example.com", SUBJECT, ISSUE_COMMENT);
        this.assertEmailSent("multigroup@example.com", SUBJECT, ISSUE_COMMENT);
        this.assertEmailSent("admin@example.com", SUBJECT, ISSUE_COMMENT);
        this.assertEmailSent("fred@example.com", SUBJECT, ISSUE_COMMENT);
        this.assertEmailSent("johnson@example.com", SUBJECT, ISSUE_COMMENT);
    }

    public void testDeletedCFDoesntCauseErrors() throws InterruptedException, IOException, MessagingException {
        this.administration.restoreData("TestInvalidCustomFieldNotifications.xml");
        this.configureAndStartSmtpServer();
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(10, "");
        this.navigation.issue().addComment("HSP-1", ISSUE_COMMENT, null);
        this.flushMailQueueAndWait(3);
        this.assertCorrectNumberEmailsSent(3);
        this.assertEmailSent("admin@example.com", SUBJECT, ISSUE_COMMENT);
        this.assertEmailSent("fred@example.com", SUBJECT, ISSUE_COMMENT);
        this.assertEmailSent("johnson@example.com", SUBJECT, ISSUE_COMMENT);
    }
}

