/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.reports;

import com.atlassian.jira.functest.framework.FuncTestHelperFactory;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TableAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.REPORTS})
public class TestDeveloperWorkloadReport
extends JIRAWebTest {
    protected Navigation navigation;
    protected TableAssertions tableAssertions;

    public TestDeveloperWorkloadReport(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestDeveloperWorkloadReport.xml");
        FuncTestHelperFactory funcTestHelperFactory = new FuncTestHelperFactory(this.tester, this.getEnvironmentData());
        this.navigation = funcTestHelperFactory.getNavigation();
        this.tableAssertions = funcTestHelperFactory.getAssertions().getTableAssertions();
    }

    public void testDeveloperWorkloadReportBasic() {
        this.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:developer-workload");
        this.setFormElement("developer", "admin");
        this.submit("Next");
        this.assertBasicTestReport();
    }

    private void assertBasicTestReport() {
        this.assertTextPresent("User Workload Report");
        WebTable table = this.getTable();
        this.tableAssertions.assertTableContainsRow(table, new String[]{"homosapien", "3", "1 week, 1 day, 1 hour"});
        this.tableAssertions.assertTableContainsRow(table, new String[]{"monkey", "3", "18 minutes"});
        this.tableAssertions.assertTableContainsRow(table, new String[]{"Total", "6", "1 week, 1 day, 1 hour, 18 minutes"});
    }

    public void testPreSubtaskInclusionUrls() {
        this.activateSubTasks();
        this.enableUnassignedIssues();
        this.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:developer-workload");
        this.assertTextPresent("Sub-task Inclusion");
        this.assertTextPresent("Only including sub-tasks assigned to the selected user");
        this.assertTextPresent("Also including unassigned sub-tasks");
        this.gotoPage("/secure/ConfigureReport.jspa?developer=admin&selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports%3Adeveloper-workload&Next=Next");
        this.assertBasicTestReport();
    }

    public void testSubtaskInclusionOnlyAssignee() {
        this.activateSubTasks();
        this.enableUnassignedIssues();
        this.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:developer-workload");
        this.setFormElement("developer", "admin");
        this.selectOption("subtaskInclusion", "Only including sub-tasks assigned to the selected user");
        this.submit("Next");
        this.assertBasicTestReport();
    }

    public void testSubtaskInclusionOnlyAssigneeWithSubtasks() {
        this.activateSubTasks();
        this.enableUnassignedIssues();
        String subtask = this.addSubTaskToIssue("MKY-1", "Sub-task", "curious george is a monkey", "he is always getting into trouble", "2h");
        this.logWorkOnIssueWithComment(subtask, "1h", "work it george");
        this.navigation.issue().unassignIssue(subtask, "unassigning");
        this.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:developer-workload");
        this.setFormElement("developer", "admin");
        this.selectOption("subtaskInclusion", "Only including sub-tasks assigned to the selected user");
        this.submit("Next");
        this.assertBasicTestReport();
    }

    public void testSubtaskInclusionOnlyAssigneeWithSubtasksOnIssues() {
        this.activateSubTasks();
        this.enableUnassignedIssues();
        String subtask = this.addSubTaskToIssue("MKY-1", "Sub-task", "curious george is a monkey", "he is always getting into trouble", "2h");
        this.logWorkOnIssue(subtask, "1h");
        this.navigation.issue().unassignIssue(subtask, null);
        this.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:developer-workload");
        this.setFormElement("developer", "admin");
        this.selectOption("subtaskInclusion", "Only including sub-tasks assigned to the selected user");
        this.submit("Next");
        this.assertBasicTestReport();
    }

    public void testSubtaskInclusionAlsoUnassigned() {
        this.activateSubTasks();
        this.enableUnassignedIssues();
        String subtask = this.addSubTaskToIssue("MKY-1", "Sub-task", "curious george is a monkey", "he is always getting into trouble", "2h");
        this.logWorkOnIssue(subtask, "1h");
        this.navigation.issue().unassignIssue(subtask, null);
        this.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:developer-workload");
        this.setFormElement("developer", "admin");
        this.selectOption("subtaskInclusion", "Also including unassigned sub-tasks");
        this.submit("Next");
        this.assertTextPresent("User Workload Report");
        WebTable table = this.getTable();
        this.tableAssertions.assertTableContainsRow(table, new String[]{"homosapien", "3", "1 week, 1 day, 1 hour"});
        this.tableAssertions.assertTableContainsRow(table, new String[]{"monkey", "4", "1 hour, 18 minutes"});
        this.tableAssertions.assertTableContainsRow(table, new String[]{"Total", "7", "1 week, 1 day, 2 hours, 18 minutes"});
    }

    private WebTable getTable() {
        try {
            return this.getDialog().getResponse().getTableWithID("dwreport");
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }
}

