/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.reports;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.REPORTS})
public class TestConfigureReport
extends FuncTestCase {
    public void testConfigureReportWithInvalidReportKey() {
        this.administration.restoreBlankInstance();
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:singlelevelgroupby");
        this.tester.assertTextPresent("Report: Single Level Group By Report");
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&amp;reportKey=com.atlassian.jira.plugin.system.reports:singlelevelgroupby");
        this.assertions.getJiraFormAssertions().assertFormErrMsg("No report was specified.  The 'reportKey' parameter was empty.");
        this.tester.gotoPage("/secure/ConfigureReport.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:singlelevelgroupby");
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Report:", "Single Level Group By Report", "Filter is a required field"});
        this.tester.gotoPage("/secure/ConfigureReport.jspa?selectedProjectId=10000&amp;reportKey=com.atlassian.jira.plugin.system.reports:singlelevelgroupby");
        this.assertions.getJiraFormAssertions().assertFormErrMsg("No report was specified.  The 'reportKey' parameter was empty.");
    }

    public void testConfigureReportXSS() {
        this.administration.restoreData("TestConfigureReport.xml");
        this.tester.gotoPage("/secure/ConfigureReport.jspa?atl_token=" + this.page.getXsrfToken() + "&versionId=10000&displayUnknown=yes&subtaskInclusion='all\"/><script>alert(4452)</script>'&selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:version-workload&Next=Next");
        this.tester.assertTextNotPresent("'all\"/><script>alert(4452)</script>'");
        this.tester.assertTextPresent("&#39;all&quot;/&gt;&lt;script&gt;alert(4452)&lt;/script&gt;&#39;");
        this.tester.gotoPage("/secure/ConfigureReport.jspa?atl_token=Pi7Pim9fcC&versionId=10000&sortingOrder=least&completedFilter=all&subtaskInclusion='all\"/><script>alert(4452)</script>'&selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:time-tracking&Next=Next");
        this.tester.assertTextNotPresent("'all\"/><script>alert(4452)</script>'");
        this.tester.assertTextPresent("&#39;all&quot;/&gt;&lt;script&gt;alert(4452)&lt;/script&gt;&#39;");
    }
}

