/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.management;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.parser.dashboard.DashboardItem;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.DASHBOARDS})
public class TestSharedDashboardSearchingByAdmins
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestSharedDashboards.xml");
    }

    public void testAnAdminIsAbleToSearchForDashboardsSharedWithAGroupHeDoesNotBelongTo() {
        ImmutableList expectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10015L).name("Shared Dashboard with group jira-developers owned by developer").owner("Developer (developer)").build());
        List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().dashboards().list();
        TestSharedDashboardSearchingByAdmins.assertNotNull(actualDashboardItems);
        TestSharedDashboardSearchingByAdmins.assertTrue((actualDashboardItems.size() > 0 ? 1 : 0) != 0);
        TestSharedDashboardSearchingByAdmins.assertTrue((boolean)Iterables.all((Iterable)expectedDashboardItems, (Predicate)Predicates.in(actualDashboardItems)));
    }

    public void testAnAdminIsAbleToSearchForDashboardsSharedWithAGroupHeBelongsTo() throws Exception {
        ImmutableList expectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10014L).name("Shared Dashboard with Anyone owned by developer").owner("Developer (developer)").build(), (Object)new DashboardItem.Builder().id(10010L).name("Shared Dashboard with group jira-administrators owned by admin").owner("Administrator (admin)").build(), (Object)new DashboardItem.Builder().id(10018L).name("Shared Dashboard with group jira-users owned by fred").owner("Fred Normal (fred)").build());
        List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().dashboards().list();
        TestSharedDashboardSearchingByAdmins.assertNotNull(actualDashboardItems);
        TestSharedDashboardSearchingByAdmins.assertTrue((actualDashboardItems.size() > 0 ? 1 : 0) != 0);
        TestSharedDashboardSearchingByAdmins.assertTrue((boolean)Iterables.all((Iterable)expectedDashboardItems, (Predicate)Predicates.in(actualDashboardItems)));
    }

    public void testAnAdminIsAbleToSearchForDashboardsSharedWithARoleHeIsNotPartOf() throws Exception {
        ImmutableList expectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10016L).name("Shared Dashboard with role Developers on homosapiens owned by developer").owner("Developer (developer)").build());
        List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().dashboards().list();
        TestSharedDashboardSearchingByAdmins.assertNotNull(actualDashboardItems);
        TestSharedDashboardSearchingByAdmins.assertTrue((actualDashboardItems.size() > 0 ? 1 : 0) != 0);
        TestSharedDashboardSearchingByAdmins.assertTrue((boolean)Iterables.all((Iterable)expectedDashboardItems, (Predicate)Predicates.in(actualDashboardItems)));
    }

    public void testAnAdminIsAbleToSearchForDashboardsSharedWithARoleHeIsPartOf() throws Exception {
        ImmutableList expectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10019L).name("Shared Dashboard with role Users on homosapien owned by fred").owner("Fred Normal (fred)").build(), (Object)new DashboardItem.Builder().id(10013L).name("Shared Dashboard with all roles on Monkey owned by developer").owner("Developer (developer)").build());
        List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().dashboards().list();
        TestSharedDashboardSearchingByAdmins.assertNotNull(actualDashboardItems);
        TestSharedDashboardSearchingByAdmins.assertTrue((actualDashboardItems.size() > 0 ? 1 : 0) != 0);
        TestSharedDashboardSearchingByAdmins.assertTrue((boolean)Iterables.all((Iterable)expectedDashboardItems, (Predicate)Predicates.in(actualDashboardItems)));
    }

    public void testAnAdminIsNotAbleToSearchForDashboardsThatArePrivate() throws Exception {
        ImmutableList nonExpectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10011L).name("Private Dashboard owned by admin").owner("Administrator (admin)").build());
        List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().dashboards().list();
        TestSharedDashboardSearchingByAdmins.assertNotNull(actualDashboardItems);
        TestSharedDashboardSearchingByAdmins.assertTrue((actualDashboardItems.size() > 0 ? 1 : 0) != 0);
        TestSharedDashboardSearchingByAdmins.assertTrue((boolean)Iterables.all((Iterable)nonExpectedDashboardItems, (Predicate)Predicates.not((Predicate)Predicates.in(actualDashboardItems))));
    }
}

