/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard;

import com.atlassian.jira.functest.framework.Dashboard;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.assertions.DashboardAssertions;
import com.atlassian.jira.functest.framework.dashboard.DashboardPageInfo;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.ChainedTransformer;

@WebTest(value={Category.FUNC_TEST, Category.DASHBOARDS})
public class TestManageDashboardPages
extends FuncTestCase {
    private static final DashboardPageInfo PAGE_FRED_PUBLIC = new DashboardPageInfo(10011L, "PublicFredDashboard", "This is a dashboard page that can be seen by everyone.", false, TestSharingPermissionUtils.createPublicPermissions(), "fred", 1, DashboardPageInfo.Operation.COPY_ONLY);
    private static final DashboardPageInfo PAGE_EXISTS = new DashboardPageInfo(10012L, "Exists", null, true, TestSharingPermissionUtils.createPrivatePermissions(), "admin", 1, DashboardPageInfo.Operation.ALL);
    private static final DashboardPageInfo PAGE_ADMINNOTFAVOURITE = new DashboardPageInfo(10013L, "AdminNotFavourite", null, false, TestSharingPermissionUtils.createPublicPermissions(), "admin", 0, DashboardPageInfo.Operation.ALL);
    private static final DashboardPageInfo PAGE_ADMINFAVOURITE = new DashboardPageInfo(10014L, "AdminFavourite", null, true, TestSharingPermissionUtils.createPublicPermissions(), "admin", 1, DashboardPageInfo.Operation.ALL);
    private static final DashboardPageInfo PAGE_SYSTEM_DASHBOARD = new DashboardPageInfo(10000L, "System Dashboard", null, false, TestSharingPermissionUtils.createPublicPermissions(), null, 0, DashboardPageInfo.Operation.ALL);

    @Override
    protected void setUpTest() {
        this.administration.restoreData("BaseProfessionalPortalPage.xml");
    }

    public void testCorrectDashboardsOnTabsAdmin() {
        DashboardAssertions dashboardAssertions = this.assertions.getDashboardAssertions();
        this.navigation.dashboard().navigateToFavourites();
        dashboardAssertions.assertColumns(Arrays.asList("Name", "Owner", "Shared With", "", ""), new XPathLocator(this.tester, Dashboard.Table.FAVOURITE.toXPath()));
        dashboardAssertions.assertDashboardPages(this.makeFavourites(Arrays.asList(PAGE_EXISTS, PAGE_ADMINFAVOURITE)), Dashboard.Table.FAVOURITE);
        this.navigation.dashboard().navigateToMy();
        dashboardAssertions.assertColumns(Arrays.asList("Name", "Shared With", ""), new XPathLocator(this.tester, Dashboard.Table.OWNED.toXPath()));
        dashboardAssertions.assertDashboardPages(this.makeMy(Arrays.asList(PAGE_ADMINFAVOURITE, PAGE_ADMINNOTFAVOURITE, PAGE_EXISTS)), Dashboard.Table.OWNED);
        this.navigation.dashboard().navigateToPopular();
        dashboardAssertions.assertColumns(Arrays.asList("Name", "Owner", "Shared With", "Popularity"), new XPathLocator(this.tester, Dashboard.Table.POPULAR.toXPath()));
        dashboardAssertions.assertDashboardPages(this.makePopular(Arrays.asList(PAGE_ADMINFAVOURITE, PAGE_EXISTS, PAGE_FRED_PUBLIC, PAGE_ADMINNOTFAVOURITE, PAGE_SYSTEM_DASHBOARD)), Dashboard.Table.POPULAR);
        this.navigation.dashboard().favouriteDashboard(PAGE_ADMINNOTFAVOURITE.getId());
        PAGE_ADMINNOTFAVOURITE.setFavCount(1);
        PAGE_ADMINNOTFAVOURITE.setFavourite(true);
        this.navigation.dashboard().unFavouriteDashboard(PAGE_ADMINFAVOURITE.getId());
        PAGE_ADMINFAVOURITE.setFavourite(false);
        PAGE_ADMINFAVOURITE.setFavCount(0);
        this.navigation.dashboard().navigateToFavourites();
        dashboardAssertions.assertColumns(Arrays.asList("Name", "Owner", "Shared With", "", ""), new XPathLocator(this.tester, Dashboard.Table.FAVOURITE.toXPath()));
        dashboardAssertions.assertDashboardPages(this.makeFavourites(Arrays.asList(PAGE_EXISTS, PAGE_ADMINNOTFAVOURITE)), Dashboard.Table.FAVOURITE);
        this.navigation.dashboard().navigateToMy();
        dashboardAssertions.assertColumns(Arrays.asList("Name", "Shared With", ""), new XPathLocator(this.tester, Dashboard.Table.OWNED.toXPath()));
        dashboardAssertions.assertDashboardPages(this.makeMy(Arrays.asList(PAGE_ADMINFAVOURITE, PAGE_ADMINNOTFAVOURITE, PAGE_EXISTS)), Dashboard.Table.OWNED);
        this.navigation.dashboard().navigateToPopular();
        dashboardAssertions.assertColumns(Arrays.asList("Name", "Owner", "Shared With", "Popularity"), new XPathLocator(this.tester, Dashboard.Table.POPULAR.toXPath()));
        dashboardAssertions.assertDashboardPages(this.makePopular(Arrays.asList(PAGE_ADMINNOTFAVOURITE, PAGE_EXISTS, PAGE_FRED_PUBLIC, PAGE_ADMINFAVOURITE, PAGE_SYSTEM_DASHBOARD)), Dashboard.Table.POPULAR);
        this.navigation.dashboard().favouriteDashboard(PAGE_FRED_PUBLIC.getId());
        PAGE_FRED_PUBLIC.setFavourite(true);
        PAGE_FRED_PUBLIC.setFavCount(2);
        this.navigation.dashboard().navigateToFavourites();
        dashboardAssertions.assertColumns(Arrays.asList("Name", "Owner", "Shared With", "", ""), new XPathLocator(this.tester, Dashboard.Table.FAVOURITE.toXPath()));
        dashboardAssertions.assertDashboardPages(this.makeFavourites(Arrays.asList(PAGE_EXISTS, PAGE_ADMINNOTFAVOURITE, PAGE_FRED_PUBLIC)), Dashboard.Table.FAVOURITE);
        this.navigation.dashboard().navigateToMy();
        dashboardAssertions.assertColumns(Arrays.asList("Name", "Shared With", ""), new XPathLocator(this.tester, Dashboard.Table.OWNED.toXPath()));
        dashboardAssertions.assertDashboardPages(this.makeMy(Arrays.asList(PAGE_ADMINFAVOURITE, PAGE_ADMINNOTFAVOURITE, PAGE_EXISTS)), Dashboard.Table.OWNED);
        this.navigation.dashboard().navigateToPopular();
        dashboardAssertions.assertColumns(Arrays.asList("Name", "Owner", "Shared With", "Popularity"), new XPathLocator(this.tester, Dashboard.Table.POPULAR.toXPath()));
        dashboardAssertions.assertDashboardPages(this.makePopular(Arrays.asList(PAGE_FRED_PUBLIC, PAGE_ADMINNOTFAVOURITE, PAGE_EXISTS, PAGE_ADMINFAVOURITE, PAGE_SYSTEM_DASHBOARD)), Dashboard.Table.POPULAR);
    }

    private List<DashboardPageInfo> makeFavourites(List<DashboardPageInfo> dashboards) {
        ArrayList<DashboardPageInfo> returnInfo = new ArrayList<DashboardPageInfo>(dashboards.size());
        CollectionUtils.collect(dashboards, (Transformer)ChainedTransformer.getInstance((Transformer)new DashboardCopy(), (Transformer)new RemoveFavouriteCount()), returnInfo);
        return returnInfo;
    }

    private List<DashboardPageInfo> makeMy(List<DashboardPageInfo> dashboards) {
        ArrayList<DashboardPageInfo> returnInfo = new ArrayList<DashboardPageInfo>(dashboards.size());
        CollectionUtils.collect(dashboards, (Transformer)ChainedTransformer.getInstance((Transformer[])new Transformer[]{new DashboardCopy(), new RemoveFavouriteCount(), new RemoveAuthor()}), returnInfo);
        return returnInfo;
    }

    private List<DashboardPageInfo> makePopular(List<DashboardPageInfo> dashboards) {
        ArrayList<DashboardPageInfo> returnInfo = new ArrayList<DashboardPageInfo>(dashboards.size());
        CollectionUtils.collect(dashboards, (Transformer)ChainedTransformer.getInstance((Transformer)new DashboardCopy(), (Transformer)new RemoveOperations()), returnInfo);
        return returnInfo;
    }

    private static class RemoveOperations
    implements Transformer {
        private RemoveOperations() {
        }

        public Object transform(Object pageInfoObject) {
            DashboardPageInfo pageInfo = (DashboardPageInfo)pageInfoObject;
            return pageInfo.setOperations(null);
        }
    }

    private static class RemoveAuthor
    implements Transformer {
        private RemoveAuthor() {
        }

        public Object transform(Object pageInfoObject) {
            DashboardPageInfo pageInfo = (DashboardPageInfo)pageInfoObject;
            return pageInfo.setOwner(null);
        }
    }

    private static class RemoveFavouriteCount
    implements Transformer {
        private RemoveFavouriteCount() {
        }

        public Object transform(Object pageInfoObject) {
            DashboardPageInfo pageInfo = (DashboardPageInfo)pageInfoObject;
            return pageInfo.setFavCount(null);
        }
    }

    private static class DashboardCopy
    implements Transformer {
        private DashboardCopy() {
        }

        public Object transform(Object pageInfoObject) {
            DashboardPageInfo pageInfo = (DashboardPageInfo)pageInfoObject;
            return pageInfo.copy();
        }
    }
}

