/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.HttpUnitOptions;

@WebTest(value={Category.FUNC_TEST, Category.DASHBOARDS})
public class TestManageDashboardChooseTab
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestManageDashboardChooseTab.xml");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
    }

    @Override
    protected void tearDownTest() {
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    public void testFavouritesTabIsShownOnNewSession() throws Exception {
        this.tester.gotoPage("secure/ConfigurePortalPages!default.jspa");
        this.assertFavouritesTabIsShowing();
    }

    public void testRememberMyTab() throws Exception {
        this.tester.gotoPage("secure/ConfigurePortalPages!default.jspa");
        this.assertFavouritesTabIsShowing();
        this.navigation.clickLinkWithExactText("My");
        this.assertMyTabIsShowing();
        this.tester.clickLink("home_link");
        this.tester.gotoPage("secure/ConfigurePortalPages!default.jspa");
        this.assertMyTabIsShowing();
    }

    public void testRememberPopularTab() throws Exception {
        this.tester.gotoPage("secure/ConfigurePortalPages!default.jspa");
        this.assertFavouritesTabIsShowing();
        this.tester.clickLinkWithText("Popular");
        this.assertTabIsShowing("Popular");
        this.tester.clickLink("home_link");
        this.tester.gotoPage("secure/ConfigurePortalPages!default.jspa");
        this.assertTabIsShowing("Popular");
    }

    public void testRememberSearchTab() throws Exception {
        this.tester.gotoPage("secure/ConfigurePortalPages!default.jspa");
        this.assertFavouritesTabIsShowing();
        this.navigation.dashboard().navigateToSearch();
        this.assertTabIsShowing("Search");
        this.tester.clickLink("home_link");
        this.tester.gotoPage("secure/ConfigurePortalPages!default.jspa");
        this.assertTabIsShowing("Search");
    }

    public void testRememberFavouritesTab() throws Exception {
        this.tester.gotoPage("secure/ConfigurePortalPages!default.jspa");
        this.assertFavouritesTabIsShowing();
        this.tester.clickLinkWithText("Popular");
        this.assertTabIsShowing("Popular");
        this.tester.clickLinkWithText("Favourites");
        this.assertFavouritesTabIsShowing();
        this.tester.clickLink("home_link");
        this.tester.gotoPage("secure/ConfigurePortalPages!default.jspa");
        this.assertFavouritesTabIsShowing();
    }

    private void assertMyTabIsShowing() {
        this.assertTabIsShowing("My");
    }

    private void assertFavouritesTabIsShowing() {
        XPathLocator locator = new XPathLocator(this.tester, "//li[@class='active first']");
        this.text.assertTextPresent(locator, "Favourite");
    }

    private void assertTabIsShowing(String tabName) {
        XPathLocator locator = new XPathLocator(this.tester, "//li[@class='active']");
        this.text.assertTextPresent(locator, tabName);
    }
}

