/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.CUSTOM_FIELDS})
public class TestViewCustomFieldsIconPathHandling
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestViewCustomFieldsIconPathHandling.xml");
    }

    public void testViewCustomFields() throws Exception {
        this.navigation.gotoAdmin();
        this.navigation.gotoCustomFields();
        String contextPath = this.getEnvironmentData().getContext();
        String absoluteHttpUrl = "http://localhost:8080/jira/images/icons/bug.gif";
        String absoluteHttpsUrl = "https://localhost:8443/jira/images/icons/improvement.gif";
        String relativeUrl = "/images/icons/newfeature.gif";
        this.assertBodyContains("http://localhost:8080/jira/images/icons/bug.gif");
        this.assertBodyDoesntContain(contextPath + "http://localhost:8080/jira/images/icons/bug.gif");
        this.assertBodyContains("https://localhost:8443/jira/images/icons/improvement.gif");
        this.assertBodyDoesntContain(contextPath + "https://localhost:8443/jira/images/icons/improvement.gif");
        this.assertBodyContains(contextPath + "/images/icons/newfeature.gif");
        this.assertBodyDoesntContain(contextPath + contextPath + "/images/icons/newfeature.gif");
        this.navigation.logout();
    }

    void assertBodyContains(String url) {
        String srcEqualsUrl;
        String body = this.tester.getDialog().getResponseText();
        int index = body.indexOf(srcEqualsUrl = this.makeIntoSrcAttribute(url));
        if (-1 == index) {
            TestViewCustomFieldsIconPathHandling.fail((String)("The body of the view custom fields page should contain \"" + srcEqualsUrl + "\" but doesnt...\nbody:" + body));
        }
    }

    void assertBodyDoesntContain(String url) {
        String srcEqualsUrl;
        String contextPath = this.getEnvironmentData().getContext();
        if (0 == contextPath.length()) {
            return;
        }
        String body = this.tester.getDialog().getResponseText();
        int index = body.indexOf(srcEqualsUrl = this.makeIntoSrcAttribute(url));
        if (-1 != index) {
            TestViewCustomFieldsIconPathHandling.fail((String)("The body of the view custom fields page contains \"" + srcEqualsUrl + "\" when it shouldnt...\nbody:" + body));
        }
    }

    String makeIntoSrcAttribute(String url) {
        return "src=\"" + url + "\"";
    }
}

