/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.CUSTOM_FIELDS})
public class TestSelectCustomFieldOptions
extends JIRAWebTest {
    private static final String CUSTOM_FIELD_ID = "10007";
    private static final String OPTION_00 = "10022";
    private static final String OPTION_01 = "10023";
    private static final String OPTION_02 = "10024";

    public TestSelectCustomFieldOptions(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.administration.restoreData("TestSelectCustomFieldOptions.xml");
    }

    public void testEditOptions() throws SAXException {
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Honda");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Kawasaki");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Yamaha");
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10007");
        this.assertTextPresent("Honda");
        this.assertTextPresent("Kawasaki");
        this.assertTextPresent("Yamaha");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Fiat");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Lambretta");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Vespa");
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10007");
        this.assertTextPresent("Fiat");
        this.assertTextPresent("Lambretta");
        this.assertTextPresent("Vespa");
    }

    public void testDefaultShowsUpdatedOption() throws SAXException {
        this.administration.customFields().setDefaultValue(CUSTOM_FIELD_ID, OPTION_00);
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10007");
        this.locator.id("customfield_10007-value-default").getText().contains("option 00");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Honda");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Kawasaki");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Yamaha");
        this.locator.id("customfield_10007-value-default").getText().contains("Honda");
    }

    public void testDisable() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10007");
        this.assertTextSequence(new String[]{"option 00", "(disabled)"});
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10007");
        this.assertTextNotPresent("(disabled)");
    }

    public void testSearchNewValues() throws SAXException {
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Honda");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Kawasaki");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Yamaha");
        this.locator.id("customfield_10007-value-default").getText().contains("Honda");
        this.administration.reIndex();
        this.createSearchAndAssertIssues("SelectList = Honda ORDER BY key ASC", "HSP-11");
        this.createSearchAndAssertIssues("SelectList = Kawasaki ORDER BY key ASC", "HSP-10", "HSP-12");
    }

    public void testDisabledNotValidForCreate() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.assertOptionsEqual("customfield_10007", new String[]{"None", "option 01", "option 02"});
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.assertOptionsEqual("customfield_10007", new String[]{"None", "option 00", "option 01", "option 02"});
    }

    public void testDisabledNotValidForEdit() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().gotoEditIssue("HSP-10");
        this.tester.assertOptionsEqual("customfield_10007", new String[]{"None", "option 01", "option 02"});
        this.navigation.issue().gotoEditIssue("HSP-11");
        this.tester.assertOptionsEqual("customfield_10007", new String[]{"None", "option 00", "option 01", "option 02"});
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().gotoEditIssue("HSP-10");
        this.tester.assertOptionsEqual("customfield_10007", new String[]{"None", "option 00", "option 01", "option 02"});
    }

    public void testDisabledValidForSearch() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issueNavigator().gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.assertOptionsEqual("customfield_10007", new String[]{"Any", "option 00", "option 01", "option 02"});
    }

    private void createSearchAndAssertIssues(String jqlQuery, String ... keys) {
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(keys);
    }
}

