/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.CUSTOM_FIELDS})
public class TestRadioSelectCustomFieldOptions
extends JIRAWebTest {
    private static final String CUSTOM_FIELD_ID = "10006";
    private static final String CUSTOMFIELD_LONG_ID = "customfield_10006";
    private static final String OPTION_00 = "10019";
    private static final String OPTION_01 = "10020";
    private static final String OPTION_02 = "10021";

    public TestRadioSelectCustomFieldOptions(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.administration.restoreData("TestSelectCustomFieldOptions.xml");
    }

    public void testEditOptions() throws SAXException {
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Honda");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Kawasaki");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Yamaha");
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10006");
        this.assertTextPresent("Honda");
        this.assertTextPresent("Kawasaki");
        this.assertTextPresent("Yamaha");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Fiat");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Lambretta");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Vespa");
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10006");
        this.assertTextPresent("Fiat");
        this.assertTextPresent("Lambretta");
        this.assertTextPresent("Vespa");
    }

    public void testDefaultShowsUpdatedOption() throws SAXException {
        this.administration.customFields().setDefaultValue(CUSTOM_FIELD_ID, OPTION_00);
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10006");
        this.locator.id("customfield_10006-value-default").getText().contains("option 00");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Honda");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Kawasaki");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Yamaha");
        this.locator.id("customfield_10006-value-default").getText().contains("Honda");
    }

    public void testDisable() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10006");
        this.assertTextSequence(new String[]{"option 00", "(disabled)"});
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10006");
        this.assertTextNotPresent("(disabled)");
    }

    public void testSearchNewValues() throws SAXException {
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Honda");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Kawasaki");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Yamaha");
        this.locator.id("customfield_10006-value-default").getText().contains("Honda");
        this.administration.reIndex();
        this.createSearchAndAssertIssues("RadioButtonsField = Honda ORDER BY key ASC", "HSP-11");
        this.createSearchAndAssertIssues("RadioButtonsField = Kawasaki ORDER BY key ASC", "HSP-10");
    }

    public void testDisabledNotValidForCreate() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        TestRadioSelectCustomFieldOptions.assertTrue((!this.locator.id("customfield_10006-1").exists() ? 1 : 0) != 0);
        TestRadioSelectCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10006-2").exists());
        TestRadioSelectCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10006-3").exists());
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        TestRadioSelectCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10006-1").exists());
        TestRadioSelectCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10006-2").exists());
        TestRadioSelectCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10006-3").exists());
    }

    public void testDisabledNotValidForEdit() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().gotoEditIssue("HSP-10");
        TestRadioSelectCustomFieldOptions.assertTrue((!this.locator.id("customfield_10006-1").exists() ? 1 : 0) != 0);
        TestRadioSelectCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10006-2").exists());
        TestRadioSelectCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10006-3").exists());
        this.navigation.issue().gotoEditIssue("HSP-11");
        TestRadioSelectCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10006-1").exists());
        TestRadioSelectCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10006-2").exists());
        TestRadioSelectCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10006-3").exists());
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().gotoEditIssue("HSP-10");
        TestRadioSelectCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10006-1").exists());
        TestRadioSelectCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10006-2").exists());
        TestRadioSelectCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10006-3").exists());
    }

    public void testDisabledValidForSearch() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issueNavigator().gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        TestRadioSelectCustomFieldOptions.assertTrue((boolean)this.locator.id("searcher-customfield_10006_1").exists());
        TestRadioSelectCustomFieldOptions.assertTrue((boolean)this.locator.id("searcher-customfield_10006_2").exists());
        TestRadioSelectCustomFieldOptions.assertTrue((boolean)this.locator.id("searcher-customfield_10006_3").exists());
    }

    private void createSearchAndAssertIssues(String jqlQuery, String ... keys) {
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(keys);
    }
}

