/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HttpUnitOptions;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.CUSTOM_FIELDS})
public class TestMultiGroupSelector
extends JIRAWebTest {
    public static final String MULTGROUP_PICKER_CF_NAME = "mypickerofmultigroups";
    public static final String INVALID_GROUP_NAME = "invalid_group_name";
    public static final String ISSUE_SUMMARY = "This is my summary";
    private String multigroupPickerId = null;

    public TestMultiGroupSelector(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.multigroupPickerId = this.addCustomField("multigrouppicker", "global", MULTGROUP_PICKER_CF_NAME, null, null, null, null);
        this.addFieldToFieldScreen("Default Screen", MULTGROUP_PICKER_CF_NAME);
    }

    public void testCreateIssueWithMultiGroupPicker() throws SAXException {
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.setFormElement("summary", ISSUE_SUMMARY);
        this.assertLinkPresent("customfield_" + this.multigroupPickerId + "-trigger");
        this.setFormElement("customfield_" + this.multigroupPickerId, "invalid_group_name, invalid_group_name");
        this.submit("Create");
        this.assertTextPresent("Could not find group names: invalid_group_name, invalid_group_name");
        this.setFormElement("customfield_" + this.multigroupPickerId, "jira-users, jira-developers");
        this.submit("Create");
        this.assertTextPresent(ISSUE_SUMMARY);
        this.assertTextPresent(MULTGROUP_PICKER_CF_NAME);
        this.assertLinkPresentWithText("jira-users");
        this.assertLinkPresentWithText("jira-developers");
    }

    public void testIssueNavWithMultiGroupPicker() {
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.setWorkingForm("issue-create");
        this.setFormElement("summary", ISSUE_SUMMARY);
        this.setFormElement("customfield_" + this.multigroupPickerId, "jira-users, jira-developers");
        this.submit("Create");
        this.clickLink("find_link");
        this.assertTextPresent(MULTGROUP_PICKER_CF_NAME);
        this.assertLinkPresent("searcher-customfield_" + this.multigroupPickerId + "-trigger");
        this.setFormElement("customfield_" + this.multigroupPickerId, INVALID_GROUP_NAME);
        this.submit("show");
        this.assertions.getTextAssertions().assertTextPresentHtmlEncoded("Could not find group with name 'invalid_group_name'");
        this.assertTextPresent("There are errors with your search query on the left, please correct them before continuing.");
        this.setFormElement("customfield_" + this.multigroupPickerId, "jira-users");
        this.submit("show");
        this.assertTextPresent("HSP-1");
        this.setFormElement("customfield_" + this.multigroupPickerId, "jira-developers");
        this.submit("show");
        this.assertTextPresent("HSP-1");
    }
}

