/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.CUSTOM_FIELDS})
public class TestMultiCheckboxCustomFieldOptions
extends JIRAWebTest {
    private static final String CUSTOM_FIELD_ID = "10003";
    private static final String CUSTOMFIELD_LONG_ID = "customfield_10003";
    private static final String OPTION_00 = "10014";
    private static final String OPTION_01 = "10011";
    private static final String OPTION_02 = "10012";
    private static final String OPTION_03 = "10013";

    public TestMultiCheckboxCustomFieldOptions(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.administration.restoreData("TestSelectCustomFieldOptions.xml");
    }

    public void testEditOptions() throws SAXException {
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Honda");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Kawasaki");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Yamaha");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_03, "Suzuki");
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10003");
        this.assertTextPresent("Honda");
        this.assertTextPresent("Kawasaki");
        this.assertTextPresent("Yamaha");
        this.assertTextPresent("Suzuki");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Fiat");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Lambretta");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Vespa");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_03, "Aprilia");
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10003");
        this.assertTextPresent("Fiat");
        this.assertTextPresent("Lambretta");
        this.assertTextPresent("Vespa");
        this.assertTextPresent("Aprilia");
    }

    public void testDefaultShowsUpdatedOption() throws SAXException {
        this.administration.customFields().setDefaultValue(CUSTOM_FIELD_ID, OPTION_00);
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10003");
        this.locator.id("customfield_10003-value-default").getText().contains("option 00");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Fiat");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Lambretta");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Vespa");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_03, "Aprilia");
        this.locator.id("customfield_10003-value-default").getText().contains("Honda");
    }

    public void testDisable() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10003");
        this.assertTextSequence(new String[]{"option 00", "(disabled)"});
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10003");
        this.assertTextNotPresent("(disabled)");
    }

    public void testSearchNewValues() throws SAXException {
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Honda");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Kawasaki");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Yamaha");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_03, "Suzuki");
        this.locator.id("customfield_10003-value-default").getText().contains("Honda");
        this.administration.reIndex();
        this.createSearchAndAssertIssues("MultiCheckboxesField = Honda ORDER BY key ASC", "HSP-11", "HSP-12");
        this.createSearchAndAssertIssues("MultiCheckboxesField = Kawasaki ORDER BY key ASC", "HSP-10", "HSP-12");
    }

    public void testDisabledNotValidForCreate() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        TestMultiCheckboxCustomFieldOptions.assertTrue((!this.locator.id("customfield_10003-1").exists() ? 1 : 0) != 0);
        TestMultiCheckboxCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10003-2").exists());
        TestMultiCheckboxCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10003-3").exists());
        TestMultiCheckboxCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10003-4").exists());
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        TestMultiCheckboxCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10003-1").exists());
        TestMultiCheckboxCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10003-2").exists());
        TestMultiCheckboxCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10003-3").exists());
        TestMultiCheckboxCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10003-4").exists());
    }

    public void testDisabledNotValidForEdit() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_01);
        this.navigation.issue().gotoEditIssue("HSP-11");
        TestMultiCheckboxCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10003-1").exists());
        TestMultiCheckboxCustomFieldOptions.assertTrue((!this.locator.id("customfield_10003-2").exists() ? 1 : 0) != 0);
        TestMultiCheckboxCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10003-3").exists());
        TestMultiCheckboxCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10003-4").exists());
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().gotoEditIssue("HSP-11");
        TestMultiCheckboxCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10003-1").exists());
        TestMultiCheckboxCustomFieldOptions.assertTrue((!this.locator.id("customfield_10003-2").exists() ? 1 : 0) != 0);
        TestMultiCheckboxCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10003-3").exists());
        TestMultiCheckboxCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10003-4").exists());
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_01);
        this.navigation.issue().gotoEditIssue("HSP-11");
        TestMultiCheckboxCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10003-1").exists());
        TestMultiCheckboxCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10003-2").exists());
        TestMultiCheckboxCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10003-3").exists());
        TestMultiCheckboxCustomFieldOptions.assertTrue((boolean)this.locator.id("customfield_10003-4").exists());
    }

    public void testDisabledValidForSearch() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issueNavigator().gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        TestMultiCheckboxCustomFieldOptions.assertTrue((boolean)this.locator.id("searcher-customfield_10003-1").exists());
        TestMultiCheckboxCustomFieldOptions.assertTrue((boolean)this.locator.id("searcher-customfield_10003-2").exists());
        TestMultiCheckboxCustomFieldOptions.assertTrue((boolean)this.locator.id("searcher-customfield_10003-3").exists());
        TestMultiCheckboxCustomFieldOptions.assertTrue((boolean)this.locator.id("searcher-customfield_10003-4").exists());
    }

    private void createSearchAndAssertIssues(String jqlQuery, String ... keys) {
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(keys);
    }
}

