/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.CUSTOM_FIELDS})
public class TestCustomFieldMultiUserPicker
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }

    public void testCreateAndSetDefaultValue() {
        this.navigation.gotoAdminSection("view_custom_fields");
        this.tester.clickLink("add_custom_fields");
        this.tester.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker");
        this.tester.submit("nextBtn");
        this.tester.setFormElement("fieldName", "Developers");
        this.tester.submit("nextBtn");
        this.tester.checkCheckbox("associatedScreens", "1");
        this.tester.submit("Update");
        this.tester.assertTextPresent("View Custom Fields");
        this.text.assertTextPresent(this.locator.id("custom-fields-customfield_10000-name"), "Developers");
        this.text.assertTextPresent(this.locator.id("custom-fields-customfield_10000-type"), "Multi User Picker");
        this.tester.clickLink("config_customfield_10000");
        this.tester.clickLink("customfield_10000-edit-default");
        this.tester.submit("Set Default");
        this.tester.assertTextPresent("Default Configuration Scheme for Developers");
        this.tester.assertTextNotPresent("fred");
        this.tester.clickLink("customfield_10000-edit-default");
        this.tester.assertFormElementEquals("customfield_10000", "");
        this.tester.setFormElement("customfield_10000", "fred");
        this.tester.submit("Set Default");
        this.tester.assertTextPresent("Default Configuration Scheme for Developers");
        this.tester.assertTextPresent("Fred Normal");
        this.tester.clickLink("customfield_10000-edit-default");
        this.tester.assertFormElementEquals("customfield_10000", "fred");
        this.tester.setFormElement("customfield_10000", "fred, admin");
        this.tester.submit("Set Default");
        this.text.assertTextPresent(this.locator.xpath("//*[@id='configscheme10010']//*[@class='formtitle']"), "Default Configuration Scheme for Developers");
        this.text.assertTextSequence(this.locator.id("customfield_10000-field"), "Administrator", "Fred Normal");
        this.tester.clickLink("customfield_10000-edit-default");
        this.tester.assertFormElementEquals("customfield_10000", "admin, fred");
        this.tester.setFormElement("customfield_10000", "admin");
        this.tester.submit("Set Default");
        this.tester.assertTextNotPresent("Fred Normal");
        this.tester.assertTextPresent("Default Configuration Scheme for Developers");
        this.tester.clickLink("customfield_10000-edit-default");
        this.tester.assertFormElementEquals("customfield_10000", "admin");
        this.tester.setFormElement("customfield_10000", "");
        this.tester.submit("Set Default");
        this.tester.assertTextNotPresent("Fred Normal");
        this.tester.assertTextPresent("Default Configuration Scheme for Developers");
        this.tester.clickLink("customfield_10000-edit-default");
        this.tester.assertFormElementEquals("customfield_10000", "");
    }
}

