/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.comment;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.COMMENTS})
public class TestEditComment
extends JIRAWebTest {
    private static final String ISSUE_KEY = "HSP-1";
    private static final String COMMENT_ID_ADMIN = "10031";
    private static final String COMMENT_ID_FRED = "10040";
    private static final String COMMENT_ID_ANON = "10041";
    private static final String OLD_COMMENT_ANON = "Just a random comment by noname.";
    private static final String OLD_COMMENT_ADMIN = "I&#39;m a hero!";
    private static final String OLD_COMMENT_FRED = "Australia is an island continent.";
    private static final String NEW_COMMENT_ANON = "Firefox rocks!";
    private static final String NEW_COMMENT_ADMIN = "Thunderbird is cool!";
    private static final String NEW_COMMENT_FRED = "Linux just works!";
    private static final String SAVE_BUTTON_NAME = "Save";

    public TestEditComment(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestEditComment.xml");
    }

    public void testSimpleCommentEdit() {
        this.gotoIssue(ISSUE_KEY);
        this.clickLink("edit_comment_10031");
        this.setWorkingForm("comment-edit");
        this.assertTextPresent(OLD_COMMENT_ADMIN);
        this.setFormElement("comment", "new func test value");
        this.submit(SAVE_BUTTON_NAME);
        this.assertTextPresent("Edit comment issue summary for our test");
        this.assertTextPresent("new func test value");
    }

    public void testSimpleErrorNoBodyProvided() {
        this.gotoIssue(ISSUE_KEY);
        this.clickLink("edit_comment_10031");
        this.setWorkingForm("comment-edit");
        this.assertTextPresent(OLD_COMMENT_ADMIN);
        this.setFormElement("comment", "");
        this.submit(SAVE_BUTTON_NAME);
        this.tester.assertFormElementPresent("comment");
        this.assertTextPresent("Comment body can not be empty!");
        this.assertFormElementPresent(SAVE_BUTTON_NAME);
    }

    public void testCommentEditPermissionGroup() throws SAXException {
        String COMMENT1 = "This comment is updated";
        this.gotoIssue(ISSUE_KEY);
        this.clickLink("edit_comment_10031");
        this.setWorkingForm("comment-edit");
        this.assertTextPresent(OLD_COMMENT_ADMIN);
        this.setFormElement("comment", "This comment is updated");
        this.selectOption("commentLevel", "jira-developers");
        this.submit(SAVE_BUTTON_NAME);
        this.assertTextPresent("Edit comment issue summary for our test");
        this.assertTextPresent("This comment is updated");
        this.assertTextPresent("Restricted to <span class=redText>jira-developers</span>");
        this.clickLink("edit_comment_10031");
        this.assertOptionEquals("commentLevel", "jira-developers");
    }

    public void testCommentEditPermissionRole() throws SAXException {
        String COMMENT1 = "This comment is updated";
        this.gotoIssue(ISSUE_KEY);
        this.clickLink("edit_comment_10031");
        this.setWorkingForm("comment-edit");
        this.assertTextPresent(OLD_COMMENT_ADMIN);
        this.setFormElement("comment", "This comment is updated");
        this.selectOption("commentLevel", "Developers");
        this.submit(SAVE_BUTTON_NAME);
        this.assertTextPresent("Edit comment issue summary for our test");
        this.assertTextPresent("This comment is updated");
        this.assertTextPresent("Restricted to <span class=redText>Developers</span>");
        this.clickLink("edit_comment_10031");
        this.assertOptionEquals("commentLevel", "Developers");
    }

    public void testCommentEditRemovePermission() throws SAXException {
        String COMMENT1 = "This comment is updated";
        this.gotoIssue(ISSUE_KEY);
        this.clickLink("edit_comment_10031");
        this.setWorkingForm("comment-edit");
        this.assertTextPresent(OLD_COMMENT_ADMIN);
        this.setFormElement("comment", "This comment is updated");
        this.selectOption("commentLevel", "All Users");
        this.submit(SAVE_BUTTON_NAME);
        this.assertTextPresent("Edit comment issue summary for our test");
        this.assertTextPresent("This comment is updated");
        this.assertTextNotPresent("Restricted to <span class=redText>Administrators</span>");
    }

    public void testCommentEditCommentNotEditedBefore() throws SAXException {
        this.gotoIssue(ISSUE_KEY);
        this.clickLink("edit_comment_10031");
        this.assertTextPresent(OLD_COMMENT_ADMIN);
        this.assertTextNotPresent("Edited by");
        this.assertTextNotPresent("Edited on");
    }

    public void testCommentEditCommentIsSearchable() throws SAXException {
        this.gotoIssue(ISSUE_KEY);
        this.clickLink("edit_comment_10031");
        this.setWorkingForm("comment-edit");
        this.assertTextPresent(OLD_COMMENT_ADMIN);
        String STRANGE_COMMENT = "STRANGE COMMENT";
        this.setFormElement("comment", "STRANGE COMMENT");
        this.selectOption("commentLevel", "All Users");
        this.submit(SAVE_BUTTON_NAME);
        this.clickLink("find_link");
        this.uncheckCheckbox("summary");
        this.uncheckCheckbox("description");
        this.checkCheckbox("body", "true");
        this.setFormElement("query", "STRANGE COMMENT");
        this.submit("show");
        this.assertTextPresent("Edit comment issue summary for our test");
    }

    public void testAnonymousCanCreateComment() {
        this.addCreateCommentPermissionToAnonymous();
        this.logout();
        this.gotoPage("/secure/Dashboard.jspa");
        this.gotoIssue(ISSUE_KEY);
        String newComment = "Can I add a comment?";
        this.setFormElement("comment", "Can I add a comment?");
        this.submit();
        this.assertTextPresent("Can I add a comment?");
    }

    public void testAnonymousCanSeeAllComments() {
        this.logout();
        this.gotoPage("/secure/Dashboard.jspa");
        this.gotoIssue(ISSUE_KEY);
        this.assertTextPresent(OLD_COMMENT_ANON);
        this.assertTextPresent(OLD_COMMENT_ADMIN);
        this.assertTextPresent(OLD_COMMENT_FRED);
    }

    public void testNoEditPermissions() {
        this.removeEditAllCommentsPermission("jira-administrators");
        this.removeEditAllCommentsPermission("");
        this.removeEditOwnCommentsPermission("jira-users");
        this.removeEditOwnCommentsPermission("");
        this.assertAdminCanEditAnonymousComment(false);
        this.assertAdminCanEditAdminsComment(false);
        this.assertAdminCanEditFredsComment(false);
        this.logout();
        this.assertAnonymousCanEditAnonymousComment(false);
        this.assertAnonymousCanEditAdminsComment(false);
        this.assertAnonymousCanEditFredsComment(false);
    }

    public void testEditOwnPermissions() {
        this.removeEditAllCommentsPermission("jira-administrators");
        this.removeEditAllCommentsPermission("");
        this.removeEditOwnCommentsPermission("jira-users");
        this.assertAdminCanEditAnonymousComment(false);
        this.assertAdminCanEditAdminsComment(true);
        this.assertAdminCanEditFredsComment(false);
        this.logout();
        this.assertAnonymousCanEditAnonymousComment(false);
        this.assertAnonymousCanEditAdminsComment(false);
        this.assertAnonymousCanEditFredsComment(false);
    }

    public void testEditAllPermissions() {
        this.removeEditAllCommentsPermission("jira-administrators");
        this.removeEditOwnCommentsPermission("jira-users");
        this.removeEditOwnCommentsPermission("");
        this.assertAdminCanEditAnonymousComment(true);
        this.assertAdminCanEditAdminsComment(true);
        this.assertAdminCanEditFredsComment(true);
        this.logout();
        this.assertAnonymousCanEditAnonymousComment(true);
        this.assertAnonymousCanEditAdminsComment(true);
        this.assertAnonymousCanEditFredsComment(true);
    }

    public void testErrorCases() {
        this.gotoPage("/secure/EditComment!default.jspa?id=123&commentId=10041");
        this.assertTextPresent("The issue no longer exists.");
        this.assertFormElementNotPresent(SAVE_BUTTON_NAME);
        String INVALID_COMMENT_ID = "123";
        this.gotoPage("/secure/EditComment!default.jspa?id=10000&commentId=123");
        this.assertTextSequence(new String[]{"Edit Comment", "You do not have the permission for this comment."});
        this.removeEditAllCommentsPermission("jira-administrators");
        this.removeEditAllCommentsPermission("");
        this.removeEditOwnCommentsPermission("jira-users");
        this.removeEditOwnCommentsPermission("");
        this.gotoPage("/secure/EditComment!default.jspa?id=10000&commentId=10041");
        this.assertTextSequence(new String[]{"Edit Comment", "You do not have the permission for this comment."});
    }

    private void assertAdminCanEditAnonymousComment(boolean expected) {
        this.verifyUserCanEditComment(expected, COMMENT_ID_ANON, NEW_COMMENT_ANON, true);
    }

    private void assertAdminCanEditAdminsComment(boolean expected) {
        this.verifyUserCanEditComment(expected, COMMENT_ID_ADMIN, NEW_COMMENT_ADMIN, true);
    }

    private void assertAdminCanEditFredsComment(boolean expected) {
        this.verifyUserCanEditComment(expected, COMMENT_ID_FRED, NEW_COMMENT_FRED, true);
    }

    private void assertAnonymousCanEditAnonymousComment(boolean expected) {
        this.verifyUserCanEditComment(expected, COMMENT_ID_ANON, NEW_COMMENT_ANON, false);
    }

    private void assertAnonymousCanEditAdminsComment(boolean expected) {
        this.verifyUserCanEditComment(expected, COMMENT_ID_ADMIN, NEW_COMMENT_ADMIN, false);
    }

    private void assertAnonymousCanEditFredsComment(boolean expected) {
        this.verifyUserCanEditComment(expected, COMMENT_ID_FRED, NEW_COMMENT_FRED, false);
    }

    private void verifyUserCanEditComment(boolean expected, String commentId, String commentBody, boolean userExists) {
        this.gotoPage("/secure/Dashboard.jspa");
        this.gotoIssue(ISSUE_KEY);
        if (expected) {
            this.verifyEditLinkExistsAndEdit(commentId, commentBody, userExists);
        } else {
            this.verifyEditLinkDoesNotExist(commentId);
            this.verifyEditCommentPagePrintsError(commentId);
            this.verifyCommentUpdatePrintsError(commentId);
        }
    }

    private void verifyEditLinkExistsAndEdit(String commentId, String newComment, boolean userExists) {
        String commentLink = "edit_comment_" + commentId;
        this.assertLinkPresent(commentLink);
        this.clickLink(commentLink);
        this.setWorkingForm("comment-edit");
        this.setFormElement("comment", newComment);
        if (userExists) {
            this.selectOption("commentLevel", "All Users");
        }
        this.submit(SAVE_BUTTON_NAME);
        this.assertTextPresent("Edit comment issue summary for our test");
        this.assertTextPresent(newComment);
    }

    private void verifyEditLinkDoesNotExist(String commentId) {
        this.gotoIssue(ISSUE_KEY);
        String commentLink = "edit_comment_" + commentId;
        this.assertLinkNotPresent(commentLink);
    }

    private void verifyEditCommentPagePrintsError(String commentId) {
        this.gotoPage(this.page.addXsrfToken("/secure/EditComment!default.jspa?id=10000&commentId=" + commentId));
        this.assertTextSequence(new String[]{"Edit Comment", "You do not have the permission for this comment."});
    }

    private void verifyCommentUpdatePrintsError(String commentId) {
        this.gotoPage(this.page.addXsrfToken("/secure/EditComment.jspa?id=10000&commentId=" + commentId + "&comment=WooHoo"));
        this.assertTextSequence(new String[]{"Edit Comment", "You do not have the permission for this comment."});
    }

    private void removeEditOwnCommentsPermission(String group) {
        this.goToDefaultPermissionScheme();
        this.clickLink("del_perm_35_" + group);
        this.submit("Delete");
    }

    private void removeEditAllCommentsPermission(String group) {
        this.goToDefaultPermissionScheme();
        this.clickLink("del_perm_34_" + group);
        this.submit("Delete");
    }

    private void addCreateCommentPermissionToAnonymous() {
        this.goToDefaultPermissionScheme();
        this.clickLink("add_perm_15");
        this.checkCheckbox("type", "group");
        this.submit(" Add ");
    }

    private void goToDefaultPermissionScheme() {
        this.navigation.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLinkWithText("Default Permission Scheme");
    }
}

