/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.comment;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.COMMENTS})
public class TestCommentVisibility
extends FuncTestCase {
    private static final String ANYONE_GROUP_VALUE = "";

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestCommentVisibility.xml");
    }

    public void testCommentVisibilitySwitchOnViewIssue() {
        this.administration.generalConfiguration().setCommentVisibility(GeneralConfiguration.CommentVisibility.GROUPS_PROJECT_ROLES);
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.assertFormElementPresent("commentLevel");
        this.tester.assertOptionsEqual("commentLevel", new String[]{"All Users", "Administrators", "Developers", "Users", "jira-administrators", "jira-developers", "jira-users"});
        this.administration.generalConfiguration().setCommentVisibility(GeneralConfiguration.CommentVisibility.PROJECT_ROLES);
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.assertOptionsEqual("commentLevel", new String[]{"All Users", "Administrators", "Developers", "Users"});
    }

    public void testAnonymousCommenterAllowed() {
        this.administration.generalConfiguration().setCommentVisibility(GeneralConfiguration.CommentVisibility.GROUPS_PROJECT_ROLES);
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(10, ANYONE_GROUP_VALUE);
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(15, ANYONE_GROUP_VALUE);
        this.navigation.logout();
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.assertFormElementPresent("comment");
        this.tester.assertFormElementNotPresent("commentLevel");
    }

    public void testLogWorkReflectsCommentVisibilitySwitch() {
        this.administration.timeTracking().enable(TimeTracking.Mode.MODERN);
        this.administration.generalConfiguration().setCommentVisibility(GeneralConfiguration.CommentVisibility.GROUPS_PROJECT_ROLES);
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLink("log-work");
        this.tester.assertFormElementPresent("commentLevel");
        this.tester.assertOptionsEqual("commentLevel", new String[]{"All Users", "Administrators", "Developers", "Users", "jira-administrators", "jira-developers", "jira-users"});
        this.administration.generalConfiguration().setCommentVisibility(GeneralConfiguration.CommentVisibility.PROJECT_ROLES);
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLink("log-work");
        this.tester.assertOptionsEqual("commentLevel", new String[]{"All Users", "Administrators", "Developers", "Users"});
    }

    public void testCommentSearchNoLevels() {
        String[] accounts;
        this.navigation.issue().addComment("HSP-1", "comment with animal kangaroo");
        this.navigation.issue().addComment("MKY-1", "comment with animal tasmanian devil");
        for (String usernameAndPassword : accounts = new String[]{"fred", "admin"}) {
            this.navigation.login(usernameAndPassword, usernameAndPassword);
            this.assertCommentSearchResults("visible", null, new String[0], new String[]{"HSP-1", "MKY-1"});
            this.assertCommentSearchResults("animal", null, new String[]{"HSP-1", "MKY-1"}, new String[0]);
            this.assertCommentSearchResults("kangaroo", null, new String[]{"HSP-1"}, new String[]{"MKY-1"});
        }
    }

    public void testCommentSearchResultsWithLevels() {
        this.navigation.issue().addComment("HSP-1", "comment visible to haxors", "Developers");
        this.navigation.issue().addComment("MKY-1", "comment visible to haxors", "Developers");
        String[] ALL_PROJECTS = null;
        String[] PROJECT_MONKEY = new String[]{"monkey"};
        String[] PROJECT_HOMOSAPIEN = new String[]{"homosapien"};
        String[] PROJECTS_BOTH = new String[]{"monkey", "homosapien"};
        String[] ISSUE_MONKEY = new String[]{"MKY-1"};
        String[] ISSUE_HOMOSAPIEN = new String[]{"HSP-1"};
        String[] ISSUES_BOTH = new String[]{"MKY-1", "HSP-1"};
        String[] ISSUES_NONE = new String[]{};
        this.navigation.login("fred", "fred");
        this.assertCommentSearchResults("visible", ALL_PROJECTS, ISSUE_MONKEY, ISSUE_HOMOSAPIEN);
        this.assertCommentSearchResults("visible", PROJECT_MONKEY, ISSUE_MONKEY, ISSUE_HOMOSAPIEN);
        this.assertCommentSearchResults("visible", PROJECT_HOMOSAPIEN, ISSUES_NONE, ISSUES_BOTH);
        this.assertCommentSearchResults("visible", PROJECTS_BOTH, ISSUE_MONKEY, ISSUE_HOMOSAPIEN);
        this.assertCommentSearchResults("haxors", PROJECTS_BOTH, ISSUE_MONKEY, ISSUE_HOMOSAPIEN);
        this.navigation.login("admin", "admin");
        this.assertCommentSearchResults("visible", ALL_PROJECTS, ISSUES_BOTH, ISSUES_NONE);
        this.assertCommentSearchResults("visible", PROJECT_MONKEY, ISSUE_MONKEY, ISSUE_HOMOSAPIEN);
        this.assertCommentSearchResults("visible", PROJECT_HOMOSAPIEN, ISSUE_HOMOSAPIEN, ISSUE_MONKEY);
        this.assertCommentSearchResults("visible", PROJECTS_BOTH, ISSUES_BOTH, ISSUES_NONE);
        this.assertCommentSearchResults("haxors", PROJECTS_BOTH, ISSUES_BOTH, ISSUES_NONE);
    }

    private void assertCommentSearchResults(String commentBody, String[] projects, String[] expectedPresent, String[] expectedAbsent) {
        this.navigation.issueNavigator().gotoNavigator();
        this.tester.getDialog().setWorkingForm("issue-filter");
        if (projects == null || projects.length == 0) {
            this.tester.selectOption("pid", "All projects");
        } else {
            for (String project : projects) {
                String value = this.tester.getDialog().getValueForOption("pid", project);
                this.tester.checkCheckbox("pid", value);
            }
        }
        this.tester.checkCheckbox("body", "true");
        this.tester.setFormElement("query", commentBody);
        this.tester.submit("show");
        for (String anExpectedPresent : expectedPresent) {
            this.text.assertTextPresent(this.locator.page(), anExpectedPresent);
        }
        for (String anExpectedAbsent : expectedAbsent) {
            this.text.assertTextNotPresent(this.locator.page(), anExpectedAbsent);
        }
    }
}

