/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.matcher;

import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.internal.matchers.TypeSafeMatcher;

public class HasErrorMessage
extends TypeSafeMatcher<Response> {
    private final Matcher<String> errorMessageMatcher;

    public static Matcher<Response> hasErrorMessage(String errorMessage) {
        return new HasErrorMessage(IsEqual.equalTo(errorMessage));
    }

    public static Matcher<Response> hasErrorMessage(Matcher<String> errorMatcher) {
        return new HasErrorMessage(errorMatcher);
    }

    public HasErrorMessage(Matcher<String> errorMessageMatcher) {
        this.errorMessageMatcher = errorMessageMatcher;
    }

    public boolean matchesSafely(Response response) {
        if (response.entity != null && response.entity.errorMessages != null) {
            for (String error : response.entity.errorMessages) {
                if (!this.errorMessageMatcher.matches(error)) continue;
                return true;
            }
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("A Response with an error message that is ").appendDescriptionOf(this.errorMessageMatcher);
    }
}

