/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client;

import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.RestApiClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Version;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.VersionIssueCounts;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.VersionMove;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.VersionUnresolvedIssueCount;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import javax.ws.rs.core.MediaType;

public class VersionClient
extends RestApiClient<VersionClient> {
    public VersionClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Version get(String versionID) throws UniformInterfaceException {
        return (Version)this.versionWithID(versionID).get(Version.class);
    }

    public Response getResponse(final String versionID) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)VersionClient.this.versionWithID(versionID).get(ClientResponse.class);
            }
        });
    }

    public Version create(Version version) throws UniformInterfaceException {
        return (Version)this.version().post(Version.class, (Object)version);
    }

    public Response createResponse(final Version version) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)VersionClient.this.version().post(ClientResponse.class, (Object)version);
            }
        });
    }

    public Response delete(String versionId) throws UniformInterfaceException {
        return this.delete(versionId, null, null);
    }

    public Response delete(final String versionId, final URI swapFixVersion, final URI swapAffectedVersion) throws UniformInterfaceException {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                WebResource deleteResource = VersionClient.this.versionWithID(versionId);
                if (swapFixVersion != null) {
                    deleteResource = deleteResource.queryParam("moveFixIssuesTo", swapFixVersion.getPath());
                }
                if (swapAffectedVersion != null) {
                    deleteResource = deleteResource.queryParam("moveAffectedIssuesTo", swapAffectedVersion.getPath());
                }
                return (ClientResponse)deleteResource.delete(ClientResponse.class);
            }
        });
    }

    public Version move(String versionId, VersionMove versionMove) throws UniformInterfaceException {
        return (Version)this.versionMove(versionId).post(Version.class, (Object)versionMove);
    }

    public Response moveResponse(final String versionId, final VersionMove versionMove) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)VersionClient.this.versionMove(versionId).post(ClientResponse.class, (Object)versionMove);
            }
        });
    }

    public VersionIssueCounts getVersionIssueCounts(String versionID) throws UniformInterfaceException {
        return (VersionIssueCounts)this.versionWithID(versionID).path("relatedIssueCounts").get(VersionIssueCounts.class);
    }

    public Response getVersionIssueCountsResponse(final String versionId) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)VersionClient.this.versionWithID(versionId).path("relatedIssueCounts").get(ClientResponse.class);
            }
        });
    }

    public VersionUnresolvedIssueCount getVersionUnresolvedIssueCount(String versionID) throws UniformInterfaceException {
        return (VersionUnresolvedIssueCount)this.versionWithID(versionID).path("unresolvedIssueCount").get(VersionUnresolvedIssueCount.class);
    }

    public Response getVersionUnresolvedIssueCountResponse(final String versionId) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)VersionClient.this.versionWithID(versionId).path("unresolvedIssueCount").get(ClientResponse.class);
            }
        });
    }

    public Response putResponse(final String versionId, final Version version) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)VersionClient.this.versionWithID(versionId).type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)version);
            }
        });
    }

    public Response putResponse(Version version) {
        String[] selfParts = version.self.split("/");
        String versionId = selfParts[selfParts.length - 1];
        return this.putResponse(versionId, version);
    }

    private WebResource versionWithID(String versionID) {
        return this.createResource().path("version").path(versionID);
    }

    private WebResource.Builder version() {
        return this.createResource().path("version").type(MediaType.APPLICATION_JSON_TYPE);
    }

    private WebResource.Builder versionMove(String versionID) {
        return this.createResource().path("version").path(versionID).path("move").type(MediaType.APPLICATION_JSON_TYPE);
    }
}

