/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client;

import com.atlassian.jira.functest.framework.jerseyclient.ApacheClientFactoryImpl;
import com.atlassian.jira.functest.framework.jerseyclient.JerseyClientFactory;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.AtlassianTenantFilter;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Errors;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.EnumSet;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;

public abstract class RestApiClient<T extends RestApiClient<T>> {
    private static final Logger log = Logger.getLogger(RestApiClient.class);
    public static final String REST_VERSION = "2.0.alpha1";
    private final JerseyClientFactory clientFactory;
    private final JIRAEnvironmentData environmentData;
    private String loginAs;
    private String loginPassword;
    private String version;
    private Client client;

    protected RestApiClient(JIRAEnvironmentData environmentData) {
        this(environmentData, REST_VERSION);
    }

    protected RestApiClient(JIRAEnvironmentData environmentData, String version) {
        this.loginPassword = this.loginAs = "admin";
        this.client = null;
        DefaultClientConfig config = new DefaultClientConfig();
        config.getClasses().add(JacksonJaxbJsonProvider.class);
        this.clientFactory = new ApacheClientFactoryImpl((ClientConfig)config);
        this.environmentData = environmentData;
        this.version = version;
    }

    public T anonymous() {
        this.loginAs = null;
        this.loginPassword = null;
        return (T)this;
    }

    public T loginAs(String username) {
        return this.loginAs(username, username);
    }

    public T loginAs(String username, String password) {
        this.loginAs = username;
        this.loginPassword = password;
        return (T)this;
    }

    protected final WebResource createResource() {
        return this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("api").path(this.version);
    }

    protected WebResource resourceRoot(String url) {
        WebResource resource = this.client().resource(url);
        if (this.loginAs != null) {
            resource = resource.queryParam("os_authType", "basic").queryParam("os_username", RestApiClient.percentEncode(this.loginAs)).queryParam("os_password", RestApiClient.percentEncode(this.loginPassword));
        }
        return resource;
    }

    private Client client() {
        if (this.client == null) {
            this.client = this.clientFactory.create();
            if (StringUtils.isNotBlank((String)this.environmentData.getTenant())) {
                this.client.addFilter((ClientFilter)new AtlassianTenantFilter(this.environmentData.getTenant()));
            }
        }
        return this.client;
    }

    protected Response toResponse(Method method) {
        ClientResponse clientResponse = method.call();
        if (clientResponse.getStatus() == 200) {
            Response response = new Response(clientResponse.getStatus(), null);
            clientResponse.close();
            return response;
        }
        Errors entity = null;
        if (clientResponse.hasEntity() && MediaType.APPLICATION_JSON_TYPE.isCompatible(clientResponse.getType())) {
            try {
                entity = (Errors)clientResponse.getEntity(Errors.class);
            }
            catch (Exception e) {
                log.debug((Object)"Failed to deserialise Errors from response", (Throwable)e);
            }
        }
        Response response = new Response(clientResponse.getStatus(), entity);
        clientResponse.close();
        return response;
    }

    protected WebResource expanded(WebResource resource, EnumSet<?> expands) {
        if (expands.isEmpty()) {
            return resource;
        }
        return resource.queryParam("expand", RestApiClient.percentEncode(StringUtils.join(expands, (String)",")));
    }

    protected static <E extends Enum<E>> EnumSet<E> setOf(Class<E> cls, E ... expand) {
        return expand.length == 0 ? EnumSet.noneOf(cls) : EnumSet.of(expand[0], expand);
    }

    protected static String percentEncode(String queryParam) {
        return queryParam == null ? null : queryParam.replace("%", "%25");
    }

    static interface Method {
        public ClientResponse call();
    }
}

