/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client;

import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.ProjectRole;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.ProjectRoleActorsUpdate;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.RestApiClient;
import com.google.common.collect.Maps;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;

public class ProjectRoleClient
extends RestApiClient<ProjectRoleClient> {
    public ProjectRoleClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public ProjectRoleClient(JIRAEnvironmentData environmentData, String version) {
        super(environmentData, version);
    }

    public Map get(String projectKey) throws UniformInterfaceException {
        return (Map)this.rolesWithProjectKey(projectKey).get(Map.class);
    }

    public ProjectRole get(String projectKey, String role) {
        WebResource webResource = this.resourceRoot((String)this.get(projectKey).get(role));
        return (ProjectRole)webResource.get(ProjectRole.class);
    }

    public Response addActors(final String projectKey, String role, final @Nullable String[] groupNames, final @Nullable String[] userNames) {
        final ProjectRole projectRole = this.get(projectKey, role);
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                WebResource webResource = ProjectRoleClient.this.rolesWithProjectKey(projectKey).path(projectRole.id.toString());
                HashMap parameter = Maps.newHashMap();
                if (groupNames != null) {
                    parameter.put("group", groupNames);
                }
                if (userNames != null) {
                    parameter.put("user", userNames);
                }
                return (ClientResponse)webResource.type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)parameter);
            }
        });
    }

    public Response deleteGroup(final String projectKey, String role, final String groupName) {
        final ProjectRole projectRole = this.get(projectKey, role);
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                WebResource webResource = ProjectRoleClient.this.rolesWithProjectKey(projectKey).path(projectRole.id.toString()).queryParam("group", groupName);
                return (ClientResponse)webResource.delete(ClientResponse.class);
            }
        });
    }

    public Response deleteUser(final String projectKey, String role, final String userName) {
        final ProjectRole projectRole = this.get(projectKey, role);
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                WebResource webResource = ProjectRoleClient.this.rolesWithProjectKey(projectKey).path(projectRole.id.toString()).queryParam("user", userName);
                return (ClientResponse)webResource.delete(ClientResponse.class);
            }
        });
    }

    protected WebResource rolesWithProjectKey(String projectKey) {
        return this.createResource().path("project").path(projectKey).path("role");
    }

    public Response setActors(final String projectKey, String role, final Map<String, String[]> actors) {
        final ProjectRole projectRole = this.get(projectKey, role);
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                WebResource webResource = ProjectRoleClient.this.rolesWithProjectKey(projectKey).path(projectRole.id.toString());
                ProjectRoleActorsUpdate projectRoleActorsUpdate = new ProjectRoleActorsUpdate(projectRole.id, actors);
                return (ClientResponse)webResource.type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)projectRoleActorsUpdate);
            }
        });
    }
}

