/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Status;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.StatusClient;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestStatusResource
extends RestFuncTest {
    private static final String STATUS_ID = "10000";
    private StatusClient statusClient;

    public void testStatusReturned() throws Exception {
        Status status = this.statusClient.get(STATUS_ID);
        TestStatusResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2.0.alpha1/status/10000"), (String)status.self);
        TestStatusResource.assertEquals((String)"Custom status", (String)status.description);
        TestStatusResource.assertEquals((String)this.getBaseUrlPlus("images/icons/status_generic.gif"), (String)status.iconUrl);
        TestStatusResource.assertEquals((String)"Insane", (String)status.name);
    }

    public void testStatusFilteredByPermissions() throws Exception {
        Response response = ((StatusClient)this.statusClient.loginAs("fred")).getResponse(STATUS_ID);
        TestStatusResource.assertEquals((int)404, (int)response.statusCode);
    }

    public void testStatusDoesntExist() throws Exception {
        Response resp123 = this.statusClient.getResponse("123");
        TestStatusResource.assertEquals((int)404, (int)resp123.statusCode);
        TestStatusResource.assertEquals((String)"The status with id '123' does not exist", (String)resp123.entity.errorMessages.get(0));
        Response respAbc = this.statusClient.getResponse("abc");
        TestStatusResource.assertEquals((int)404, (int)respAbc.statusCode);
        TestStatusResource.assertEquals((String)"The status with id 'abc' does not exist", (String)respAbc.entity.errorMessages.get(0));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.statusClient = new StatusClient(this.getEnvironmentData());
        this.administration.restoreData("TestStatusResource.xml");
    }
}

