/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Issue;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.SearchClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.SearchRequest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.SearchResult;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.matcher.ContainsStringThatStartsWith;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestSearchResource
extends RestFuncTest {
    private static final String HSP = "HSP";
    private static final String MKY = "MKY";
    private static final String HSP_1 = "HSP-1";
    private SearchClient searchClient;
    private IssueClient issueClient;

    public void testSearchShouldFilterOutIssuesFromNonBrowseableProjects() throws Exception {
        SearchResult mkyResults = ((SearchClient)this.searchClient.anonymous()).postSearch(new SearchRequest().jql("project = HSP"));
        Assert.assertThat((Object)mkyResults.total, CoreMatchers.equalTo(0));
        Assert.assertThat((Object)mkyResults.issues.size(), CoreMatchers.equalTo(0));
        SearchResult hspResults = ((SearchClient)this.searchClient.anonymous()).postSearch(new SearchRequest().jql("project = MKY"));
        Assert.assertThat((Object)hspResults.total, CoreMatchers.equalTo(4));
        Assert.assertThat((Object)hspResults.issues.size(), CoreMatchers.equalTo(4));
        SearchResult allResults = ((SearchClient)this.searchClient.anonymous()).postSearch(new SearchRequest().jql(""));
        Assert.assertThat(allResults.issues, CoreMatchers.equalTo(hspResults.issues));
    }

    public void testSearchMaxResultsShouldDefaultTo50() throws Exception {
        SearchResult results = this.searchClient.postSearch(new SearchRequest());
        Assert.assertThat((Object)results.maxResults, CoreMatchers.equalTo(50));
    }

    public void testSearchMaxResultsIsNotAllowedToExceed1000() throws Exception {
        SearchResult results = this.searchClient.postSearch(new SearchRequest().maxResults(2000));
        Assert.assertThat((Object)results.maxResults, CoreMatchers.equalTo(1000));
    }

    public void testSearchShouldReturnPagesWithAtMostThreeIssues() throws Exception {
        int startAt;
        int issueCount = 8;
        int pageSize = 3;
        int pageNum = 0;
        HashSet keysReturnedInPreviousPage = Sets.newHashSet();
        while ((startAt = 3 * pageNum++) < 8) {
            SearchResult page = this.searchClient.postSearch(new SearchRequest().jql("order by key").maxResults(3).startAt(startAt));
            Assert.assertThat((Object)page.startAt, CoreMatchers.equalTo(startAt));
            Assert.assertThat((Object)page.total, CoreMatchers.equalTo(8));
            Assert.assertThat((Object)page.issues.size(), CoreMatchers.equalTo(Math.min(3, 8 - startAt)));
            TestSearchResource.assertTrue((boolean)Sets.intersection((Set)keysReturnedInPreviousPage, (Set)Sets.newHashSet(page.issues)).isEmpty());
            keysReturnedInPreviousPage.addAll(page.issues);
        }
    }

    public void testSearchStartAtAndMaxResultsShouldHaveDefaultValues() throws Exception {
        SearchResult results = this.searchClient.postSearch(new SearchRequest());
        Assert.assertThat((Object)results.startAt, CoreMatchers.equalTo(0));
        Assert.assertThat((Object)results.maxResults, CoreMatchers.notNullValue());
    }

    public void testSearchWithBadJqlShouldReturnStatusCode400() throws Exception {
        Response results = this.searchClient.postSearchResponse(new SearchRequest().jql("zomg!!!11111"));
        Assert.assertThat((Object)results.statusCode, CoreMatchers.equalTo(400));
        Assert.assertThat(results.entity.errorMessages, ContainsStringThatStartsWith.containsStringThatStartsWith("Error in the JQL Query:"));
    }

    public void testSearchWithNoJqlShouldReturnAllIssues() throws Exception {
        SearchRequest searchRequest = new SearchRequest().jql(null);
        TestSearchResource.assertFalse((boolean)this.searchClient.getSearch((SearchRequest)searchRequest).issues.isEmpty());
        TestSearchResource.assertFalse((boolean)this.searchClient.postSearch((SearchRequest)searchRequest).issues.isEmpty());
    }

    public void testSearchResultsShouldReturnOnlyTheIssueKeyAndSelf() throws Exception {
        SearchResult hsp1Results = this.searchClient.postSearch(new SearchRequest().jql("key = HSP-1"));
        Assert.assertThat((Object)hsp1Results.total, CoreMatchers.equalTo(1));
        Assert.assertThat((Object)hsp1Results.issues.size(), CoreMatchers.equalTo(1));
        Issue hsp1 = hsp1Results.issues.get(0);
        Assert.assertThat((Object)hsp1.key, CoreMatchers.equalTo(HSP_1));
        Issue selfIssue = this.issueClient.getFromURL(hsp1.self, new Issue.Expand[0]);
        Assert.assertThat((Object)hsp1.key, CoreMatchers.equalTo(selfIssue.key));
        Assert.assertThat((Object)hsp1.self, CoreMatchers.equalTo(selfIssue.self));
    }

    public void testSearchUsingGetReturnsTheSameAsUsingPost() throws Exception {
        SearchRequest aSearch = new SearchRequest();
        SearchResult postResults = this.searchClient.postSearch(aSearch);
        SearchResult getResults = this.searchClient.getSearch(aSearch);
        TestSearchResource.assertEquals((Object)getResults, (Object)postResults);
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestIssueSearch.xml");
        this.searchClient = new SearchClient(this.getEnvironmentData());
        this.issueClient = new IssueClient(this.getEnvironmentData());
    }
}

