/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Errors;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.ProjectRole;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.ProjectRoleClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestProjectRoleResource
extends RestFuncTest {
    private ProjectRoleClient projectRoleClient;

    public void testViewProjectRoles() throws Exception {
        Map mky = this.projectRoleClient.get("MKY");
        TestProjectRoleResource.assertEquals((int)3, (int)mky.size());
        List<String> roles = CollectionBuilder.newBuilder("Users", "Administrators", "Developers").asList();
        for (String role : roles) {
            JSONObject jsonRole = this.getJSON((String)mky.get(role));
            TestProjectRoleResource.assertEquals((Object)role, (Object)jsonRole.get("name"));
        }
    }

    public void testViewRole() throws Exception {
        ProjectRole projectRole = this.projectRoleClient.get("MKY", "Users");
        TestProjectRoleResource.assertEquals((String)"Users", (String)projectRole.name);
        TestProjectRoleResource.assertEquals((String)"A project role that represents users in a project", (String)projectRole.description);
        TestProjectRoleResource.assertNotNull((Object)projectRole.self);
        TestProjectRoleResource.assertNotNull((Object)projectRole.id);
        TestProjectRoleResource.assertEquals((int)2, (int)projectRole.actors.size());
        Map<String, ProjectRole.Actor> map = this.makeMap(projectRole.actors);
        ProjectRole.Actor actor = map.get("admin");
        TestProjectRoleResource.assertEquals((String)"Administrator", (String)actor.displayName);
        TestProjectRoleResource.assertEquals((String)"atlassian-user-role-actor", (String)actor.type);
        TestProjectRoleResource.assertEquals((String)"admin", (String)actor.name);
    }

    public void testViewRoleActorsIsSortedByDisplayName() throws Exception {
        ProjectRole projectRole = this.projectRoleClient.get("MKY", "Users");
        TestProjectRoleResource.assertEquals((int)2, (int)projectRole.actors.size());
        ProjectRole.Actor admin = projectRole.actors.get(0);
        TestProjectRoleResource.assertEquals((String)"Administrator", (String)admin.displayName);
        TestProjectRoleResource.assertEquals((String)"atlassian-user-role-actor", (String)admin.type);
        TestProjectRoleResource.assertEquals((String)"admin", (String)admin.name);
        ProjectRole.Actor actor = projectRole.actors.get(1);
        TestProjectRoleResource.assertEquals((String)"jira-users", (String)actor.displayName);
        TestProjectRoleResource.assertEquals((String)"atlassian-group-role-actor", (String)actor.type);
        TestProjectRoleResource.assertEquals((String)"jira-users", (String)actor.name);
        this.administration.usersAndGroups().addUser("aaaa", "aaaa", "zzzz", "aaa@aaa.com");
        this.administration.usersAndGroups().addUser("zzzz", "zzzz", "aaaa", "zzz@zzz.com");
        this.projectRoleClient.addActors("MKY", "Users", new String[0], new String[]{"aaaa", "zzzz"});
        projectRole = this.projectRoleClient.get("MKY", "Users");
        TestProjectRoleResource.assertEquals((int)4, (int)projectRole.actors.size());
        TestProjectRoleResource.assertEquals((String)"aaaa", (String)projectRole.actors.get((int)0).displayName);
        TestProjectRoleResource.assertEquals((String)"Administrator", (String)projectRole.actors.get((int)1).displayName);
        TestProjectRoleResource.assertEquals((String)"jira-users", (String)projectRole.actors.get((int)2).displayName);
        TestProjectRoleResource.assertEquals((String)"zzzz", (String)projectRole.actors.get((int)3).displayName);
    }

    public void testSetRoleActors() throws Exception {
        ProjectRole projectRole = this.projectRoleClient.get("MKY", "Users");
        List<ProjectRole.Actor> actors = projectRole.actors;
        TestProjectRoleResource.assertEquals((int)2, (int)actors.size());
        ProjectRole.Actor admin = actors.get(0);
        TestProjectRoleResource.assertEquals((String)"Administrator", (String)admin.displayName);
        TestProjectRoleResource.assertEquals((String)"atlassian-user-role-actor", (String)admin.type);
        TestProjectRoleResource.assertEquals((String)"admin", (String)admin.name);
        ProjectRole.Actor actor = actors.get(1);
        TestProjectRoleResource.assertEquals((String)"jira-users", (String)actor.displayName);
        TestProjectRoleResource.assertEquals((String)"atlassian-group-role-actor", (String)actor.type);
        TestProjectRoleResource.assertEquals((String)"jira-users", (String)actor.name);
        this.administration.usersAndGroups().addUser("aaaa", "aaaa", "zzzz", "aaa@aaa.com");
        this.administration.usersAndGroups().addUser("zzzz", "zzzz", "aaaa", "zzz@zzz.com");
        this.administration.usersAndGroups().addGroup("ladida");
        this.projectRoleClient.setActors("MKY", "Users", MapBuilder.newBuilder().add("atlassian-user-role-actor", new String[]{"aaaa", "zzzz"}).add("atlassian-group-role-actor", new String[]{"ladida"}).toMap());
        projectRole = this.projectRoleClient.get("MKY", "Users");
        actors = projectRole.actors;
        TestProjectRoleResource.assertEquals((int)3, (int)actors.size());
        TestProjectRoleResource.assertEquals((String)"aaaa", (String)actors.get((int)0).displayName);
        TestProjectRoleResource.assertEquals((String)"atlassian-user-role-actor", (String)actors.get((int)0).type);
        TestProjectRoleResource.assertEquals((String)"zzzz", (String)actors.get((int)0).name);
        TestProjectRoleResource.assertEquals((String)"ladida", (String)actors.get((int)1).displayName);
        TestProjectRoleResource.assertEquals((String)"atlassian-group-role-actor", (String)actors.get((int)1).type);
        TestProjectRoleResource.assertEquals((String)"ladida", (String)actors.get((int)1).name);
        TestProjectRoleResource.assertEquals((String)"zzzz", (String)actors.get((int)2).displayName);
        TestProjectRoleResource.assertEquals((String)"atlassian-user-role-actor", (String)actors.get((int)2).type);
        TestProjectRoleResource.assertEquals((String)"aaaa", (String)actors.get((int)2).name);
        Response response = this.projectRoleClient.setActors("MKY", "Users", MapBuilder.newBuilder().add("atlassian-user-role-actor", new String[]{"aaaa"}).add("atlassian-group-role-actor", new String[]{"azza"}).toMap());
        TestProjectRoleResource.assertEquals((int)Response.Status.NOT_FOUND.getStatusCode(), (int)response.statusCode);
        TestProjectRoleResource.assertEquals((Object)new Errors().addError("'azza' does not exist."), (Object)response.entity);
    }

    Map<String, ProjectRole.Actor> makeMap(Collection<ProjectRole.Actor> actors) {
        HashMap<String, ProjectRole.Actor> map = new HashMap<String, ProjectRole.Actor>();
        for (ProjectRole.Actor actor : actors) {
            TestProjectRoleResource.assertFalse((boolean)map.containsKey(actor.name));
            map.put(actor.name, actor);
        }
        return map;
    }

    public void testDeleteRoleActor() throws Exception {
        ProjectRole projectRole = this.projectRoleClient.get("MKY", "Users");
        TestProjectRoleResource.assertEquals((int)2, (int)projectRole.actors.size());
        this.projectRoleClient.deleteGroup("MKY", "Users", "jira-users");
        TestProjectRoleResource.assertEquals((int)1, (int)this.projectRoleClient.get((String)"MKY", (String)"Users").actors.size());
        this.projectRoleClient.deleteUser("MKY", "Users", "admin");
        TestProjectRoleResource.assertEquals((int)0, (int)this.projectRoleClient.get((String)"MKY", (String)"Users").actors.size());
    }

    public void testAddRoleActor() throws Exception {
        ProjectRole projectRole = this.projectRoleClient.get("MKY", "Developers");
        TestProjectRoleResource.assertEquals((int)0, (int)projectRole.actors.size());
        this.projectRoleClient.addActors("MKY", "Developers", new String[]{"jira-developers"}, null);
        projectRole = this.projectRoleClient.get("MKY", "Developers");
        TestProjectRoleResource.assertEquals((int)1, (int)projectRole.actors.size());
        ProjectRole.Actor actor = projectRole.actors.get(0);
        TestProjectRoleResource.assertEquals((String)"jira-developers", (String)actor.name);
        TestProjectRoleResource.assertEquals((String)"jira-developers", (String)actor.displayName);
        TestProjectRoleResource.assertEquals((String)"atlassian-group-role-actor", (String)actor.type);
    }

    public void testAddRoleActors() throws Exception {
        ProjectRole projectRole = this.projectRoleClient.get("MKY", "Developers");
        TestProjectRoleResource.assertEquals((int)0, (int)projectRole.actors.size());
        this.projectRoleClient.addActors("MKY", "Developers", new String[]{"jira-users", "jira-administrators", "jira-developers"}, new String[]{"admin"});
        projectRole = this.projectRoleClient.get("MKY", "Developers");
        TestProjectRoleResource.assertEquals((int)4, (int)projectRole.actors.size());
        ProjectRole.Actor admin = projectRole.actors.get(0);
        TestProjectRoleResource.assertEquals((String)"admin", (String)admin.name);
        TestProjectRoleResource.assertEquals((String)"Administrator", (String)admin.displayName);
        TestProjectRoleResource.assertEquals((String)"atlassian-user-role-actor", (String)admin.type);
        ProjectRole.Actor administrators = projectRole.actors.get(1);
        TestProjectRoleResource.assertEquals((String)"jira-administrators", (String)administrators.name);
        TestProjectRoleResource.assertEquals((String)"jira-administrators", (String)administrators.displayName);
        TestProjectRoleResource.assertEquals((String)"atlassian-group-role-actor", (String)administrators.type);
        ProjectRole.Actor developers = projectRole.actors.get(2);
        TestProjectRoleResource.assertEquals((String)"jira-developers", (String)developers.name);
        TestProjectRoleResource.assertEquals((String)"jira-developers", (String)developers.displayName);
        TestProjectRoleResource.assertEquals((String)"atlassian-group-role-actor", (String)developers.type);
        ProjectRole.Actor users = projectRole.actors.get(3);
        TestProjectRoleResource.assertEquals((String)"jira-users", (String)users.name);
        TestProjectRoleResource.assertEquals((String)"jira-users", (String)users.displayName);
        TestProjectRoleResource.assertEquals((String)"atlassian-group-role-actor", (String)users.type);
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.projectRoleClient = new ProjectRoleClient(this.getEnvironmentData());
        this.administration.restoreData("TestProjectRoleResource.xml");
    }

    JSONObject getJSON(String uri) throws JSONException {
        this.getTester().getDialog().gotoPage(uri);
        return new JSONObject(this.getTester().getDialog().getResponseText());
    }
}

