/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Component;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Errors;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueType;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Project;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.ProjectClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.User;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Version;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestProjectResource
extends RestFuncTest {
    private ProjectClient projectClient;

    public void testViewProject() throws Exception {
        this.checkProject(this.createProjectMky(), true, false);
        this.checkProject(this.createProjectAtl(), true, true);
        this.checkProject(this.createProjectHid(), false, false);
        this.checkProject(this.createProjectFred(), true, false);
        this.checkProject(this.createProjectDodo(), false, false);
    }

    public void testViewProjectNoPermission() throws Exception {
        this.assertCantSeeProject("fred", "HID");
        this.assertCantSeeProject(null, "MKY");
        this.assertCantSeeProject(null, "HID");
        this.assertCantSeeProject(null, "FRED");
    }

    public void testViewProjects() throws Exception {
        Project projectAtl = this.makeSimple(this.createProjectAtl());
        Project projectFred = this.makeSimple(this.createProjectFred());
        Project projectHsp = this.makeSimple(this.createProjectHsp());
        Project projectHid = this.makeSimple(this.createProjectHid());
        Project projectMky = this.makeSimple(this.createProjectMky());
        Project projectDodo = this.makeSimple(this.createProjectDodo());
        TestProjectResource.assertEquals(TestProjectResource.list(projectAtl, projectDodo, projectFred, projectHid, projectHsp, projectMky), this.projectClient.getProjects());
        TestProjectResource.assertEquals(TestProjectResource.list(projectAtl, projectFred, projectHsp, projectMky), ((ProjectClient)this.projectClient.loginAs("fred")).getProjects());
        TestProjectResource.assertEquals(TestProjectResource.list(projectAtl), ((ProjectClient)this.projectClient.anonymous()).getProjects());
    }

    public void testViewProjectDoesNotExist() throws Exception {
        Response respXXX = this.projectClient.getResponse("XXX");
        TestProjectResource.assertEquals((int)404, (int)respXXX.statusCode);
        TestProjectResource.assertEquals((int)1, (int)respXXX.entity.errorMessages.size());
        TestProjectResource.assertTrue((boolean)respXXX.entity.errorMessages.contains("No project could be found with key 'XXX'."));
    }

    public void testViewProjectVersions() throws Exception {
        TestProjectResource.assertTrue((boolean)this.projectClient.getVersions("MKY").isEmpty());
        TestProjectResource.assertEquals(this.createVersionsAtl(), this.projectClient.getVersions("ATL"));
    }

    public void testViewProjectVersionsAnonymous() throws Exception {
        TestProjectResource.assertEquals(this.createVersionsAtl(), ((ProjectClient)this.projectClient.anonymous()).getVersions("ATL"));
        Response response = this.projectClient.getVersionsResponse("MKY");
        TestProjectResource.assertEquals((int)404, (int)response.statusCode);
        TestProjectResource.assertEquals((Object)new Errors().addError("You cannot view this project."), (Object)response.entity);
    }

    public void testViewProjectComponents() throws Exception {
        TestProjectResource.assertTrue((boolean)this.projectClient.getComponents("MKY").isEmpty());
        TestProjectResource.assertEquals(this.createComponentsHsp(), this.projectClient.getComponents("HSP"));
    }

    public void testViewProjectComponentsAnonymous() throws Exception {
        TestProjectResource.assertEquals(this.createComponentsAtlFull(), ((ProjectClient)this.projectClient.anonymous()).getComponents("ATL"));
        Response response = this.projectClient.getVersionsResponse("MKY");
        TestProjectResource.assertEquals((int)404, (int)response.statusCode);
        TestProjectResource.assertEquals((Object)new Errors().addError("You cannot view this project."), (Object)response.entity);
    }

    private Project makeSimple(Project project) {
        return project.components(null).assigneeType(null).description(null).lead(null).versions(null).issueTypes(null).roles(new HashMap<String, String>());
    }

    private void assertCantSeeProject(String username, String hid) {
        if (username == null) {
            this.projectClient.anonymous();
        } else {
            this.projectClient.loginAs(username);
        }
        Response response = this.projectClient.getResponse(hid);
        TestProjectResource.assertEquals((int)404, (int)response.statusCode);
        TestProjectResource.assertEquals((Object)new Errors().addError("You cannot view this project."), (Object)response.entity);
    }

    private void checkProject(Project expectedProject, boolean fred, boolean anonymous) {
        Project actualProject = ((ProjectClient)this.projectClient.loginAs("admin")).get(expectedProject.key);
        TestProjectResource.assertEquals((Object)expectedProject, (Object)actualProject);
        if (fred) {
            actualProject = ((ProjectClient)this.projectClient.loginAs("fred")).get(expectedProject.key);
            TestProjectResource.assertEquals((Object)expectedProject, (Object)actualProject);
        }
        if (anonymous) {
            actualProject = ((ProjectClient)this.projectClient.anonymous()).get(expectedProject.key);
            TestProjectResource.assertEquals((Object)expectedProject, (Object)actualProject);
        }
    }

    private List<IssueType> createStandardIssueTypes() {
        return CollectionBuilder.newBuilder(new IssueType().self(this.getRestApiUrl("issueType/1")).name("Bug"), new IssueType().self(this.getRestApiUrl("issueType/2")).name("New Feature"), new IssueType().self(this.getRestApiUrl("issueType/3")).name("Task"), new IssueType().self(this.getRestApiUrl("issueType/4")).name("Improvement")).asList();
    }

    private Map<String, String> createStandardRoles(String projectKey) {
        return MapBuilder.newBuilder().add("Users", this.getRestApiUri("project", projectKey, "role", "10000").toString()).add("Developers", this.getRestApiUri("project", projectKey, "role", "10001").toString()).add("Administrators", this.getRestApiUri("project", projectKey, "role", "10002").toString()).toMap();
    }

    private Project createProjectMky() {
        return new Project().self(this.getRestApiUri("project/MKY")).key("MKY").name("monkey").lead(this.createUserAdmin()).description("project for monkeys").assigneeType(Project.AssigneeType.PROJECT_LEAD).issueTypes(this.createStandardIssueTypes()).roles(this.createStandardRoles("MKY")).components(Collections.<Component>emptyList()).versions(Collections.<Version>emptyList());
    }

    private Project createProjectHid() {
        return new Project().self(this.getRestApiUri("project/HID")).key("HID").name("HIDDEN").components(Collections.<Component>emptyList()).versions(Collections.<Version>emptyList()).assigneeType(Project.AssigneeType.PROJECT_LEAD).roles(this.createStandardRoles("HID")).issueTypes(this.createStandardIssueTypes()).lead(this.createUserAdmin());
    }

    private Project createProjectHsp() {
        return new Project().self(this.getRestApiUri("project/HSP")).key("HSP").name("homosapien").description("project for homosapiens").versions(this.createVersionsHsp()).components(this.createComponentsHsp()).issueTypes(this.createStandardIssueTypes()).assigneeType(Project.AssigneeType.PROJECT_LEAD).roles(this.createStandardRoles("HSP")).lead(this.createUserAdmin());
    }

    private Project createProjectFred() {
        return new Project().self(this.getRestApiUri("project/FRED")).key("FRED").name("Fred").components(Collections.<Component>emptyList()).versions(Collections.<Version>emptyList()).issueTypes(this.createStandardIssueTypes()).assigneeType(Project.AssigneeType.PROJECT_LEAD).roles(this.createStandardRoles("FRED")).lead(this.createUserFred());
    }

    private Project createProjectDodo() {
        return new Project().self(this.getRestApiUri("project/DD")).key("DD").name("Dead Leader").components(Collections.<Component>emptyList()).versions(Collections.<Version>emptyList()).assigneeType(Project.AssigneeType.PROJECT_LEAD).issueTypes(this.createStandardIssueTypes()).roles(this.createStandardRoles("DD")).lead(this.createUserDodo());
    }

    private Project createProjectAtl() {
        return new Project().self(this.getRestApiUri("project/ATL")).key("ATL").name("Atlassian").lead(this.createUserAdmin()).components(this.createComponentsAtlShort()).assigneeType(Project.AssigneeType.PROJECT_LEAD).issueTypes(this.createStandardIssueTypes()).roles(this.createStandardRoles("ATL")).versions(this.createVersionsAtl());
    }

    private List<Version> createVersionsAtl() {
        CollectionBuilder<Version> builder = CollectionBuilder.newBuilder();
        builder.add(new Version().self(this.createVersionUri(10014L)).archived(true).released(false).name("Five").description("Five").id(10014L));
        builder.add(new Version().self(this.createVersionUri(10013L)).archived(true).released(true).name("Four").description("Four").releaseDate("09/Mar/11").id(10013L));
        builder.add(new Version().self(this.createVersionUri(10012L)).archived(false).released(true).name("Three").releaseDate("09/Mar/11").id(10012L));
        builder.add(new Version().self(this.createVersionUri(10011L)).archived(false).released(false).name("Two").description("Description").id(10011L));
        builder.add(new Version().self(this.createVersionUri(10010L)).archived(false).released(false).name("One").releaseDate("01/Mar/11").overdue(true).id(10010L));
        return builder.asList();
    }

    private List<Version> createVersionsHsp() {
        CollectionBuilder<Version> builder = CollectionBuilder.newBuilder();
        builder.add(new Version().self(this.createVersionUri(10000L)).archived(false).released(false).name("New Version 1").description("Test Version Description 1").id(10000L));
        builder.add(new Version().self(this.createVersionUri(10001L)).archived(false).released(false).name("New Version 4").description("Test Version Description 4").id(10001L));
        builder.add(new Version().self(this.createVersionUri(10002L)).archived(false).released(false).name("New Version 5").description("Test Version Description 5").id(10002L));
        return builder.asList();
    }

    private List<Component> createComponentsHsp() {
        CollectionBuilder<Component> builder = CollectionBuilder.newBuilder();
        builder.add(new Component().self(this.createComponentUri(10000L)).id(10000L).name("New Component 1").assigneeType(Component.AssigneeType.PROJECT_DEFAULT).assignee(this.createUserAdmin()).realAssigneeType(Component.AssigneeType.PROJECT_DEFAULT).realAssignee(this.createUserAdmin()).isAssigneeTypeValid(true));
        builder.add(new Component().self(this.createComponentUri(10001L)).id(10001L).name("New Component 2").assigneeType(Component.AssigneeType.PROJECT_DEFAULT).assignee(this.createUserAdmin()).realAssigneeType(Component.AssigneeType.PROJECT_DEFAULT).realAssignee(this.createUserAdmin()).isAssigneeTypeValid(true));
        builder.add(new Component().self(this.createComponentUri(10002L)).id(10002L).name("New Component 3").assigneeType(Component.AssigneeType.PROJECT_DEFAULT).assignee(this.createUserAdmin()).realAssigneeType(Component.AssigneeType.PROJECT_DEFAULT).realAssignee(this.createUserAdmin()).isAssigneeTypeValid(true));
        return builder.asList();
    }

    private List<Component> createComponentsAtlFull() {
        CollectionBuilder<Component> builder = CollectionBuilder.newBuilder();
        builder.add(new Component().self(this.createComponentUri(10003L)).id(10003L).name("New Component 4").assigneeType(Component.AssigneeType.PROJECT_DEFAULT).assignee(this.createUserAdmin()).realAssigneeType(Component.AssigneeType.PROJECT_DEFAULT).realAssignee(this.createUserAdmin()).isAssigneeTypeValid(true));
        builder.add(new Component().self(this.createComponentUri(10004L)).id(10004L).name("New Component 5").assigneeType(Component.AssigneeType.PROJECT_DEFAULT).assignee(this.createUserAdmin()).realAssigneeType(Component.AssigneeType.PROJECT_DEFAULT).realAssignee(this.createUserAdmin()).isAssigneeTypeValid(true));
        return builder.asList();
    }

    private List<Component> createComponentsAtlShort() {
        CollectionBuilder<Component> builder = CollectionBuilder.newBuilder();
        builder.add(new Component().self(this.createComponentUri(10003L)).id(10003L).name("New Component 4"));
        builder.add(new Component().self(this.createComponentUri(10004L)).id(10004L).name("New Component 5"));
        return builder.asList();
    }

    private User createUserAdmin() {
        return new User().self(this.createUserUri("admin")).name("admin").displayName("Administrator").active(true);
    }

    private User createUserFred() {
        return new User().self(this.createUserUri("fred")).name("fred").displayName("Fred Normal").active(true);
    }

    private User createUserDodo() {
        return new User().self(this.createUserUri("dodo")).name("dodo").displayName("dodo").active(false);
    }

    private URI createVersionUri(long id) {
        return this.getRestApiUri("version", String.valueOf(id));
    }

    private URI createComponentUri(long id) {
        return this.getRestApiUri("component", String.valueOf(id));
    }

    private URI createUserUri(String name) {
        return this.getRestApiUri(String.format("user?username=%s", name));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.projectClient = new ProjectClient(this.getEnvironmentData());
        this.administration.restoreData("TestProjectResource.xml");
    }

    @Override
    protected void tearDownTest() {
        super.tearDownTest();
        this.projectClient = null;
        this.administration = null;
    }

    private static <T, S extends T> List<T> list(S ... element) {
        return Lists.newArrayList((Object[])element);
    }
}

