/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.HeaderValue;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.SECURITY})
public class TestLogin
extends RestFuncTest {
    public static final int CAPTCHA_MAX_TRIES = 10;
    public static final String X_AUTHENTICATION_DENIED_REASON = "X-Authentication-Denied-Reason";
    private JSONObject fredBadCredentials;
    private JSONObject fredGoodCredentials;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
        try {
            this.fredBadCredentials = new JSONObject();
            this.fredBadCredentials.put("username", "fred");
            this.fredBadCredentials.put("password", "fredzzz");
            this.fredGoodCredentials = new JSONObject();
            this.fredGoodCredentials.put("username", "fred");
            this.fredGoodCredentials.put("password", "fred");
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public void testCurrentUser() throws Exception {
        JSONObject json = this.getJSON("/rest/auth/latest/session", new String[0]);
        TestLogin.assertEquals((String)"admin", (String)json.getString("name"));
        TestLogin.assertTrue((boolean)json.has("loginInfo"));
    }

    public void testCurrentUserAnon() throws Exception {
        this.navigation.logout();
        WebResponse response = this.GET("/rest/auth/latest/session");
        TestLogin.assertEquals((int)401, (int)response.getResponseCode());
    }

    public void testLogin() throws Exception {
        this.navigation.logout();
        JSONObject json = new JSONObject();
        json.put("username", "admin");
        json.put("password", "BAD-PASSWORD");
        WebResponse response = this.loginAs(json);
        TestLogin.assertEquals((int)401, (int)response.getResponseCode());
        TestLogin.assertEquals((String)"JIRA REST POST", (String)response.getHeaderField("WWW-Authenticate"));
        JSONObject userThatDoesntExist = new JSONObject().put("username", "wtf").put("password", "kljasdfjkl;dfs");
        TestLogin.assertEquals((String)"should return 401 if user doesn't exist", (int)401, (int)this.loginAs(userThatDoesntExist).getResponseCode());
        json = new JSONObject();
        json.put("username", "admin");
        json.put("password", "admin");
        response = this.loginAs(json);
        TestLogin.assertEquals((int)200, (int)response.getResponseCode());
        JSONObject responseJson = new JSONObject(response.getText());
        JSONObject session = responseJson.getJSONObject("session");
        TestLogin.assertEquals((String)"JSESSIONID", (String)session.getString("name"));
        TestLogin.assertEquals((String)this.tester.getDialog().getWebClient().getCookieValue("JSESSIONID"), (String)session.getString("value"));
        JSONObject loginInfo = responseJson.getJSONObject("loginInfo");
        TestLogin.assertTrue((boolean)loginInfo.has("previousLoginTime"));
        TestLogin.assertTrue((boolean)loginInfo.has("lastFailedLoginTime"));
        TestLogin.assertEquals((long)3L, (long)loginInfo.getLong("loginCount"));
        TestLogin.assertEquals((long)1L, (long)loginInfo.getLong("failedLoginCount"));
    }

    public void testWhenTheLoginResourceGivesYouACookieYouShouldBeAbleToActuallyDoSomethingWithIt() throws Exception {
        String key = this.navigation.issue().createIssue("homosapien", "Bug", "this is a summary");
        this.navigation.logout();
        JSONObject json = new JSONObject();
        json.put("username", "admin");
        json.put("password", "admin");
        WebResponse response = this.loginAs(json);
        JSONObject responseJson = new JSONObject(response.getText());
        JSONObject session = responseJson.getJSONObject("session");
        String jsessionId = session.getString("value");
        this.tester.getDialog().getWebClient().clearCookies();
        response = this.GET("/rest/api/latest/issue/" + key, MapBuilder.newBuilder().add("Cookie", "JSESSIONID=" + jsessionId).toImmutableMap());
        Assert.assertThat((Object)response.getResponseCode(), IsEqual.equalTo(200));
        JSONObject issue = new JSONObject(response.getText());
        TestLogin.assertTrue((boolean)issue.has("key"));
    }

    public void testLoginsThatAreDeniedDueToCaptchaProtectionShouldReturn403() throws Exception {
        this.navigation.logout();
        WebResponse response = this.provokeCaptchaFailure(this.fredBadCredentials);
        Assert.assertThat((Object)response.getResponseCode(), IsEqual.equalTo(403));
        Assert.assertThat((Object)response, HeaderValue.header(X_AUTHENTICATION_DENIED_REASON, IsEqual.equalTo(String.format("CAPTCHA_CHALLENGE; login-url=%s", this.getBaseUrlPlus("login.jsp")))));
    }

    public void testCaptchaFailureWithWrongPasswordIsIdenticalToCaptchaFailureWithRightPassword() throws Exception {
        this.navigation.logout();
        WebResponse wrongPassResponse = this.provokeCaptchaFailure(this.fredBadCredentials);
        WebResponse rightPassResponse = this.loginAs(this.fredGoodCredentials);
        Assert.assertThat((Object)rightPassResponse.getHeaderField(X_AUTHENTICATION_DENIED_REASON), IsEqual.equalTo(wrongPassResponse.getHeaderField(X_AUTHENTICATION_DENIED_REASON)));
    }

    protected WebResponse loginAs(JSONObject json) throws IOException, SAXException {
        return this.POST("/rest/auth/latest/session", json);
    }

    protected WebResponse provokeCaptchaFailure(JSONObject badCredentials) throws IOException, SAXException {
        WebResponse response;
        int tries = 10;
        do {
            response = this.loginAs(badCredentials);
            this.navigation.logout();
        } while (response.getResponseCode() == 401 && --tries > 0);
        if (tries == 0) {
            TestLogin.fail((String)String.format("Captcha did not kick in after %d failed logins", 10));
        }
        return response;
    }

    public void testLogout() throws Exception {
        this.navigation.login("admin");
        WebResponse response = this.DELETE("/rest/auth/latest/session");
        TestLogin.assertEquals((int)204, (int)response.getResponseCode());
        response = this.DELETE("/rest/auth/latest/session");
        TestLogin.assertEquals((int)401, (int)response.getResponseCode());
    }
}

