/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Issue;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.User;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Watchers;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.WatchersClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.matcher.HasErrorMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceWatchers
extends RestFuncTest {
    private static final String TEST_XML = "TestIssueResourceWatchers.xml";
    private final String loginUser = "fred";
    private final String slashName = "kelpie/trevor";
    private final String anotherUser = "luser";
    private IssueClient issueClient;
    private WatchersClient watchersClient;

    public void testWatchingDisabled() throws Exception {
        this.restoreData(false);
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        TestIssueResourceWatchers.assertNull(issue.fields.watcher);
    }

    public void testViewWatchersRequestExpanded() throws Exception {
        this.restoreData(true);
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        TestIssueResourceWatchers.assertEquals((String)"HSP-1", (String)issue.key);
        TestIssueResourceWatchers.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-1/watchers"), (String)((Watchers)issue.fields.watcher.value).self);
    }

    public void testViewWatchersNoPermissionToViewButCanStillSeeCount() throws Exception {
        this.restoreData(true);
        Issue issue = ((IssueClient)this.issueClient.loginAs("luser")).get("HSP-1", new Issue.Expand[0]);
        TestIssueResourceWatchers.assertEquals((String)"HSP-1", (String)issue.key);
        TestIssueResourceWatchers.assertEquals((long)2L, (long)((Watchers)issue.fields.watcher.value).watchCount);
    }

    public void testViewWatchersNoPermissionToViewButCanStillSeeMyselfAndCount() throws Exception {
        this.restoreData(true);
        Issue issue = ((IssueClient)this.issueClient.loginAs("luser")).get("HSP-2", new Issue.Expand[0]);
        TestIssueResourceWatchers.assertEquals((String)"HSP-2", (String)issue.key);
        Watchers watchers = (Watchers)issue.fields.watcher.value;
        TestIssueResourceWatchers.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-2/watchers"), (String)watchers.self);
        TestIssueResourceWatchers.assertEquals((long)2L, (long)watchers.watchCount);
    }

    public void testViewWatchersIsWatching() throws Exception {
        this.restoreData(true);
        Issue issue = ((IssueClient)this.issueClient.loginAs("luser")).get("HSP-2", new Issue.Expand[0]);
        TestIssueResourceWatchers.assertEquals((String)"HSP-2", (String)issue.key);
        Watchers watchers = (Watchers)issue.fields.watcher.value;
        TestIssueResourceWatchers.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-2/watchers"), (String)watchers.self);
        TestIssueResourceWatchers.assertTrue((boolean)watchers.isWatching);
    }

    public void testViewWatchersIsNotWatching() throws Exception {
        this.restoreData(true);
        Issue issue = ((IssueClient)this.issueClient.loginAs("luser")).get("HSP-1", new Issue.Expand[0]);
        TestIssueResourceWatchers.assertEquals((String)"HSP-1", (String)issue.key);
        Watchers watchers = (Watchers)issue.fields.watcher.value;
        TestIssueResourceWatchers.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-1/watchers"), (String)watchers.self);
        TestIssueResourceWatchers.assertFalse((boolean)watchers.isWatching);
    }

    public void testWatchers_Anonymous() throws Exception {
        this.restoreData(true);
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(10, "");
        Watchers watchers = ((WatchersClient)this.watchersClient.anonymous()).get("HSP-1");
        TestIssueResourceWatchers.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-1/watchers"), (String)watchers.self);
        TestIssueResourceWatchers.assertEquals((long)2L, (long)watchers.watchCount);
        TestIssueResourceWatchers.assertFalse((boolean)watchers.isWatching);
        TestIssueResourceWatchers.assertEquals((int)0, (int)watchers.watchers.size());
    }

    public void testViewWatchersSubresourceExpanded() throws Exception {
        this.restoreData(true);
        Watchers watchers = this.watchersClient.get("HSP-1");
        TestIssueResourceWatchers.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-1/watchers"), (String)watchers.self);
        List<User> watcherList = watchers.watchers;
        TestIssueResourceWatchers.assertEquals((int)2, (int)watcherList.size());
        ArrayList<String> names = new ArrayList<String>();
        for (User watcher : watcherList) {
            names.add(watcher.name);
        }
        TestIssueResourceWatchers.assertTrue((boolean)names.contains("fred"));
        TestIssueResourceWatchers.assertTrue((boolean)names.contains("admin"));
    }

    public void testViewWatchersSubresourceExpandedIssueDoesNotExist() throws Exception {
        this.restoreData(true);
        Response response = this.watchersClient.getResponse("HSP-999");
        TestIssueResourceWatchers.assertEquals((int)404, (int)response.statusCode);
    }

    public void testAddWatchWhenWatchingIsDisabled() throws Exception {
        this.restoreData(false);
        Response resp = ((WatchersClient)this.watchersClient.loginAs("fred")).postResponse("HSP-2", "fred");
        TestIssueResourceWatchers.assertEquals((int)404, (int)resp.statusCode);
    }

    public void testAddWatchToIssueThatDoesNotExist() throws Exception {
        this.restoreData(true);
        Response resp = ((WatchersClient)this.watchersClient.loginAs("fred")).postResponse("HSP-999", "fred");
        TestIssueResourceWatchers.assertEquals((int)404, (int)resp.statusCode);
    }

    public void testAddWatchToIssueThatIAmAlreadyWatching() throws Exception {
        this.restoreData(true);
        Response resp = ((WatchersClient)this.watchersClient.loginAs("fred")).postResponse("HSP-1", "fred");
        TestIssueResourceWatchers.assertEquals((int)204, (int)resp.statusCode);
    }

    public void testAddWatchToIssue() throws Exception {
        this.restoreData(true);
        Response resp = ((WatchersClient)this.watchersClient.loginAs("fred")).postResponse("HSP-2", "fred");
        TestIssueResourceWatchers.assertEquals((int)204, (int)resp.statusCode);
        TestIssueResourceWatchers.assertTrue((boolean)this.isWatching("HSP-2", "fred"));
    }

    public void testAddWatchToIssue_emptyPOST() throws Exception {
        this.restoreData(true);
        Response resp = ((WatchersClient)this.watchersClient.loginAs("fred")).postResponse("HSP-2", null);
        TestIssueResourceWatchers.assertEquals((int)204, (int)resp.statusCode);
        TestIssueResourceWatchers.assertTrue((boolean)this.isWatching("HSP-2", "fred"));
    }

    public void testAddWatchForAnotherUser() throws Exception {
        this.restoreData(true);
        Response resp = ((WatchersClient)this.watchersClient.loginAs("luser")).postResponse("HSP-2", "fred");
        TestIssueResourceWatchers.assertEquals((int)401, (int)resp.statusCode);
    }

    public void testRemoveWatchWhenWatchingIsDisabled() throws Exception {
        this.restoreData(false);
        Response resp = ((WatchersClient)this.watchersClient.loginAs("fred")).deleteResponse("HSP-2", "fred");
        TestIssueResourceWatchers.assertEquals((int)404, (int)resp.statusCode);
    }

    public void testRemoveWatchToIssueThatDoesNotExist() throws Exception {
        this.restoreData(true);
        Response resp = ((WatchersClient)this.watchersClient.loginAs("fred")).deleteResponse("HSP-999", "fred");
        TestIssueResourceWatchers.assertEquals((int)404, (int)resp.statusCode);
    }

    public void testRemoveWatchFromIssueThatIAmNotWatching() throws Exception {
        this.restoreData(true);
        TestIssueResourceWatchers.assertFalse((boolean)this.isWatching("HSP-2", "fred"));
        Response resp = ((WatchersClient)this.watchersClient.loginAs("fred")).deleteResponse("HSP-2", "fred");
        TestIssueResourceWatchers.assertEquals((int)204, (int)resp.statusCode);
        TestIssueResourceWatchers.assertFalse((boolean)this.isWatching("HSP-2", "fred"));
    }

    public void testRemoveWatchForAnotherUser_Denied() throws Exception {
        this.restoreData(true);
        Response resp = ((WatchersClient)this.watchersClient.loginAs("luser")).deleteResponse("HSP-2", "fred");
        TestIssueResourceWatchers.assertEquals((int)401, (int)resp.statusCode);
        Assert.assertThat((Object)resp, HasErrorMessage.hasErrorMessage("User 'luser' is not allowed to remove watchers from issue 'HSP-2'"));
    }

    public void testRemoveWatchForAnotherUser_Allowed() throws Exception {
        this.restoreData(true);
        Response resp = this.watchersClient.deleteResponse("HSP-2", "fred");
        TestIssueResourceWatchers.assertEquals((int)204, (int)resp.statusCode);
        TestIssueResourceWatchers.assertFalse((boolean)this.isWatching("HSP-2", "fred"));
    }

    public void testRemoveWatch() throws Exception {
        this.restoreData(true);
        TestIssueResourceWatchers.assertTrue((boolean)this.isWatching("HSP-1", "fred"));
        Response resp = this.watchersClient.deleteResponse("HSP-1", "fred");
        TestIssueResourceWatchers.assertEquals((int)204, (int)resp.statusCode);
        TestIssueResourceWatchers.assertFalse((boolean)this.isWatching("HSP-1", "fred"));
    }

    public void testSlashNamesWatchIssue() throws Exception {
        this.restoreData(true);
        Response resp = this.watchersClient.postResponse("HSP-2", "kelpie/trevor");
        TestIssueResourceWatchers.assertEquals((int)204, (int)resp.statusCode);
        TestIssueResourceWatchers.assertTrue((boolean)this.isWatching("HSP-2", "kelpie/trevor"));
        resp = this.watchersClient.deleteResponse("HSP-2", "kelpie/trevor");
        TestIssueResourceWatchers.assertEquals((int)204, (int)resp.statusCode);
        TestIssueResourceWatchers.assertFalse((boolean)this.isWatching("HSP-2", "kelpie/trevor"));
    }

    public void testAddingOrRemovingWatcherFromIssuesThatIAmNotAllowedToSeeReturns401() throws Exception {
        this.restoreData(true);
        Response addResponse = ((WatchersClient)this.watchersClient.anonymous()).postResponse("HSP-1", "fred");
        Assert.assertThat((Object)addResponse.statusCode, IsEqual.equalTo(401));
        Assert.assertThat((Object)addResponse, HasErrorMessage.hasErrorMessage("You do not have the permission to see the specified issue"));
        Response delResponse = ((WatchersClient)this.watchersClient.anonymous()).deleteResponse("HSP-1", "fred");
        Assert.assertThat((Object)delResponse.statusCode, IsEqual.equalTo(401));
        Assert.assertThat((Object)addResponse, HasErrorMessage.hasErrorMessage("You do not have the permission to see the specified issue"));
        addResponse = ((WatchersClient)this.watchersClient.loginAs("jack")).postResponse("HSP-1", "fred");
        Assert.assertThat((Object)addResponse.statusCode, IsEqual.equalTo(401));
        Assert.assertThat((Object)addResponse, HasErrorMessage.hasErrorMessage("User 'jack' is not allowed to add watchers to issue 'HSP-1'"));
        delResponse = ((WatchersClient)this.watchersClient.loginAs("jack")).deleteResponse("HSP-1", "fred");
        Assert.assertThat((Object)delResponse.statusCode, IsEqual.equalTo(401));
        Assert.assertThat((Object)delResponse, HasErrorMessage.hasErrorMessage("User 'jack' is not allowed to remove watchers from issue 'HSP-1'"));
    }

    protected boolean isWatching(String issueKey, String username) {
        Watchers watchers = this.watchersClient.get(issueKey);
        for (User watcher : watchers.watchers) {
            if (!username.equals(watcher.name)) continue;
            return true;
        }
        return false;
    }

    protected void restoreData(boolean watchingEnabled) throws IOException {
        this.administration.restoreData(TEST_XML);
        if (!watchingEnabled) {
            this.administration.generalConfiguration().disableWatching();
        }
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient(this.getEnvironmentData());
        this.watchersClient = new WatchersClient(this.getEnvironmentData());
    }
}

