/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Issue;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.TimeTracking;
import java.io.IOException;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceTimeTracking
extends RestFuncTest {
    private IssueClient issueClient;

    public void testTimeTrackingDisabled() throws Exception {
        this.restoreData(false);
        Issue issue = this.issueClient.get("FUNC-3", new Issue.Expand[0]);
        TestIssueResourceTimeTracking.assertNull((String)"Time tracking shouldn't be in response when time tracking is disabled", issue.fields.timetracking);
    }

    public void testIssueWithNoTimeTracking() throws Exception {
        Issue issue = this.issueClient.get("FUNC-1", new Issue.Expand[0]);
        TestIssueResourceTimeTracking.assertNull((String)"Time tracking shouldn't exist for FUNC-1", issue.fields.timetracking);
    }

    public void testIssueWithOriginalEstimate() throws Exception {
        this.restoreData(true);
        Issue issue = this.issueClient.get("FUNC-3", new Issue.Expand[0]);
        TestIssueResourceTimeTracking.assertNotNull(issue.fields.timetracking);
        TestIssueResourceTimeTracking.assertEquals((long)1440L, (long)((TimeTracking)issue.fields.timetracking.value).timeoriginalestimate);
    }

    public void testIssueWithTimeSpent() throws Exception {
        this.restoreData(true);
        Issue issue = this.issueClient.get("FUNC-3", new Issue.Expand[0]);
        TestIssueResourceTimeTracking.assertNotNull(issue.fields.timetracking);
        TestIssueResourceTimeTracking.assertEquals((long)480L, (long)((TimeTracking)issue.fields.timetracking.value).timespent);
    }

    public void testIssueWithTimeRemaining() throws Exception {
        this.restoreData(true);
        Issue issue = this.issueClient.get("FUNC-3", new Issue.Expand[0]);
        TestIssueResourceTimeTracking.assertNotNull(issue.fields.timetracking);
        TestIssueResourceTimeTracking.assertEquals((long)960L, (long)((TimeTracking)issue.fields.timetracking.value).timeestimate);
    }

    protected void restoreData(boolean timeTrackingEnabled) throws IOException {
        this.administration.restoreData("TestIssueResourceTimeTracking.xml");
        if (!timeTrackingEnabled) {
            this.administration.timeTracking().disable();
        }
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient(this.getEnvironmentData());
    }
}

