/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Issue;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueLink;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceSubtasks
extends RestFuncTest {
    private IssueClient issueClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient(this.getEnvironmentData());
        this.administration.restoreData("TestIssueResourceSubtasks.xml");
    }

    public void testSubtaskLink() throws Exception {
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        List subtasks = (List)issue.fields.subtasks.value;
        TestIssueResourceSubtasks.assertEquals((int)1, (int)subtasks.size());
        String baseUrl = this.getEnvironmentData().getBaseUrl().toExternalForm();
        IssueLink lnkHsp2 = (IssueLink)subtasks.get(0);
        TestIssueResourceSubtasks.assertEquals((String)"HSP-2", (String)lnkHsp2.issueKey);
        TestIssueResourceSubtasks.assertEquals((String)(baseUrl + "/rest/api/2.0.alpha1/issue/HSP-2"), (String)lnkHsp2.issue);
        TestIssueResourceSubtasks.assertEquals((String)"Sub-Task", (String)lnkHsp2.type.name);
    }

    public void testParentLink() throws Exception {
        Issue issue = this.issueClient.get("HSP-2", new Issue.Expand[0]);
        String baseUrl = this.getEnvironmentData().getBaseUrl().toExternalForm();
        IssueLink parent = (IssueLink)issue.fields.parent.value;
        TestIssueResourceSubtasks.assertEquals((String)"HSP-1", (String)parent.issueKey);
        TestIssueResourceSubtasks.assertEquals((String)(baseUrl + "/rest/api/2.0.alpha1/issue/HSP-1"), (String)parent.issue);
        TestIssueResourceSubtasks.assertEquals((String)"Parent", (String)parent.type.name);
    }
}

