/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Issue;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Priority;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.User;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceNoPrioritySet
extends RestFuncTest {
    private IssueClient issueClient;

    public void testUnassignedIssueHasNoValue() throws Exception {
        Issue issue = this.issueClient.get("TST-2", new Issue.Expand[0]);
        TestIssueResourceNoPrioritySet.assertNull(issue.fields.priority.value);
        TestIssueResourceNoPrioritySet.assertNull(issue.fields.reporter.value);
        Issue issue2 = this.issueClient.get("TST-1", new Issue.Expand[0]);
        TestIssueResourceNoPrioritySet.assertEquals((String)"Blocker", (String)((Priority)issue2.fields.priority.value).name);
        TestIssueResourceNoPrioritySet.assertEquals((String)"admin", (String)((User)issue2.fields.reporter.value).name);
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Priority");
        TestIssueResourceNoPrioritySet.assertNull(this.issueClient.get((String)"TST-2", (Issue.Expand[])new Issue.Expand[0]).fields.priority);
        TestIssueResourceNoPrioritySet.assertNull(this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.priority);
        TestIssueResourceNoPrioritySet.assertNull(this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.duedate.value);
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Due Date");
        TestIssueResourceNoPrioritySet.assertNull(this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.duedate);
        this.administration.fieldConfigurations().defaultFieldConfiguration().showFields("Due Date");
        this.navigation.issue().setDueDate("TST-1", "10/May/11");
        TestIssueResourceNoPrioritySet.assertTrue((boolean)((String)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.duedate.value).startsWith("2011-05-"));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestIssueResourceNoPrioritySet.xml");
        this.issueClient = new IssueClient(this.getEnvironmentData());
    }
}

