/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Issue;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueLink;
import java.io.IOException;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceIssueLinks
extends RestFuncTest {
    private IssueClient issueClient;

    public void testIssueLinksDisabled() throws Exception {
        this.restoreData(false);
        Issue issue = this.issueClient.get("LNK-4", new Issue.Expand[0]);
        TestIssueResourceIssueLinks.assertNull(issue.fields.links);
    }

    public void testNoIssueLinks() throws Exception {
        this.restoreData(true);
        Issue issue = this.issueClient.get("LNK-5", new Issue.Expand[0]);
        TestIssueResourceIssueLinks.assertEquals((String)"Object should have no issue links", (int)0, (int)((List)issue.fields.links.value).size());
    }

    public void testNoOutwardIssueLinks() throws Exception {
        this.restoreData(true);
        Issue issue = this.issueClient.get("LNK-1", new Issue.Expand[0]);
        List links = (List)issue.fields.links.value;
        for (IssueLink link : links) {
            TestIssueResourceIssueLinks.assertEquals((String)"INBOUND", (String)link.type.direction);
        }
    }

    public void testNoVisibleLinks() throws Exception {
        this.restoreData(true);
        Issue issue = ((IssueClient)this.issueClient.loginAs("reporter")).get("LNK-2", new Issue.Expand[0]);
        TestIssueResourceIssueLinks.assertEquals((String)"Object should have no visible issue links", (int)0, (int)((List)issue.fields.links.value).size());
    }

    public void testInvisibleIssueNotShown() throws Exception {
        this.restoreData(true);
        Issue issue = ((IssueClient)this.issueClient.loginAs("reporter")).get("LNK-4", new Issue.Expand[0]);
        List links = (List)issue.fields.links.value;
        TestIssueResourceIssueLinks.assertEquals((int)1, (int)links.size());
        TestIssueResourceIssueLinks.assertEquals((String)"LNK-1", (String)((IssueLink)links.get((int)0)).issueKey);
    }

    public void testSeveralIssueLinks() throws Exception {
        this.restoreData(true);
        Issue issue = this.issueClient.get("LNK-4", new Issue.Expand[0]);
        List links = (List)issue.fields.links.value;
        TestIssueResourceIssueLinks.assertEquals((int)2, (int)links.size());
        if ("LNK-1".equals(((IssueLink)links.get((int)0)).issueKey) && "LNK-3".equals(((IssueLink)links.get((int)1)).issueKey)) {
            return;
        }
        if ("LNK-3".equals(((IssueLink)links.get((int)0)).issueKey) && "LNK-1".equals(((IssueLink)links.get((int)1)).issueKey)) {
            return;
        }
        TestIssueResourceIssueLinks.fail((String)"Issue links LNK-1 and LNK-3 should both be visible");
    }

    public void testIssueLinkMetadataPresent() throws Exception {
        this.restoreData(true);
        Issue issue = ((IssueClient)this.issueClient.loginAs("reporter")).get("LNK-6", new Issue.Expand[0]);
        List links = (List)issue.fields.links.value;
        TestIssueResourceIssueLinks.assertEquals((int)1, (int)links.size());
        IssueLink linktoLnk1 = (IssueLink)links.get(0);
        String baseUrl = this.getEnvironmentData().getBaseUrl().toExternalForm();
        TestIssueResourceIssueLinks.assertEquals((String)"LNK-1", (String)linktoLnk1.issueKey);
        TestIssueResourceIssueLinks.assertEquals((String)(baseUrl + "/rest/api/2.0.alpha1/issue/LNK-1"), (String)linktoLnk1.issue);
        TestIssueResourceIssueLinks.assertEquals((String)"Duplicate", (String)linktoLnk1.type.name);
        TestIssueResourceIssueLinks.assertEquals((String)"OUTBOUND", (String)linktoLnk1.type.direction);
        TestIssueResourceIssueLinks.assertEquals((String)"duplicates", (String)linktoLnk1.type.description);
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient(this.getEnvironmentData());
    }

    private void restoreData(boolean issueLinkingEnabled) throws IOException {
        this.administration.restoreData("TestIssueResourceIssueLinks.xml");
        if (!issueLinkingEnabled) {
            this.administration.issueLinking().disable();
        }
    }
}

